/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.model.vector_service.utfgrid;

import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.model.vector_service.storage.StorageInfoBean;
import com.geoway.vtile.model.vector_service.storage.StorageInfoShell;
import com.geoway.vtile.model.vector_service.utfgrid.IUtfgridInfo;
import com.geoway.vtile.model.vector_service.utfgrid.UtfgridInfoBean;
import com.geoway.vtile.service.client.Client;

public class UtfgridInfoShell
implements IUtfgridInfo {
    UtfgridInfoBean bean;
    IStorageInfo storageInfo;

    public UtfgridInfoShell(Client client, UtfgridInfoBean bean) {
        this.bean = bean;
        StorageInfoBean storageInfoBean = bean.getStorageInfo();
        if (storageInfoBean != null) {
            this.storageInfo = new StorageInfoShell(client, storageInfoBean);
        }
    }

    @Override
    public IDataSourceInService getDataSource() {
        return this.storageInfo.getDataSource();
    }

    @Override
    public UtfgridInfoBean getBean() {
        return this.bean;
    }

    @Override
    public Integer getStartLevel() {
        return this.storageInfo.getStartLevel();
    }

    @Override
    public Integer getEndLevel() {
        return this.storageInfo.getEndLevel();
    }

    @Override
    public String getStorageName() {
        return this.storageInfo.getStorageName();
    }

    @Override
    public Integer getSampling() {
        return this.bean.getSampling();
    }

    @Override
    public String getMergeFields() {
        return this.bean.getMergeFields();
    }

    @Override
    public Integer getPointSimplifyGridSize() {
        return this.bean.getPointSimplifyGridSize();
    }

    @Override
    public Integer getPointSimplifyGird() {
        return this.bean.getPointSimplifyGird();
    }

    @Override
    public String getIgnoreLayer() {
        return this.bean.getIgnoreLayer();
    }

    @Override
    public void drop() {
        if (this.storageInfo != null) {
            this.storageInfo.drop();
        }
    }

    @Override
    public IStorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    @Override
    public void setStorageInfo(IStorageInfo storageInfo) {
        this.storageInfo = storageInfo;
        this.bean.setStorageInfo(storageInfo.getBean());
    }
}

