/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.service.httpstatistic;

import com.geoway.vtile.model.statislog.ClientLog;
import com.geoway.vtile.model.statislog.DomainLog;
import com.geoway.vtile.model.statislog.ServiceLog;
import com.geoway.vtile.model.statislog.StatisticsLog;
import com.geoway.vtile.model.statislog.TrafficLog;
import com.geoway.vtile.service.httpstatistic.AccessLogPO;
import com.geoway.vtile.service.httpstatistic.UAParser;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStatisticIndices {
    private static Logger Log = LoggerFactory.getLogger(HttpStatisticIndices.class);
    private static final int BUFFER_SIZE = 1000;
    private static ArrayList<AccessLogPO> _logCache = new ArrayList(1000);
    private static ArrayList<AccessLogPO> _logCacheBackend = new ArrayList(1000);
    private static final ForkJoinPool myThreadPool = new ForkJoinPool(4);
    private static Map<String, Long> mapClientReqCount = new ConcurrentHashMap<String, Long>();
    private static Map<String, Long> mapClientTotalBytes = new ConcurrentHashMap<String, Long>();
    private static Map<String, AccessLogPO> mapClientExamples = new ConcurrentHashMap<String, AccessLogPO>();
    private static Map<String, Long> mapSvcReqCount = new ConcurrentHashMap<String, Long>();
    private static Map<String, Long> mapSvcTotalTime = new ConcurrentHashMap<String, Long>();
    private static Map<String, Long> mapSvcTotalBytes = new ConcurrentHashMap<String, Long>();
    private static Map<String, AccessLogPO> mapSvcExamples = new ConcurrentHashMap<String, AccessLogPO>();

    public static void consumeAsync(AccessLogPO acclog) {
        try {
            _logCache.add(acclog);
            if (_logCache.size() >= 1000) {
                HttpStatisticIndices.swapCache();
                HttpStatisticIndices.performStatistics();
            }
        }
        catch (Exception ex) {
            Log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static StatisticsLog commitIndices() {
        long reqTotalCount;
        int clientCount = mapClientReqCount.size();
        int svcCount = mapSvcReqCount.size();
        Set<String> cliIps = mapClientReqCount.keySet();
        Set<String> svcNames = mapSvcReqCount.keySet();
        ArrayList<ClientLog> clientLogs = new ArrayList<ClientLog>(clientCount);
        ArrayList<TrafficLog> trafficLogs = new ArrayList<TrafficLog>(clientCount);
        ArrayList<ServiceLog> serviceLogs = new ArrayList<ServiceLog>(svcCount);
        ArrayList<DomainLog> domainLogs = new ArrayList<DomainLog>(svcCount);
        for (String cliIp : cliIps) {
            reqTotalCount = mapClientReqCount.get(cliIp);
            long reqTotalBytes = mapClientTotalBytes.get(cliIp);
            ClientLog clista = new ClientLog();
            clista.setCount(reqTotalCount);
            if (mapClientExamples.containsKey(cliIp)) {
                AccessLogPO acclog = mapClientExamples.get(cliIp);
                UAParser.UserAgentPO ua = UAParser.parseUA(acclog.clientApplication);
                if (null != ua) {
                    clista.setOs(ua.os);
                    clista.setOsVersion(ua.osVersion);
                    clista.setPlatform(ua.cpuArch);
                    clista.setBrowser(ua.browser);
                    clista.setBrowserVersion(ua.browserVersion);
                }
            }
            TrafficLog traff = new TrafficLog();
            traff.setRemoteIp(cliIp);
            traff.setRequestTraffic(reqTotalBytes);
            clientLogs.add(clista);
            trafficLogs.add(traff);
        }
        for (String svc : svcNames) {
            reqTotalCount = mapSvcReqCount.get(svc);
            long reqTotalTimeMs = mapSvcTotalTime.get(svc);
            long reqTotalBytes = mapSvcTotalBytes.get(svc);
            AccessLogPO exampleLog = mapSvcExamples.get(svc);
            ServiceLog svcsta = new ServiceLog();
            svcsta.setServiceName(svc);
            long avgBytes = reqTotalBytes / reqTotalCount;
            long avgTimeMs = reqTotalTimeMs / reqTotalCount;
            svcsta.setResponseBytes(avgBytes);
            svcsta.setResponseTime(avgTimeMs);
            svcsta.setSuccess(reqTotalCount);
            DomainLog domainsta = new DomainLog();
            domainsta.setServerName(svc);
            domainsta.setUrl(exampleLog.refer);
            domainsta.setCount(reqTotalCount);
            serviceLogs.add(svcsta);
            domainLogs.add(domainsta);
        }
        mapClientExamples.clear();
        mapClientReqCount.clear();
        mapClientTotalBytes.clear();
        mapSvcExamples.clear();
        mapSvcReqCount.clear();
        mapSvcTotalTime.clear();
        mapSvcTotalBytes.clear();
        StatisticsLog statisBean = new StatisticsLog();
        statisBean.setClientLogs(clientLogs);
        statisBean.setTrafficLogs(trafficLogs);
        statisBean.setServiceLogs(serviceLogs);
        statisBean.setDomainLogs(domainLogs);
        Log.info("\u63d0\u4ea4\u7edf\u8ba1\u65e5\u5fd7\u3002 1\u53f7\u524d\u53f0\u961f\u5217\uff1a{}\uff0c 2\u53f7\u540e\u5907\u961f\u5217\uff1a{}", (Object)_logCache.size(), (Object)_logCacheBackend.size());
        return statisBean;
    }

    public static void flushBuffer() {
        try {
            if (0 == _logCache.size()) {
                return;
            }
            HttpStatisticIndices.swapCache();
            HttpStatisticIndices.performStatistics();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void swapCache() throws Exception {
        ArrayList<AccessLogPO> back = _logCacheBackend;
        int times = 0;
        int maxTimes = 10;
        boolean timedOut = false;
        while (back.size() > 0) {
            Thread.sleep(100L);
            if (++times < maxTimes) continue;
            timedOut = true;
            Log.warn("SwapCache TIMEOUT, Maximum times exceeded, alreay tried " + times + " times");
            break;
        }
        if (timedOut) {
            Log.info("Timed out, locking");
            ArrayList<AccessLogPO> arrayList = _logCacheBackend;
            synchronized (arrayList) {
                Log.info("Lock acquired. front:{}, back:{}", (Object)_logCache.size(), (Object)_logCacheBackend.size());
                _logCacheBackend = _logCache;
                _logCache = back;
            }
        } else {
            _logCacheBackend = _logCache;
            _logCache = back;
        }
        if (_logCacheBackend.size() > 1000 && _logCache.size() > 1000) {
            Log.error("access logs double_buffer overflowed, the batch of logs will be abandoned");
            _logCacheBackend.clear();
        }
    }

    private static void performStatistics() {
        CompletableFuture.runAsync(() -> {
            try {
                ArrayList<AccessLogPO> arrayList = _logCacheBackend;
                synchronized (arrayList) {
                    HttpStatisticIndices.reduceClient();
                    HttpStatisticIndices.reduceService();
                    _logCacheBackend.clear();
                }
                ForkJoinPool pool = myThreadPool;
                int waitingTasks = pool.getQueuedSubmissionCount();
                int runningTasks = pool.getActiveThreadCount();
                if (waitingTasks > 10) {
                    Log.warn("LogProcessing Pool tasks, running:{}, queuing:{}", (Object)runningTasks, (Object)waitingTasks);
                }
            }
            catch (Exception ex) {
                Log.error(ex.getMessage(), (Throwable)ex);
            }
        }, myThreadPool);
    }

    private static void reduceClient() {
        ArrayList<AccessLogPO> logs = _logCacheBackend;
        if (0 == logs.size()) {
            return;
        }
        logs.stream().forEach(acclog -> {
            String ip = acclog.clientIp;
            Long bytes = acclog.contentLength;
            if (!mapClientReqCount.containsKey(ip)) {
                mapClientReqCount.put(ip, 1L);
            } else {
                mapClientReqCount.put(ip, mapClientReqCount.get(ip) + 1L);
            }
            if (!mapClientTotalBytes.containsKey(ip)) {
                mapClientTotalBytes.put(ip, bytes);
            } else {
                mapClientTotalBytes.put(ip, mapClientTotalBytes.get(ip) + bytes);
            }
            if (!mapClientExamples.containsKey(ip)) {
                mapClientExamples.put(ip, (AccessLogPO)acclog);
            }
        });
    }

    private static void reduceService() {
        ArrayList<AccessLogPO> logs = _logCacheBackend;
        if (0 == logs.size()) {
            return;
        }
        logs.stream().forEach(acclog -> {
            String svcName = acclog.vtileServiceName;
            Long timeMs = acclog.costTimeMs;
            Long bytes = acclog.contentLength;
            if (!mapSvcReqCount.containsKey(svcName)) {
                mapSvcReqCount.put(svcName, 1L);
            } else {
                mapSvcReqCount.put(svcName, mapSvcReqCount.get(svcName) + 1L);
            }
            if (!mapSvcTotalTime.containsKey(svcName)) {
                mapSvcTotalTime.put(svcName, timeMs);
            } else {
                mapSvcTotalTime.put(svcName, mapSvcTotalTime.get(svcName) + timeMs);
            }
            if (!mapSvcTotalBytes.containsKey(svcName)) {
                mapSvcTotalBytes.put(svcName, bytes);
            } else {
                mapSvcTotalBytes.put(svcName, mapSvcTotalBytes.get(svcName) + bytes);
            }
            if (!mapSvcExamples.containsKey(svcName)) {
                mapSvcExamples.put(svcName, (AccessLogPO)acclog);
            }
        });
    }
}

