/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.service.httpstatistic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UAParser {
    private static final String regBrowserChrome = "\\b(?:Chrome)\\/([\\w\\.]+)";
    private static final String regBrowserOther = "^([\\w]+)\\/([\\d\\.]+)$";
    private static final String regOSWindows = "(?:Windows)\\s([^\\)]+)";
    private static final Pattern patternBrowser = Pattern.compile("\\b(?:Chrome)\\/([\\w\\.]+)", 2);
    private static final Pattern patternBrowserOther = Pattern.compile("^([\\w]+)\\/([\\d\\.]+)$", 2);
    private static final Pattern patternOS = Pattern.compile("(?:Windows)\\s([^\\)]+)", 2);

    public static UserAgentPO parseUA(String strUserAgent) {
        if (StringUtils.isEmpty((CharSequence)strUserAgent)) {
            return null;
        }
        UserAgentPO ua = new UserAgentPO();
        try {
            Matcher matcher = patternBrowser.matcher(strUserAgent);
            if (matcher.find()) {
                ua.browser = "Chrome";
                ua.browserVersion = matcher.group(1);
            } else {
                matcher = patternBrowserOther.matcher(strUserAgent);
                if (matcher.find()) {
                    ua.browser = matcher.group(1);
                    ua.browserVersion = matcher.group(2);
                }
            }
            matcher = patternOS.matcher(strUserAgent);
            if (matcher.find()) {
                ua.os = "Windows";
                String ver = matcher.group(1);
                if (ver.contains(";")) {
                    String[] tokens = ver.split("; ");
                    ua.osVersion = tokens[0];
                    ua.cpuArch = tokens[tokens.length - 1];
                } else {
                    ua.osVersion = ver;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ua;
    }

    public static class UserAgentPO {
        public String os = "UNKNOWN";
        public String osVersion;
        public String cpuArch = "-";
        public String browser = "UNKNOWN";
        public String browserVersion;
    }
}

