/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.service.mapserver;

import com.geoway.vtile.service.mapserver.MapserverAccessException;
import com.geoway.vtile.tools.AbnormalCheck.MapserverCheck;
import com.geoway.vtile.tools.net.HttpRequestUtils;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class MapServerAccess {
    public static final String CHARSET_UTF_8 = "utf-8";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/xml";
    public static final String CONTENT_TYPE_FORM_URL = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_JSON_URL = "application/json;charset=utf-8";
    private PoolingHttpClientConnectionManager pool;
    private RequestConfig requestConfig;
    private static String urlPrifix;
    protected static final String SAVE_STYLE_URL = "/styleInfo/save.do";
    public static final String createMergeGridUrl = "%s/%s/build/mergeGrid?x=%s&y=%s&l=%s";
    public static final String createUtfGridUrl = "%s/%s/build/createGrid?x=%s&y=%s&l=%s";
    protected static final String ACCESS_ERROR_MESSAGE = "\u6e32\u67d3\u5f15\u64ce\u8bbf\u95ee\u5f02\u5e38";

    public MapServerAccess(int maxTotal, int timeout) {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(MapServerAccess.createIgnoreVerifySSL())).build();
        this.pool = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        this.pool.setMaxTotal(maxTotal);
        this.pool.setDefaultMaxPerRoute(maxTotal);
        this.requestConfig = RequestConfig.custom().setSocketTimeout(Integer.MAX_VALUE).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build();
    }

    private CloseableHttpClient getHttpClient() {
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.pool).setDefaultRequestConfig(this.requestConfig).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(2, true)).build();
        return httpClient;
    }

    private static String sendHttpPost(HttpPost httpPost) throws MapserverAccessException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() >= 300) {
                throw new Exception("HTTP Request is not success, Response code is " + response.getStatusLine().getStatusCode() + ", error:" + responseContent);
            }
            if (200 == response.getStatusLine().getStatusCode()) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)CHARSET_UTF_8);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MapserverAccessException("\u8bf7\u6c42Mapserver\u5f15\u64ce\u51fa\u9519: " + e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }

    private String sendHttpGet(HttpGet httpGet) throws MapserverAccessException {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String responseContent = null;
        try {
            httpClient = this.getHttpClient();
            httpGet.setConfig(this.requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() >= 300) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)CHARSET_UTF_8);
                EntityUtils.consume((HttpEntity)entity);
                throw new Exception("HTTP Request is not success, Response code is " + response.getStatusLine().getStatusCode() + ", error:" + responseContent);
            }
            if (200 == response.getStatusLine().getStatusCode()) {
                responseContent = EntityUtils.toString((HttpEntity)entity, (String)CHARSET_UTF_8);
                EntityUtils.consume((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MapserverAccessException("\u8bf7\u6c42\u51fa\u9519:" + e.getMessage());
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }

    public static String saveStyle(String belongService, String styleId, String styleJson) throws MapserverAccessException {
        String[] names = new String[]{"ownServer", "name", "desc", "styleJson"};
        String[] values = new String[]{belongService, styleId, "", styleJson};
        MapserverCheck.getInst(urlPrifix).check();
        HttpPost request = HttpRequestUtils.buildUrlEncodedRequest(urlPrifix + SAVE_STYLE_URL, names, values);
        String result = MapServerAccess.sendHttpPost(request);
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new MapserverAccessException(ACCESS_ERROR_MESSAGE);
        }
        return result;
    }

    public static String saveStyle(String belongService, String styleId, String styleJson, Double xmin, Double ymin, Double xmax, Double ymax) throws MapserverAccessException {
        String[] names = new String[]{"ownServer", "name", "desc", "styleJson", "xmin", "ymin", "xmax", "ymax"};
        String[] values = new String[]{belongService, styleId, "", styleJson, xmin + "", ymin + "", xmax + "", ymax + ""};
        MapserverCheck.getInst(urlPrifix).check();
        HttpPost request = HttpRequestUtils.buildUrlEncodedRequest(urlPrifix + SAVE_STYLE_URL, names, values);
        String result = MapServerAccess.sendHttpPost(request);
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new MapserverAccessException(ACCESS_ERROR_MESSAGE);
        }
        return result;
    }

    public String sendHttpGet(String httpUrl) throws MapserverAccessException {
        HttpGet httpGet = new HttpGet(httpUrl);
        return this.sendHttpGet(httpGet);
    }

    public static SSLContext createIgnoreVerifySSL() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSLv3");
            X509TrustManager trustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            sc.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return sc;
    }

    public static void setUrlPrifix(String urlPrifix) {
        MapServerAccess.urlPrifix = urlPrifix;
    }

    public String getUrlPrifix() {
        return urlPrifix;
    }

    public static enum ImgCacheType {
        label("/label/%s/getImg?styleId=%s&tilesize=%d&x=%d&y=%d&l=%d&ratio=%d"),
        layer("/layer/%s/getMap?styleId=%s&tilesize=%d&x=%d&y=%d&l=%d&ratio=%d"),
        all("/all/%s/getMap?styleId=%s&tilesize=%d&x=%d&y=%d&l=%d&ratio=%d");

        String templateUrl;

        private ImgCacheType(String url) {
            this.templateUrl = url;
        }

        public String getTemplateUrl() {
            return this.templateUrl;
        }
    }
}

