/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.service.netty.websocket;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.geoway.vtile.commons.reflect.Bean;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.manager.IClientManager;
import com.geoway.vtile.manager.cell.ITileDataCellManager;
import com.geoway.vtile.manager.data_service.IDataServiceManager;
import com.geoway.vtile.manager.data_sources.IDataSourcesManager;
import com.geoway.vtile.manager.font.IFontManager;
import com.geoway.vtile.manager.node.INodeManager;
import com.geoway.vtile.manager.style.IStyleManager;
import com.geoway.vtile.manager.texture.ITextureManager;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.service.client.Client;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketFrameHandler.class);
    private static int HIGH_WATER_SIZE = 0x10000000;
    private Client client;
    private HashMap<String, Method> methodMap;
    private HashMap<String, IClientManager> managerMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        byte[] markByte = null;
        String methodKey = null;
        try {
            byte[] bytedata;
            if (frame instanceof TextWebSocketFrame) {
                String str = ((TextWebSocketFrame)frame).text();
                JSONArray arr = JSON.parseArray((String)str);
                List params = arr.subList(0, arr.size() - 2);
                String markId = (String)arr.get(arr.size() - 1);
                methodKey = (String)arr.get(arr.size() - 2);
                String managerName = methodKey.substring(0, methodKey.indexOf("_"));
                IClientManager manager = this.managerMap.get(managerName);
                Method method = this.methodMap.get(methodKey);
                markByte = markId.getBytes("utf-8");
                if (method.getReturnType().getName().equals("void")) {
                    params.add(ctx);
                    params.add(markByte);
                }
                Object result = null;
                if (params.size() == 0) {
                    result = method.invoke((Object)manager, new Object[0]);
                } else {
                    try {
                        result = method.invoke((Object)manager, (Object[])params.stream().toArray(Object[]::new));
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        StringWriter sw = new StringWriter();
                        String stackTrace = null;
                        try (PrintWriter pw = new PrintWriter(sw);){
                            e.printStackTrace(pw);
                            stackTrace = methodKey + "\u6267\u884c\u51fa\u73b0\u5f02\u5e38\uff1a" + sw.toString();
                        }
                        ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {0}, stackTrace.getBytes("utf-8")})));
                    }
                }
                if (method.getReturnType().getName().equals("void")) {
                    return;
                }
                bytedata = new byte[]{};
                if (result instanceof byte[]) {
                    bytedata = (byte[])result;
                } else if (result instanceof String) {
                    bytedata = ((String)result).getBytes("utf-8");
                } else if (result instanceof Boolean) {
                    bytedata = String.valueOf(result).getBytes("utf-8");
                }
                if (Log4jUtil.isDiagnoseEnable() && bytedata.length > HIGH_WATER_SIZE) {
                    logger.warn("\u5f53\u524d\u76f4\u8fde\u8bf7\u6c42 {} \u7684\u6570\u636e\u91cf\u8f83\u5927\uff1a{} \uff01 \u53c2\u6570\uff1a{}", new Object[]{methodKey, bytedata.length, str});
                }
            } else {
                String message = "unsupported frame type: " + frame.getClass().getName();
                throw new UnsupportedOperationException(message);
            }
            ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {1}, bytedata})));
        }
        catch (Exception e) {
            logger.error(methodKey + "java\u8bf7\u6c42\u51fa\u9519\uff1a" + e.getMessage());
            StringWriter sw = new StringWriter();
            String stackTrace = null;
            try (PrintWriter pw = new PrintWriter(sw);){
                e.printStackTrace(pw);
                stackTrace = sw.toString();
            }
            ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[][])new byte[][]{markByte, {0}, stackTrace.getBytes("utf-8")})));
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.error("ws\u5ba2\u6237\u7aef\u5df2\u65ad\u5f00\u8fde\u63a5: " + ctx.channel().remoteAddress());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            System.err.println(cause.getMessage());
        } else {
            cause.printStackTrace();
        }
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void init() {
        try {
            this.methodMap = new HashMap();
            this.managerMap = new HashMap();
            IDataSourcesManager dataSourcesManager = this.client.getDataSourcesManager();
            this.managerMap.put("IDataSourcesManager", dataSourcesManager);
            Method[] methods = Bean.getDeclaredMethods(IDataSourcesManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("IDataSourcesManager_" + method.getName(), method);
            }
            IDataServiceManager dataServiceManager = this.client.getDataServiceManager();
            this.managerMap.put("IDataServiceManager", dataServiceManager);
            methods = Bean.getDeclaredMethods(IDataServiceManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("IDataServiceManager_" + method.getName(), method);
            }
            IVectorServiceManager vectorServiceManager = this.client.getVectorServiceManager();
            this.managerMap.put("IVectorServiceManager", vectorServiceManager);
            methods = Bean.getDeclaredMethods(IVectorServiceManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("IVectorServiceManager_" + method.getName(), method);
            }
            IStyleManager styleManager = this.client.getStyleManager();
            this.managerMap.put("IStyleManager", styleManager);
            methods = Bean.getDeclaredMethods(IStyleManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("IStyleManager_" + method.getName(), method);
            }
            ITextureManager textureManager = this.client.getTextureManager();
            this.managerMap.put("ITextureManager", textureManager);
            methods = Bean.getDeclaredMethods(ITextureManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("ITextureManager_" + method.getName(), method);
            }
            IFontManager fontManager = this.client.getFontManager();
            this.managerMap.put("IFontManager", fontManager);
            methods = Bean.getDeclaredMethods(IFontManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("IFontManager_" + method.getName(), method);
            }
            ITileDataCellManager tileDataCellManager = this.client.getTileDataCellManager();
            this.managerMap.put("ITileDataCellManager", tileDataCellManager);
            methods = Bean.getDeclaredMethods(ITileDataCellManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("ITileDataCellManager_" + method.getName(), method);
            }
            INodeManager nodeManager = this.client.getNodeManager();
            this.managerMap.put("INodeManager", nodeManager);
            methods = Bean.getDeclaredMethods(INodeManager.class, null);
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                this.methodMap.put("INodeManager_" + method.getName(), method);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

