/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.service.xmlloader.vectorservice;

import com.geoway.vtile.exception.LoadXmlException;
import com.geoway.vtile.exception.XmlDefException;
import com.geoway.vtile.manager.data_sources.IDataSourcesManager;
import com.geoway.vtile.model.Constants;
import com.geoway.vtile.model.data_source.DataScourceShell;
import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.model.vector_service.CacheInfoBean;
import com.geoway.vtile.model.vector_service.VectorServiceBean;
import com.geoway.vtile.model.vector_service.dataset.DataSetBean;
import com.geoway.vtile.model.vector_service.layer.Label;
import com.geoway.vtile.model.vector_service.layer.LayerBean;
import com.geoway.vtile.model.vector_service.layer.LayerLevelBean;
import com.geoway.vtile.model.vector_service.storage.StorageInfoBean;
import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datasource.IDataSource;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.service.xmlloader.XmlLoader;
import com.geoway.vtile.service.xmlloader.vectorservice.AbstractXmlLoader;
import com.geoway.vtile.spatial.grid.GridManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorServiceLoader
extends AbstractXmlLoader
implements XmlLoader<VectorServiceBean> {
    Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String VERSION = "v1.0";
    public static final String SERVICE_TYPE = "vector_service";
    public static final String LAYER_SUFFIX = "_layer";
    public static final String LABEL_SUFFIX = "_label";
    public static final String STORAGE_PREFIX = "storage_";

    public VectorServiceLoader(Client client) {
        super(client);
    }

    @Override
    protected String getValidateXMLPath() {
        return this.getClass().getResource("").getPath() + "vector_server_register.xsd";
    }

    @Override
    public VectorServiceBean load(InputStream inXMl) throws LoadXmlException {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(inXMl);
            Element e = document.getRootElement();
            VectorServiceBean vectorService = null;
            if ("vindex".equalsIgnoreCase(e.getName())) {
                Element item = (Element)e.element("VectorTileServers").elements().get(0);
                vectorService = this.parseInfo(item);
            } else {
                vectorService = this.parseInfo(e);
            }
            return vectorService;
        }
        catch (DocumentException e) {
            throw new LoadXmlException("\u52a0\u8f7dXML\u51fa\u9519" + e.getMessage());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new XmlDefException(e.getMessage());
        }
    }

    @Override
    public List<VectorServiceBean> loadList(InputStream inXMl) throws LoadXmlException {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(inXMl);
            Element root = document.getRootElement();
            List items = root.element("VectorTileServers").elements();
            ArrayList<VectorServiceBean> vectorServerRegisterBeanArr = new ArrayList<VectorServiceBean>();
            for (Element item : items) {
                VectorServiceBean vectorServerRegisterBean = this.parseInfo(item);
                vectorServerRegisterBeanArr.add(vectorServerRegisterBean);
            }
            return vectorServerRegisterBeanArr;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new LoadXmlException(e.getMessage());
        }
    }

    private CacheInfoBean createCacheInfo(Element item, Map<String, IDataSourceInService> dataSourceMap) {
        String tileSaver = item.elementText("TileSaver");
        IDataSourceInService tileSaverDataSource = dataSourceMap.get(tileSaver);
        return null;
    }

    private VectorServiceBean parseInfo(Element item) throws Exception {
        VectorServiceBean vectorService = new VectorServiceBean();
        this.getInfoByStr(item, vectorService, "Id");
        try {
            String gridTreeName = "";
            if (item.elementText("Grid") != null) {
                gridTreeName = item.elementText("Grid");
            } else {
                String gridBase = "degree";
                if (item.elementText("GridUnit") != null) {
                    gridBase = item.elementText("GridUnit");
                }
                gridTreeName = "tdt_" + gridBase + "_base512";
            }
            if (GridManager.getQuadtreeGrid((String)gridTreeName) == null) {
                throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u7f51\u683c " + gridTreeName);
            }
            vectorService.setGridTreeName(gridTreeName);
            Map<String, IDataSourceInService> dataSourceShellMap = this.getDataSourceMap(item);
            Map<String, DataSetBean> dataSetMap = this.getDataSetMap(item, dataSourceShellMap);
            vectorService.setDataSetMap(dataSetMap);
            LinkedList<String> labelLayer = new LinkedList<String>();
            Map<String, LayerBean> layerMap = this.getLayerMap(item, dataSetMap, labelLayer);
            vectorService.setLayerMap(layerMap);
            StorageInfoBean storageInfoBean = this.getStorageInfoBean(item, dataSourceShellMap, vectorService, !labelLayer.isEmpty());
            if (storageInfoBean != null) {
                vectorService.setStorageInfo(storageInfoBean);
            }
            return vectorService;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new LoadXmlException(vectorService.getId() + "\u89e3\u6790" + e.getMessage());
        }
    }

    private StorageInfoBean getStorageInfoBean(Element item, Map<String, IDataSourceInService> dataSourceShellMap, VectorServiceBean vectorService, boolean hasLabel) {
        String tileSaver = item.elementText("TileSaver");
        if (tileSaver != null) {
            IDataSourceInService dataSourceInService = dataSourceShellMap.get(tileSaver);
            if (dataSourceInService == null) {
                throw new RuntimeException("\u5728\u6570\u636e\u6e90\u4e2d\u6ca1\u6709\u627e\u5230 \u5b58\u50a8\u540d\u79f0\u4e3a:" + tileSaver + " \u7684\u74e6\u7247\u5b58\u50a8\u6570\u636e\u6e90");
            }
            if (dataSourceInService.getDataSourceType() != Constants.DATA_SOURCE_TYPE.mongodb) {
                throw new RuntimeException("\u5b58\u50a8\u6570\u636e\u6e90 " + tileSaver + " \u4e0d\u652f\u6301:\u6570\u636e\u6e90\u7c7b\u578b " + dataSourceInService.getDataSourceType());
            }
            StorageInfoBean storageInfoBean = new StorageInfoBean();
            storageInfoBean.setDataSourceId(dataSourceInService.getId());
            String serviceId = vectorService.getId();
            storageInfoBean.setStorageName(STORAGE_PREFIX + serviceId + LAYER_SUFFIX);
            if (hasLabel) {
                storageInfoBean.setLabelStorageName(STORAGE_PREFIX + serviceId + LABEL_SUFFIX);
            }
            storageInfoBean.setCompleted(false);
            return storageInfoBean;
        }
        return null;
    }

    protected Map<String, IDataSourceInService> getDataSourceMap(Element root) throws Exception {
        HashMap<String, IDataSourceInService> dataSourceMap = new HashMap<String, IDataSourceInService>();
        List items = root.element("DataSources").elements();
        for (Element item : items) {
            IDataSource dataSource = this.createDataSource(item);
            String idInXML = (String)dataSource.getId();
            IDataSourceInService dataScourceShell = this.autoRegisterDataSource(dataSource);
            dataSourceMap.put(idInXML, dataScourceShell);
        }
        return dataSourceMap;
    }

    protected IDataSourceInService autoRegisterDataSource(IDataSource dataSource) throws Exception {
        String mark = dataSource.mark();
        QueryFilter queryFilter = new QueryFilter();
        queryFilter.addFilter("mark", Constants.OPERATION.EQ, new Object[]{mark});
        IDataSourcesManager dataSourcesManager = this.client.getDataSourcesManager();
        IDataSourceInService dataScourceShell = (IDataSourceInService)dataSourcesManager.findOne(queryFilter);
        if (dataScourceShell == null) {
            String id = "autocreate_" + mark;
            dataScourceShell = new DataScourceShell(this.client, id, id, dataSource);
            if (dataSourcesManager.get(id) != null) {
                if (!dataScourceShell.equals(dataSourcesManager.get(id))) {
                    id = id + new Date().getTime();
                    dataScourceShell = new DataScourceShell(this.client, id, id, dataSource);
                    dataSourcesManager.register(dataScourceShell);
                }
                return dataScourceShell;
            }
            try {
                dataSourcesManager.register(dataScourceShell);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return dataScourceShell;
        }
        return dataScourceShell;
    }

    private Map<String, LayerBean> getLayerMap(Element root, Map<String, DataSetBean> dataSetMap, List<String> labelLayer) throws Exception {
        HashMap<String, LayerBean> layerMap = new HashMap<String, LayerBean>();
        List items = root.element("Layers").elements();
        for (Element item : items) {
            LayerBean layer = this.createLayer(item, dataSetMap);
            if (layer == null) continue;
            layerMap.put(layer.getId(), layer);
            if (!layer.isHaveLabel()) continue;
            labelLayer.add(layer.getId());
        }
        return layerMap;
    }

    private LayerBean createLayer(Element info, Map<String, DataSetBean> dataSetMap) throws Exception {
        String layerId = info.attributeValue("Id");
        try {
            LayerBean layer = new LayerBean();
            this.getInfoByStr(info, layer, "Id,BeginLevel,EndLevel");
            String cutOutScreen = this.getString(info, "cutOutScreen");
            if (cutOutScreen == null) {
                cutOutScreen = this.getString(info, "CutOutScreen");
            }
            if ("false".equalsIgnoreCase(cutOutScreen)) {
                layer.setCutOutScreen(false);
            }
            Map<Integer, LayerLevelBean> allLayerLevel = new HashMap<Integer, LayerLevelBean>();
            Integer i = layer.getBeginLevel();
            while (i <= layer.getEndLevel()) {
                Object layerLevel = new LayerLevelBean();
                ((LayerLevelBean)layerLevel).setLevel(i);
                allLayerLevel.put(i, (LayerLevelBean)layerLevel);
                layerLevel = i;
                Integer n = i = Integer.valueOf(i + 1);
            }
            allLayerLevel = this.addDataSetToLayerLevel(info, allLayerLevel, dataSetMap);
            allLayerLevel = this.addInfoToLayerLevel(info, allLayerLevel);
            layer.setLevelMap(allLayerLevel);
            Element lebelElement = info.element("Label");
            if (lebelElement != null) {
                Boolean labelOnly;
                String labelFilter;
                layer.setHaveLabel(true);
                Label label = new Label();
                String type = lebelElement.attributeValue("Type");
                if (type.equalsIgnoreCase(Constants.LABEL_TYPE.line.name())) {
                    label.setType(Constants.LABEL_TYPE.line);
                }
                if (type.equalsIgnoreCase(Constants.LABEL_TYPE.point.name())) {
                    label.setType(Constants.LABEL_TYPE.point);
                }
                if (type.equalsIgnoreCase(Constants.LABEL_TYPE.area.name())) {
                    label.setType(Constants.LABEL_TYPE.area);
                }
                if ((labelFilter = lebelElement.elementText("SQLFilter")) != null && !"".equalsIgnoreCase(labelFilter)) {
                    label.setFilter(labelFilter);
                }
                if ((labelOnly = this.getBoolean(lebelElement, "labelOnly")) == null) {
                    labelOnly = this.getBoolean(lebelElement, "LabelOnly");
                }
                if (labelOnly != null && labelOnly.booleanValue()) {
                    layer.setLabelOnly(true);
                }
                layer.setLabel(label);
            } else {
                layer.setHaveLabel(false);
            }
            return layer;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(String.format("\u56fe\u5c42%s:%s", layerId, e.getMessage()));
        }
    }

    private String getDataSetId(Element item) {
        String dataSetName = item.elements().isEmpty() ? item.getStringValue() : item.elementText("DataSetId");
        return dataSetName;
    }

    private Map<Integer, LayerLevelBean> addInfoToLayerLevel(Element info, Map<Integer, LayerLevelBean> allLayerLevel) {
        List items = new ArrayList();
        if (info.element("Levels") != null) {
            items = info.element("Levels").elements();
        }
        for (Element item : items) {
            String value = item.attributeValue("Id");
            String sqlFilter = item.elementText("SQLFilter");
            Double simplify = this.getDouble(item, "simplify");
            if (simplify == null) {
                simplify = this.getDouble(item, "Simplify");
            }
            Integer lineCutBase = this.getInteger(item, "LineCutBase");
            Integer minCutPixel = this.getInteger(item, "LineMinCutPixel");
            Integer minCutPoint = this.getInteger(item, "LineMinCutPoint");
            Integer level = 0;
            try {
                level = Integer.valueOf(value);
            }
            catch (Exception e) {
                throw new RuntimeException("\u56fe\u5c42level\u5fc5\u987b\u662f\u6574\u6570\u578b");
            }
            LayerLevelBean layerLevel = allLayerLevel.get(level);
            if (layerLevel == null) continue;
            if (sqlFilter != null && !"".equals(sqlFilter)) {
                layerLevel.addSQLFilter(sqlFilter);
            }
            if (simplify != null) {
                layerLevel.setSimplifyForLayerLevel((double)simplify);
            }
            if (lineCutBase != null) {
                layerLevel.setLineCutBase(lineCutBase);
            }
            if (minCutPixel != null) {
                layerLevel.setMinCutPixel(minCutPixel);
            }
            if (minCutPoint == null) continue;
            layerLevel.setMinCutPoint(minCutPoint);
        }
        return allLayerLevel;
    }

    private Map<Integer, LayerLevelBean> addDataSetToLayerLevel(Element info, Map<Integer, LayerLevelBean> allLayerLevel, Map<String, DataSetBean> dataSetMap) throws Exception {
        if (info.element("DataSet").elements().size() == 0) {
            String dataSetId = info.element("DataSet").getTextTrim();
            if (dataSetMap.get(dataSetId) == null) {
                throw new Exception(String.format("\u6ca1\u6709\u627e\u5230\u6570\u636e\u96c6%s", dataSetId));
            }
            allLayerLevel.entrySet().forEach(entry -> ((LayerLevelBean)entry.getValue()).setDataSetId(dataSetId));
        } else {
            List items = info.element("DataSet").elements();
            Object fieldsList = null;
            for (Element item : items) {
                Integer end;
                String dataSetId = this.getDataSetId(item);
                DataSetBean dataSet = dataSetMap.get(dataSetId);
                if (dataSet == null) {
                    throw new Exception(String.format("\u6ca1\u6709\u627e\u5230\u6570\u636e\u96c6%s", dataSetId));
                }
                Integer begin = this.getInteger(item, "begin");
                if (begin == null) {
                    begin = this.getInteger(item, "Begin");
                }
                if ((end = this.getInteger(item, "end")) == null) {
                    end = this.getInteger(item, "End");
                }
                String sqlFilter = this.getString(item, "SQLFilter");
                Double simplify = this.getDouble(item, "simplify");
                if (simplify == null) {
                    simplify = this.getDouble(item, "Simplify");
                }
                Integer level = begin;
                while (level <= end) {
                    LayerLevelBean layerLevel = allLayerLevel.get(level);
                    layerLevel.setDataSetId(dataSetId);
                    layerLevel.addSQLFilter(sqlFilter);
                    layerLevel.setSimplifyForLayerLevel(simplify);
                    Integer n = level;
                    Integer n2 = level = Integer.valueOf(level + 1);
                }
            }
        }
        return allLayerLevel;
    }
}

