/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.model.node;

import com.geoway.vtile.bean.IJsonable;
import com.geoway.vtile.bean.Idable;
import com.geoway.vtile.model.IBeanShell;
import com.geoway.vtile.model.IVersionAble;
import com.geoway.vtile.model.node.NodeBean;
import com.geoway.vtile.model.node.NodeShell;
import com.geoway.vtile.model.node.NodeType;
import com.geoway.vtile.model.statislog.StatisticsLog;
import com.geoway.vtile.tools.AbnormalCheck.MapserverCheck;

public interface INodeService
extends IJsonable,
Idable<String>,
IVersionAble,
IBeanShell<NodeBean> {
    public static INodeService create(String type, String name) {
        NodeType nodeType = NodeType.valueOf(type);
        return INodeService.create(null, nodeType, name);
    }

    public static INodeService create(String url, NodeType type, String name) {
        NodeBean node = new NodeBean();
        node.setType(type);
        node.setUrl(url);
        node.setName(name);
        node.setVersion(String.valueOf(System.currentTimeMillis()));
        if (type.equals((Object)NodeType.Mapserver)) {
            try {
                MapserverCheck.getInst(url).check();
                node.setActive(true);
            }
            catch (Exception e) {
                node.setActive(false);
            }
        }
        return new NodeShell(node);
    }

    public void setStatistics(StatisticsLog var1);

    public String getName();

    public String getId();

    public Boolean isActive();
}

