/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.model.vector_service;

import com.geoway.vtile.manager.style.IStyleManager;
import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.model.style.IStyleService;
import com.geoway.vtile.model.vector_service.CacheInfoBean;
import com.geoway.vtile.model.vector_service.ICacheable;
import com.geoway.vtile.resources.MongodbFactory;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.service.client.Client;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CacheInfoShell
implements ICacheable {
    protected Client client;
    protected CacheInfoBean cacheInfo;

    public CacheInfoShell(Client client, CacheInfoBean cacheInfo) {
        this.client = client;
        this.cacheInfo = cacheInfo;
    }

    @Override
    public boolean needDataCache() {
        return this.cacheInfo.needDataCache;
    }

    @Override
    public boolean needImgCache() {
        return this.cacheInfo.needImgCache;
    }

    @Override
    public String getImgScript() {
        return this.cacheInfo.imgScript;
    }

    @Override
    public IDataSourceInService getDataCacheSource() {
        return this.getCacheSource(this.cacheInfo.dataCacheSourceId);
    }

    @Override
    public IDataSourceInService getImgCacheSource() {
        return this.getCacheSource(this.cacheInfo.imgCacheSourceId);
    }

    private IDataSourceInService getCacheSource(String id) {
        if ("cache_datasource".equals(id)) {
            return null;
        }
        IDataSourceInService dataSource = (IDataSourceInService)this.client.getDataSourcesManager().get(id);
        if (dataSource == null) {
            throw new RuntimeException(String.format("\u6ca1\u6709\u627e\u5230\u6570\u636e\u6e90ID\u4e3a%s\u7684\u6570\u636e\u6e90", id));
        }
        return dataSource;
    }

    @Override
    public String getDataScript() {
        return this.cacheInfo.getDataScript();
    }

    @Override
    public CacheInfoBean getCacheInfoBean() {
        return this.cacheInfo;
    }

    @Override
    public void drop(String serverName, String styleId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)styleId)) {
            IStyleManager styleManager = this.client.getStyleManager();
            QueryFilter filter = new QueryFilter();
            filter.addFilter("ownServer", Constants.OPERATION.EQ, new Object[]{serverName});
            List<IStyleService> styleList = styleManager.list(filter);
            for (int i = 0; i < styleList.size(); ++i) {
                this.dropStyleImg(serverName, styleList.get(i).getName());
            }
            this.dropStyleImg(serverName, "_default__");
            this.dropImgGrid(serverName);
        } else {
            this.dropStyleImg(serverName, styleId);
        }
    }

    public void dropImgGrid(String serverName) {
        String storageName = serverName + "_img_cache_grid";
        String imgCacheSourceId = this.cacheInfo.getImgCacheSourceId();
        if ("cache_datasource".equals(imgCacheSourceId)) {
            return;
        }
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(imgCacheSourceId);
        MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
        factory.dropCollection(storageName);
    }

    private void dropStyleImg(String serverName, String styleId) {
        String storageName = serverName + "_" + styleId + "_img_cache";
        String imgCacheSourceId = this.cacheInfo.getImgCacheSourceId();
        if ("cache_datasource".equals(imgCacheSourceId)) {
            return;
        }
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(imgCacheSourceId);
        MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
        factory.dropCollection(storageName);
    }
}

