/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dao.statislog;

import com.alibaba.fastjson.JSON;
import com.geoway.vtile.manager.node.observer.NodeEventBus;
import com.geoway.vtile.model.statislog.StatisticsLog;
import com.geoway.vtile.tools.redis.RedisCache;
import com.geoway.vtile.tools.redis.RedisEvent;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPubSub;

public class StatisLogDao
extends JedisPubSub {
    private static Logger logger = LoggerFactory.getLogger(StatisLogDao.class);
    private final String ns = "accesslog_statis";
    protected RedisCache redis = new RedisCache();
    private NodeEventBus<StatisticsLog> eventBus;
    private boolean bSubscribed = true;

    public StatisLogDao(NodeEventBus<StatisticsLog> eventBus) {
        this.eventBus = eventBus;
    }

    public void insert(StatisticsLog logData) throws Exception {
        String json = JSON.toJSONString((Object)logData);
        this.redis.listPush(this.ns, json);
        this.publishEvent("statislog from ");
    }

    private void publishEvent(String id) throws Exception {
        this.redis.publish(this.ns, RedisEvent.UPDATE.toJsonBean(id));
    }

    public List<StatisticsLog> dumpAllLogs() {
        try {
            List<String> allLogs = this.redis.listDump(this.ns);
            ArrayList<StatisticsLog> statisList = new ArrayList<StatisticsLog>();
            if (null != allLogs && allLogs.size() > 0) {
                allLogs.forEach(str -> {
                    StatisticsLog bean = (StatisticsLog)JSON.parseObject((String)str, StatisticsLog.class);
                    if (null != bean) {
                        statisList.add(bean);
                    }
                });
            }
            return statisList;
        }
        catch (Exception ex) {
            logger.error("\u67e5\u8be2redis\u7edf\u8ba1\u65e5\u5fd7\u51fa\u9519\uff1a" + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public void subscribe() {
        if (this.bSubscribed) {
            return;
        }
        this.redis.subscribeAsync(this.ns, this);
        this.bSubscribed = true;
    }

    public void onMessage(String channel, String message) {
        try {
            List<StatisticsLog> logs;
            System.out.println("\u63a5\u6536\u5230\u9891\u9053: \"" + channel + "\"\u6d88\u606f: " + message);
            if (null != this.eventBus && this.eventBus.size() > 0 && null != (logs = this.dumpAllLogs()) && logs.size() > 0) {
                logs.forEach(log -> this.eventBus.notifyObservers((StatisticsLog)log));
            }
        }
        catch (Exception ex) {
            logger.error("\u67e5\u8be2redis\u7edf\u8ba1\u65e5\u5fd7\u51fa\u9519\uff1a" + ex.getMessage(), (Throwable)ex);
        }
    }

    public void onSubscribe(String channel, int subscribedChannels) {
        System.out.println("redis\u8ba2\u9605\u4e86 " + subscribedChannels + " \u4e2a\u9891\u9053\uff0c\u5305\u62ec " + channel);
    }

    public void onUnsubscribe(String channel, int subscribedChannels) {
        System.out.println("\u9000\u8ba2\u4e86 " + channel + "\uff0c\u5f53\u524d\u8ba2\u9605\u7684\u9891\u9053\u6570\u91cf\u4e3a " + subscribedChannels);
        this.bSubscribed = false;
    }
}

