/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.resources.dialect.db.gauss;

import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.dialect.IResourcesDataInput;
import com.geoway.vtile.resources.dialect.ResourcesDataInputException;
import com.geoway.vtile.resources.dialect.db.AbstractResourcesDataInput;
import com.geoway.vtile.spatial.Geom;
import com.geoway.vtile.type.Type;
import com.geoway.vtile.type.TypeGaussGeometry;
import com.geoway.vtile.type.TypePostGisGeometry;
import com.huawei.gaussdb.jdbc.util.PGobject;
import java.sql.PreparedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaussResourcesDataInput
extends AbstractResourcesDataInput
implements IResourcesDataInput<PreparedStatement, Integer> {
    Logger logger = LoggerFactory.getLogger(GaussResourcesDataInput.class);
    static final String GAUSSGIS_GEOMETRY_NAME = "geometry";

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.gauss;
    }

    public void columnGeometry(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if (value == null) {
            input.setNull(indexOrLabelName, 2000);
            return;
        }
        if (!(value instanceof Geom)) {
            throw new ResourcesDataInputException(this.getDataSourceType(), (Type)TypeGaussGeometry.INSTANCE, value, "\u8f93\u5165\u503c\u7c7b\u578b\u4e0d\u7b26");
        }
        Geom geom = (Geom)value;
        TypePostGisGeometry.INSTANCE.isType((Object)geom);
        PGobject po = new PGobject();
        po.setType(GAUSSGIS_GEOMETRY_NAME);
        po.setValue((String)geom.getOriginGeom());
        input.setObject(indexOrLabelName, po);
    }
}

