/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.resources;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.diagnose.GlobalMetrics;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.resources.MongoConnectionPoolMonitor;
import com.geoway.vtile.resources.MongodbFactory;
import com.geoway.vtile.utils.MongoClientURI;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.event.ConnectionPoolListener;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongodbDataSourceManager {
    private static Logger Log = LoggerFactory.getLogger((String)"MongodbDataSourceManager");
    private static int maxIdleTimeMS = 300000;
    private static int maxWaitTimeMS = 60000;
    private static MongodbDataSourceManager _manager = new MongodbDataSourceManager();
    private static Map<String, MongoClient> _cacheMap = new HashMap<String, MongoClient>();

    public static MongodbDataSourceManager getInstance() {
        return _manager;
    }

    private String getAliasName(String url, Integer port, String user, String databaseName) {
        String alias = url.replace("\\", "").replace("/", "").replace("_", "");
        StringBuffer beanName = new StringBuffer();
        beanName.append("mongodb").append("||");
        beanName.append(alias).append("||");
        beanName.append(port).append("||");
        beanName.append(user).append("||");
        beanName.append(databaseName).append("||");
        beanName.append("mongoAddress");
        return beanName.toString();
    }

    public MongodbFactory getFactory(String uri) {
        MongoClient mongoClient = MongodbDataSourceManager.aquireMongoClient(uri);
        MongoClientURI mongoClientURI = new MongoClientURI(uri);
        String databaseName = mongoClientURI.getDatabase();
        return new MongodbFactory(mongoClient, databaseName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MongoClient aquireMongoClient(String uri) {
        MongoClient mongoClient = _cacheMap.get(uri);
        if (mongoClient == null) {
            MongodbDataSourceManager mongodbDataSourceManager = _manager;
            synchronized (mongodbDataSourceManager) {
                mongoClient = _cacheMap.get(uri);
                if (mongoClient == null) {
                    try {
                        mongoClient = MongodbDataSourceManager.buildMongoClient(uri);
                        _cacheMap.put(uri, mongoClient);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            }
        }
        return mongoClient;
    }

    public static MongoClient buildMongoClient(String uri) {
        int max = GlobalTileSettings.MGPOOL_MAX > 0 ? GlobalTileSettings.MGPOOL_MAX : 100;
        int min = GlobalTileSettings.MGPOOL_MIN > 0 ? GlobalTileSettings.MGPOOL_MIN : 0;
        if (GlobalTileSettings.MGPOOL_IDLE_TIMEOUT_MS > 0) {
            maxIdleTimeMS = GlobalTileSettings.MGPOOL_IDLE_TIMEOUT_MS;
        }
        MongoConnectionPoolMonitor monitor = new MongoConnectionPoolMonitor(uri);
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString(uri)).applyToConnectionPoolSettings(builder -> builder.maxConnectionIdleTime((long)maxIdleTimeMS, TimeUnit.MILLISECONDS).maxWaitTime((long)maxWaitTimeMS, TimeUnit.MILLISECONDS).maxSize(max).minSize(min).addConnectionPoolListener((ConnectionPoolListener)monitor)).build();
        if (Log4jUtil.isDiagnoseEnable()) {
            Log.info(Log4jUtil.MARKER_DIAG, "\u65b0\u5efamongodb\u8fde\u63a5\u6c60 min:{}, max:{}, idleMS:{}", new Object[]{settings.getConnectionPoolSettings().getMinSize(), settings.getConnectionPoolSettings().getMaxSize(), settings.getConnectionPoolSettings().getMaxConnectionIdleTime(TimeUnit.MILLISECONDS)});
        }
        MongoClient mgcliPool = MongoClients.create((MongoClientSettings)settings);
        if (Log4jUtil.isDiagnoseEnable()) {
            Log.info("mongodb\u8fde\u63a5\u6c60\u72b6\u6001\uff1a{}", (Object)mgcliPool.getClusterDescription());
        }
        GlobalMetrics.Current.getnMgPoolCreated().incrementAndGet();
        return mgcliPool;
    }

    public synchronized void unRegisterMongoClient(String ip, int port, String userName, String databaseName) {
        String mongodbAddressName = this.getAliasName(ip, port, userName, databaseName);
        MongoClient mongoClient = _cacheMap.get(mongodbAddressName);
        if (mongoClient != null) {
            mongoClient.close();
            _cacheMap.remove(mongodbAddressName);
        }
    }

    public static Map<String, Object> getMgpoolMetrics() {
        LinkedHashMap<String, Object> metrics = new LinkedHashMap<String, Object>();
        metrics.put("poolCount", MongoConnectionPoolMonitor.Cache.size());
        MongoConnectionPoolMonitor.Cache.forEach((url, monitor) -> {
            JSONObject jobj = JSON.parseObject((String)JSON.toJSONString((Object)monitor));
            metrics.put((String)url, jobj);
        });
        return metrics;
    }
}

