/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.cluster.pipeline;

import com.geoway.vtile.cluster.bean.TaskContext;
import com.geoway.vtile.cluster.dao.TaskGridDao;
import com.geoway.vtile.cluster.pipeline.ITaskHandler;
import com.geoway.vtile.cluster.tasks.ParallelCutTask;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.scroll.ITileScroll;
import com.geoway.vtile.transform.cell.layout.TileLayout;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GridsDistributeHandler
implements ITaskHandler {
    private TaskGridDao dao = new TaskGridDao();

    @Override
    public Object handleGrids(TaskContext ctx) {
        System.out.println("\u5206\u89e3\u53d1\u5e03\u5b50\u4efb\u52a1\u7f51\u683c");
        ParallelCutTask task = (ParallelCutTask)ctx.getCurrentTask();
        String name = task.getName();
        System.out.println("\u4efb\u52a1\u540d\u79f0\uff1a" + name);
        this.dao.clearCounter(task.getTaskId());
        this.dao.clearGrids(task.getTaskId());
        ArrayList<String> gridKeys = new ArrayList<String>();
        ITileScroll scroll = ctx.getGridsScroll();
        int i = 0;
        System.out.println(String.format("%d~%d\u7ea7\u9636\u6bb5\u603b\u7f51\u683c\u6570\uff1a%d", ctx.getStageLevel1(), ctx.getStageLevel2(), scroll.getCount()));
        while (scroll.hasNext()) {
            TileLayout layout = scroll.next();
            GridExtent grid = layout.getExtent();
            gridKeys.add(grid.getCodeXYL());
            if (++i < 100) continue;
            i = 0;
            this.publishTaskGrids(ctx, gridKeys);
            gridKeys.clear();
        }
        this.publishTaskGrids(ctx, gridKeys);
        gridKeys.clear();
        return null;
    }

    private void publishTaskGrids(TaskContext ctx, List<String> gridKeys) {
        System.out.println("redis \u63d0\u4ea4\uff1a" + StringUtils.join(gridKeys, (String)", "));
        ParallelCutTask task = (ParallelCutTask)ctx.getCurrentTask();
        String taskId = task.getTaskId();
        this.dao.offerGrids(taskId, gridKeys);
    }
}

