/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.base;

import com.geoway.vtile.manager.task.log.ITaskLogger;
import com.geoway.vtile.tiledispatch.base.IBaseComponent;
import java.time.LocalDate;
import java.time.LocalTime;

public abstract class AbstractBaseComponent
implements IBaseComponent {
    protected String name;
    protected boolean init = false;
    protected boolean cancel = false;
    protected boolean pause = false;
    protected Throwable e;
    public boolean error = false;
    protected ITaskLogger cutLogger;

    public AbstractBaseComponent() {
    }

    public AbstractBaseComponent(String name) {
        this.name = name;
    }

    @Override
    public void setLogger(ITaskLogger cutLogger) {
        this.cutLogger = cutLogger;
    }

    @Override
    public void log(String message) {
        if (this.cutLogger != null) {
            this.cutLogger.log(LocalDate.now() + " " + LocalTime.now().withNano(0) + ":" + message);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isInit() {
        return this.init;
    }

    @Override
    public boolean isCancel() {
        return this.cancel;
    }

    @Override
    public Throwable getException() {
        return this.e;
    }

    @Override
    public boolean isError() {
        return this.error;
    }
}

