/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.consumer.handler.abstractclass;

import com.geoway.vtile.tiledispatch.base.AbstractBaseComponent;
import com.geoway.vtile.tiledispatch.consumer.handler.ITileHandlerStream;
import com.geoway.vtile.tiledispatch.consumer.handler.error.ITileErrorHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.IntConsumer;

public abstract class AbstractTileHandlerStream<T>
extends AbstractBaseComponent
implements ITileHandlerStream<T> {
    int bufferSize;
    protected List<T> buffer = new ArrayList<T>();
    protected ITileErrorHandler errorHandler;
    protected ExecutorService executor;
    protected CountDownLatch count;
    protected boolean resume = false;
    protected IntConsumer progressFunc = null;

    public AbstractTileHandlerStream(ExecutorService executor, int bufferSize) {
        this.executor = executor;
        this.bufferSize = bufferSize;
    }

    @Override
    public void push(List<T> data) {
        this.buffer.addAll(data);
        if (this.buffer.size() >= this.bufferSize) {
            this.flush();
        }
    }

    @Override
    public void push(T data) {
        this.buffer.add(data);
        this.flush();
    }

    @Override
    public void flush() {
        this.buffer.clear();
    }

    public void destroy() {
        this.flush();
    }

    @Override
    public void setCount(CountDownLatch count) {
        this.count = count;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    public boolean isResume() {
        return this.resume;
    }

    @Override
    public void setResume(boolean resume) {
        this.resume = resume;
    }

    public void save() {
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public void setProgressHandler(IntConsumer callback) {
        this.progressFunc = callback;
    }
}

