/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.consumer.saver;

import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.manager.task.log.ITaskLogger;
import com.geoway.vtile.resources.MongodbDao;
import com.geoway.vtile.resources.MongodbFactory;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.saver.ITileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.geoway.vtile.transform.cell.ImgCacheCell;
import com.mongodb.client.model.CreateCollectionOptions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCacheTileSaver
implements ITileSaver {
    private static Logger LOG = LoggerFactory.getLogger(ImageCacheTileSaver.class);
    protected boolean init = false;
    public static String lName = "flevel";
    public static String rName = "fx";
    public static String cName = "fy";
    String uri;
    String ip;
    int port;
    String namespace;
    String storageTableName;
    String userName;
    String password;
    MongodbFactory factory;
    MongodbDao dao;
    boolean enableSharding = false;

    public void setEnableSharding(boolean flag) {
        this.enableSharding = flag;
    }

    public ImageCacheTileSaver(String uri, String collectionName) {
        this.storageTableName = collectionName;
        this.uri = uri;
    }

    @Override
    public void init(ITaskLogger logger) {
        if (this.init) {
            return;
        }
        MongodbDataSource mongodbDataSource = new MongodbDataSource(this.getUri());
        this.factory = mongodbDataSource.factory();
        if (logger != null) {
            logger.log("\u5224\u65ad\u662f\u5426\u5b58\u5728 collection: " + this.storageTableName);
        }
        boolean isExist = this.factory.collectionExist(this.storageTableName);
        this.dao = this.factory.getDao(this.storageTableName);
        if (!isExist) {
            if (logger != null) {
                logger.log("\u521b\u5efa collection: " + this.storageTableName);
            }
            this.factory.createCollection(this.storageTableName, new CreateCollectionOptions());
            if (this.enableSharding && GlobalTileSettings.ENABLE_MONGO_SHARDING.booleanValue()) {
                try {
                    this.factory.setDBSharding();
                }
                catch (Exception ex) {
                    LOG.error("\u6570\u636e\u5e93\u5f00\u542f\u5206\u7247\u5931\u8d25", (Throwable)ex);
                }
                LOG.info("\u6307\u5b9a\u96c6\u5408{}\u7684\u5206\u7247\u5b57\u6bb5: {}", (Object)this.storageTableName, (Object)"_id");
                try {
                    this.factory.shardCollectionHashed(this.storageTableName, "_id");
                }
                catch (Exception ex) {
                    LOG.error("\u6307\u5b9a\u5206\u7247\u952e\u5931\u8d25", (Throwable)ex);
                }
            }
        }
        this.init = true;
    }

    @Override
    public void init() {
        this.init(null);
    }

    @Override
    public <T> void save(List<T> data, IDocumentEncoder<T> encoder) {
    }

    @Override
    public <T> void saveItem(T data, IDocumentEncoder<T> encoder) {
    }

    @Override
    public void setEndTime(List<GridExtent> extents, long time) {
    }

    @Override
    public <T> void updateEndTimeAndSave(List<T> data, long time, IDocumentEncoder<T> encoder) {
    }

    @Override
    public void setBeginTime(List<GridExtent> extents, long time) {
    }

    @Override
    public Map<String, byte[]> getTiles(List<GridExtent> extents, Long time) {
        return null;
    }

    @Override
    public Map<String, byte[]> getTiles(Set<String> extentKeys, Long time) {
        return null;
    }

    @Override
    public void updateTiles(Map<String, byte[]> tiles) {
    }

    @Override
    public boolean hasRecord(GridExtent extent) {
        return false;
    }

    @Override
    public boolean hasRecord(GridExtent extent, Long beginTime) {
        return this.hasRecord(extent);
    }

    @Override
    public void remove(List<GridExtent> extents) {
    }

    public boolean hasRecord(GridExtent extent, ImgCacheCell cell) {
        Document data = new Document();
        String idStr = extent.getX() + "_" + extent.getY() + "_" + extent.getLevel() + "_" + cell.getTileSize() + "_" + cell.getRatio() + "_" + cell.getImgCacheType();
        data.put("_id", (Object)idStr);
        Document info = new Document();
        info.put("_id", (Object)1);
        Document o = this.dao.findone((Bson)data, (Bson)info);
        return o != null;
    }

    public void remove(GridExtent extent, ImgCacheCell cell) {
        Document data = new Document();
        String idStr = extent.getX() + "_" + extent.getY() + "_" + extent.getLevel() + "_" + cell.getTileSize() + "_" + cell.getRatio() + "_" + cell.getImgCacheType();
        data.put("_id", (Object)idStr);
        this.dao.deleteone((Bson)data);
    }

    @Override
    public void removeAndUpdateEndTime(GridExtent extent, Long timestamp, Long nextTime) {
    }

    public String getUri() {
        if (StringUtils.isEmpty((CharSequence)this.uri)) {
            this.uri = this.ip + ':' + this.port + '/' + this.namespace;
            if (StringUtils.isNotEmpty((CharSequence)this.userName)) {
                this.uri = this.userName + ':' + this.password + '@' + this.uri;
            }
            this.uri = "mongodb://" + this.uri;
        }
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

