/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.v4;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.layer.Label;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.tiledispatch.consumer.scroll.ITileScroll;
import com.geoway.vtile.tiledispatch.consumer.scroll.TileRangeScroll;
import com.geoway.vtile.transform.cellv4.LayerFilterSchema;
import com.geoway.vtile.transform.cellv4.TileOptimizer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapPrecutSchema {
    private static Logger logger = LoggerFactory.getLogger(MapPrecutSchema.class);
    private IVectorService mapService;
    private int startLevel;
    private int endLevel;
    private String bbox;
    private Map<Integer, ITileScroll> levelLayouts = null;

    public void prepare(IVectorService mapService, String bbox, Integer beginLevel, Integer endLevel) {
        this.mapService = mapService;
        this.bbox = bbox;
        this.startLevel = beginLevel;
        this.endLevel = endLevel;
        this.produceLayoutGrids();
    }

    private void produceLayoutGrids() {
        IGridSystem grid = this.mapService.getGridTree();
        TileRangeScroll gridsCursor = null;
        this.levelLayouts = new LinkedHashMap<Integer, ITileScroll>();
        logger.info("build layout grids, level: {}~{}", (Object)this.startLevel, (Object)this.endLevel);
        for (int i = this.startLevel; i <= this.endLevel; ++i) {
            int level = i;
            gridsCursor = new TileRangeScroll(level, this.bbox, grid);
            gridsCursor.init();
            this.levelLayouts.put(level, gridsCursor);
            if (!Log4jUtil.isDiagnoseEnable()) continue;
            logger.info("level {} grids count: {}", (Object)level, (Object)gridsCursor.getCount());
        }
    }

    public void refineGrids(TileOptimizer optm, boolean isResumeTask) {
    }

    public ITileScroll getScroll(int level) {
        return this.levelLayouts.get(level);
    }

    public void analyzeFilters(TileOptimizer optm) {
        Map layers = this.mapService.getLayerMap();
        HashMap<String, LayerFilterSchema> filtersMap = new HashMap<String, LayerFilterSchema>();
        for (ILayer layer : layers.values()) {
            String layerName = layer.getId();
            Boolean hasLabel = layer.isHaveLabel();
            Label layerLabel = layer.getLabel();
            LayerFilterSchema filterSchema = new LayerFilterSchema();
            filterSchema.layerName = layerName;
            for (int i = this.startLevel; i <= this.endLevel; ++i) {
                String currLevelLabelFilter;
                String currLevelFilter;
                ILayerLevel llevel = (ILayerLevel)layer.getLevelMap().get(i);
                if (null == llevel) continue;
                filterSchema.baseFilters[i] = currLevelFilter = llevel.getFilterExpression();
                if (!hasLabel.booleanValue() || null == layerLabel) continue;
                filterSchema.labelFilters[i] = currLevelLabelFilter = layerLabel.getFilterAtLevel(String.valueOf(i));
            }
            filtersMap.put(layerName, filterSchema);
        }
        optm.setLayerFilters(filtersMap);
        boolean allSame = optm.isSameFilterAtLevels(this.startLevel, this.endLevel);
        optm.setAllLayerSameFilter(allSame);
    }

    public void release() {
        if (null == this.levelLayouts) {
            return;
        }
        this.levelLayouts.clear();
    }
}

