/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.consumer.scroll;

import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.saver.MongoTileSaver;
import com.geoway.vtile.tiledispatch.consumer.scroll.TileLayoutScroll;
import com.geoway.vtile.transform.cell.layout.TileLayout;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCacheMongoDataScroll<T>
extends TileLayoutScroll {
    protected Logger logger = LoggerFactory.getLogger(ImageCacheMongoDataScroll.class);
    private MongoCursor iterator;

    public ImageCacheMongoDataScroll(int level, IGridSystem grid, MongoTileSaver tileSaver, Integer filterLevel, boolean loged) {
        super(level, grid, tileSaver, filterLevel, loged);
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        this.count = this.getCount(this.level);
        this.iterator = this.getIterator(this.level);
        this.init = true;
    }

    @Override
    public Long getCount() {
        return this.count;
    }

    @Override
    public TileLayout next() {
        Object obj = this.iterator.next();
        String tileKeyStr = ImageCacheMongoDataScroll.getKey((Document)obj);
        String tile = tileKeyStr + "_" + this.level;
        return this.getGridExtentByTileKey(tile);
    }

    @Override
    public synchronized boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public void release() {
        try {
            if (null != this.iterator) {
                this.iterator.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private TileLayout getGridExtentByTileKey(String tileKey) {
        String[] key = tileKey.split("_");
        GridExtent gridExtent = this.grid.getExtent(Integer.valueOf(key[2]).intValue(), Integer.valueOf(key[0]).intValue(), Integer.valueOf(key[1]).intValue());
        return new TileLayout(gridExtent, null);
    }

    public MongoCursor getIterator(int level) {
        Document data = new Document();
        data.put(MongoTileSaver.lName, (Object)level);
        data.put(MongoTileSaver.isLayout, (Object)1);
        Document fields = new Document();
        fields.put(MongoTileSaver.lName, (Object)1);
        fields.put(MongoTileSaver.rName, (Object)1);
        fields.put(MongoTileSaver.cName, (Object)1);
        FindIterable fi = this.tileSaver.getMongoDao().findCollection((Bson)data, (Bson)fields);
        fi.noCursorTimeout(true);
        fi.batchSize(100);
        return fi.iterator();
    }

    @Override
    public Long getCount(int level) {
        Document data = new Document();
        data.put(MongoTileSaver.lName, (Object)level);
        data.put(MongoTileSaver.isLayout, (Object)1);
        return this.tileSaver.getMongoDao().count((Bson)data);
    }
}

