/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.task;

import com.geoway.vtile.exception.ServerException;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.layer.Label;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.resources.datasource.db.DbDataSource;
import com.geoway.vtile.resources.datatable.IField;
import com.geoway.vtile.resources.datatable.ITable;
import com.geoway.vtile.resources.sql.jdbc.IJDBCGenericDao;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.tiledispatch.consumer.ITileConsumer;
import com.geoway.vtile.tiledispatch.consumer.abstractclass.AbstractDataConsumer;
import com.geoway.vtile.tiledispatch.consumer.abstractclass.SubDataConsumer;
import com.geoway.vtile.tiledispatch.consumer.buffer.VarintWriterBuffer;
import com.geoway.vtile.tiledispatch.consumer.handler.FeatureTileCutHandler;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.FeatureTileDocumentEncoder;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.tiledispatch.task.stage.TileConsumeStage;
import com.geoway.vtile.tiledispatch.task.task.TileLayerCutTask;
import com.geoway.vtile.transform.cell.AreaLabelCutCell;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.enums.LAYER_TYPE;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AreaLabelCutTask
extends TileLayerCutTask {
    public static final int CUT_INTERVAL = 4;
    DbDataSource dbDataSource;

    public AreaLabelCutTask(String name, ILayer layer, IGridSystem grid, MongodbDataSource dataSource, Integer beginLevel, Integer endLevel) {
        super(name, layer, grid, dataSource, beginLevel, endLevel, LAYER_TYPE.label);
    }

    @Override
    protected void buildStages() {
        int interval = 4;
        int end = this.beginLevel;
        TileConsumeStage stage = null;
        int start = this.beginLevel;
        while (start <= this.endLevel) {
            int n = end = start + interval < this.endLevel ? start + interval : this.endLevel;
            if (this.endLevel - end <= 2) {
                end = this.endLevel;
            }
            ITileConsumer tileConsumer = this.createConsumer(start, end);
            String consumeStageName = "\u751f\u4ea7" + start + "\u81f3" + end + "\u7ea7\u522b\u9762\u6ce8\u8bb0\u74e6\u7247";
            stage = new TileConsumeStage(consumeStageName, tileConsumer);
            stage.setLogger(this.cutLogger);
            this.stages.add(stage);
            start = end + 1;
        }
    }

    private ITileConsumer createConsumer(int startLevel, int endLevel) {
        AreaLabelCutCell cutterCell = new AreaLabelCutCell(this.layer, this.grid, Integer.valueOf(startLevel));
        cutterCell.setDown(endLevel - startLevel);
        ILayerLevel layerLevel = (ILayerLevel)this.layer.getLevelMap().get(startLevel);
        IDataSet dbDataSet = layerLevel.getDataSet();
        this.dbDataSource = (DbDataSource)dbDataSet.getDataSource().getBean();
        ITable table = null;
        try {
            table = dbDataSet.getDataService().getTable();
        }
        catch (Exception exception) {
            throw new ServerException(exception.getMessage());
        }
        IJDBCGenericDao ijdbcGenericDao = this.dbDataSource.genericDao();
        String tablename = table.getTablename();
        String idField = table.getOriginIdField();
        String sql = "select min(" + idField + ") as minid, max(" + idField + ") as maxid from " + tablename;
        List maps = ijdbcGenericDao.queryBySql(sql, null);
        Map minmaxMap = (Map)maps.get(0);
        String MINID = minmaxMap.containsKey("minid") ? minmaxMap.get("minid").toString() : minmaxMap.get("MINID").toString();
        String MAXID = minmaxMap.containsKey("maxid") ? minmaxMap.get("maxid").toString() : minmaxMap.get("MAXID").toString();
        Long minId = Long.valueOf(MINID);
        Long maxId = Long.valueOf(MAXID);
        int split = 5;
        long interval = (maxId - minId) / (long)split;
        VarintWriterBuffer dataBuffer = new VarintWriterBuffer(this.saver, new FeatureTileDocumentEncoder(), this.grid, table, LAYER_TYPE.label, Constants.GEO_TYPE.POINT);
        ArrayList<SubDataConsumer> subDataConsumers = new ArrayList<SubDataConsumer>(split);
        long current = minId;
        for (int i = 0; i < split; ++i) {
            long endId = i == split - 1 ? maxId + 1L : current + interval;
            String extraFilter = idField + " >= " + current + " and " + idField + " < " + endId;
            QueryFilter filter = this.buildFilter(dbDataSet, startLevel, endLevel, extraFilter);
            FeatureTileCutHandler handlerStream = new FeatureTileCutHandler(TileDispatchTaskManager.getInstance().getNewExecutor(), 1, this.grid, (ITileCutterCell)cutterCell, this.saver, dataBuffer);
            handlerStream.setResume(this.resume);
            SubDataConsumer subDataConsumer = new SubDataConsumer(table, handlerStream, filter, null);
            subDataConsumer.init();
            subDataConsumers.add(subDataConsumer);
            current = endId;
        }
        AbstractDataConsumer tileConsumer = new AbstractDataConsumer(subDataConsumers, dataBuffer);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    @Override
    public void success() throws Exception {
        super.success();
    }

    @Override
    public void error() {
        super.error();
    }

    @Override
    public void cancel() {
        super.cancel();
    }

    public QueryFilter buildFilter(IDataSet dataSet, int beginLevel, int endLevel, String extraFilter) {
        Label label;
        QueryFilter filter = new QueryFilter();
        ArrayList<String> nameList = new ArrayList<String>();
        for (String fieldName : dataSet.getFieldsArr()) {
            IField field = (IField)dataSet.getFieldsMap().get(fieldName);
            nameList.add(field.getOriginFieldName());
        }
        filter.setOutputFieldNames(nameList.toArray(new String[nameList.size()]));
        String filterStr = dataSet.getFilter();
        if (StringUtils.isNotEmpty((CharSequence)filterStr)) {
            filterStr = filterStr.replace("\"", "'");
        }
        if (filterStr != null && !"".equalsIgnoreCase(filterStr)) {
            if (filterStr.startsWith("Q")) {
                filter.addQueryFilterStr(filterStr, 1);
            } else {
                filter.addSQL(filterStr);
            }
        }
        if (extraFilter != null && !"".equalsIgnoreCase(extraFilter)) {
            if (extraFilter.startsWith("Q")) {
                filter.addQueryFilterStr(extraFilter, 1);
            } else {
                filter.addSQL(extraFilter, Constants.RELATION.AND);
            }
        }
        if ((label = this.layer.getLabel()) != null && label.getFilter() != null && !"".equalsIgnoreCase(label.getFilter())) {
            if (label.getFilter().startsWith("Q")) {
                filter.addQueryFilterStr(label.getFilter(), 1);
            } else {
                filter.addSQL(label.getFilter(), Constants.RELATION.AND);
            }
        }
        this.addExtraLevelFilter(filter, beginLevel, endLevel);
        String sortStr = dataSet.getSortFiled();
        if (sortStr != null && !"".equalsIgnoreCase(sortStr)) {
            filter.addSorted(sortStr, QueryFilter.SORT.valueOf((String)dataSet.getSort()));
        }
        return filter;
    }

    protected void addExtraLevelFilter(QueryFilter filter, int beginLevel, int endLevel) {
        String filterStr;
        Map levelMap = this.layer.getLevelMap();
        for (int i = beginLevel; i <= endLevel; ++i) {
            ILayerLevel layerLevel = (ILayerLevel)levelMap.get(i);
            if (levelMap.get(i) == null || layerLevel.isVirtual().booleanValue() || !StringUtils.isEmpty((CharSequence)(filterStr = layerLevel.getFilterExpression()))) continue;
            return;
        }
        ArrayList<String> filters = new ArrayList<String>();
        for (int i = beginLevel; i <= endLevel; ++i) {
            if (levelMap.get(i) == null || "1 = 2".equals(filterStr = ((ILayerLevel)levelMap.get(i)).getFilterExpression())) continue;
            filters.add(filterStr);
        }
        if (!filters.isEmpty()) {
            String filterStr2 = StringUtils.join(filters, (String)" or ");
            filterStr2 = filterStr2.replace("\"", "'");
            filter.addSQL(filterStr2);
        }
    }
}

