/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.task;

import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.model.data_service.IDataService;
import com.geoway.vtile.model.vector_service.ICacheable;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.model.vector_service.utfgrid.IUtfgridInfo;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.tiledispatch.consumer.ITileConsumer;
import com.geoway.vtile.tiledispatch.consumer.VectorCutMongoConsumer;
import com.geoway.vtile.tiledispatch.consumer.handler.UpdateRollbackHandler;
import com.geoway.vtile.tiledispatch.consumer.saver.MongoTileSaver;
import com.geoway.vtile.tiledispatch.consumer.scroll.ITileScroll;
import com.geoway.vtile.tiledispatch.consumer.scroll.WktArrayScroll;
import com.geoway.vtile.tiledispatch.executor.DoubleQueueExecutor;
import com.geoway.vtile.tiledispatch.task.stage.TileConsumeStage;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.geoway.vtile.transform.cell.process.ProcessList;
import com.geoway.vtile.transform.enums.LAYER_TYPE;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.ObjectUtils;

public class UpdateRollbackTask
extends AbstractTileDispatchTask {
    MongodbDataSource mongodbDataSource;
    MongoTileSaver saver;
    public static final int CUT_INTERVAL = 2;
    ExecutorService cutExecutor;
    Map<String, List<String>> updateRegions;
    long timestamp;
    Long nextTime;
    IVectorService vectorService;
    IDataService dataService;
    IStorageInfo storageInfo;
    LAYER_TYPE layerType;

    public UpdateRollbackTask(String name, IVectorService vectorService, boolean isUtf, IGridSystem grid, Map<String, List<String>> updateRegions, Long timestamp, Long nextTime) {
        this(name, grid, updateRegions, timestamp, nextTime);
        this.vectorService = vectorService;
        this.storageInfo = this.vectorService.getStorageInfo();
        if (isUtf) {
            IUtfgridInfo utfgridInfo = this.vectorService.getUtfgridInfo();
            if (utfgridInfo == null) {
                throw new RuntimeException("\u7f3a\u5c11utf\u4fe1\u606f\uff0c\u65e0\u6cd5\u56de\u6eda");
            }
            this.storageInfo = utfgridInfo.getStorageInfo();
        }
        if (this.storageInfo == null) {
            throw new RuntimeException("\u7f3a\u5c11\u74e6\u7247\u5e93\u4fe1\u606f\uff0c\u65e0\u6cd5\u56de\u6eda");
        }
        this.mongodbDataSource = (MongodbDataSource)this.storageInfo.getDataSource().getBean();
        this.beginLevel = this.storageInfo.getStartLevel();
        this.endLevel = this.storageInfo.getEndLevel();
        this.bbox = vectorService.getBbox();
    }

    public UpdateRollbackTask(String name, IDataService dataService, LAYER_TYPE layerType, IGridSystem grid, Map<String, List<String>> updateRegions, Long timestamp, Long nextTime) {
        this(name, grid, updateRegions, timestamp, nextTime);
        this.dataService = dataService;
        this.storageInfo = this.dataService.getStorageInfo();
        if (this.storageInfo == null) {
            throw new RuntimeException("\u7f3a\u5c11\u74e6\u7247\u5e93\u4fe1\u606f\uff0c\u65e0\u6cd5\u56de\u6eda");
        }
        this.layerType = layerType;
        this.mongodbDataSource = (MongodbDataSource)this.storageInfo.getDataSource().getBean();
        this.beginLevel = this.storageInfo.getStartLevel();
        this.endLevel = this.storageInfo.getEndLevel();
    }

    private UpdateRollbackTask(String name, IGridSystem grid, Map<String, List<String>> updateRegions, Long timestamp, Long nextTime) {
        super(name);
        this.grid = grid;
        this.updateRegions = updateRegions;
        this.timestamp = timestamp == null ? new Date().getTime() : timestamp.longValue();
        this.nextTime = nextTime;
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.saver = this.createTileSaver();
        int taskNum = Runtime.getRuntime().availableProcessors();
        if (this.executor == null) {
            this.executor = new DoubleQueueExecutor(taskNum);
        }
        ProcessList.clearCache();
        this.cutExecutor = new DoubleQueueExecutor(taskNum * 2);
        this.buildStages();
    }

    private ITileConsumer createConsumer(int level) {
        UpdateRollbackHandler handlerStream = new UpdateRollbackHandler(this.executor, 1, this.saver, this.timestamp, this.nextTime);
        ITileScroll scroll = this.getTileScroll(level);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    private ITileScroll getTileScroll(int start) {
        return new WktArrayScroll(this.updateRegions, this.grid, start);
    }

    private MongoTileSaver createTileSaver() {
        String storageName = this.storageInfo.getStorageName();
        if (ObjectUtils.equals((Object)this.layerType, (Object)LAYER_TYPE.label)) {
            storageName = this.storageInfo.getLabelStorageName();
        }
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), storageName);
        tileSaver.init();
        return tileSaver;
    }

    @Override
    public void success() throws Exception {
        if (this.vectorService != null) {
            ICacheable cacheable = this.vectorService.getCacheInfo();
            if (cacheable != null && !this.resume) {
                cacheable.drop((String)this.vectorService.getId(), null);
            }
        } else if (this.dataService != null) {
            Client client = this.dataService.getClient();
            IVectorServiceManager vectorServiceManager = client.getVectorServiceManager();
            List services = vectorServiceManager.list(new QueryFilter());
            services.stream().filter(service -> {
                for (ILayer layer : service.getLayerMap().values()) {
                    for (ILayerLevel level : layer.getLevelMap().values()) {
                        if (!((String)this.dataService.getId()).equals(level.getDataSet().getDataService().getId())) continue;
                        return true;
                    }
                }
                return false;
            }).forEach(service -> {
                ICacheable cacheable = service.getCacheInfo();
                if (cacheable != null && !this.resume) {
                    try {
                        cacheable.drop((String)service.getId(), null);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            });
        }
        super.success();
    }

    private void buildStages() {
        this.stages = new ArrayList();
        for (int start = this.beginLevel.intValue(); start <= this.endLevel; ++start) {
            ITileConsumer tileConsumer = this.createConsumer(start);
            String consumeStageName = "\u56de\u6eda" + start + "\u7ea7\u522b\u74e6\u7247";
            TileConsumeStage stage = new TileConsumeStage(consumeStageName, tileConsumer);
            stage.setLogger(this.cutLogger);
            this.stages.add(stage);
        }
    }
}

