/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.task.abstractclass;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.manager.task.ITaskCallback;
import com.geoway.vtile.manager.task.ITileDispatchTask;
import com.geoway.vtile.manager.task.exception.TaskCancelException;
import com.geoway.vtile.manager.task.exception.TaskInterruptException;
import com.geoway.vtile.manager.task.log.ITaskLogger;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.tiledispatch.base.AbstractBaseComponent;
import com.geoway.vtile.tiledispatch.consumer.ITileConsumer;
import com.geoway.vtile.tiledispatch.producer.ITileProducer;
import com.geoway.vtile.tiledispatch.task.stage.ITaskStage;
import com.geoway.vtile.tiledispatch.task.v4.MapCutTaskV4;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTileDispatchTask
extends AbstractBaseComponent
implements ITileDispatchTask {
    private static Logger logger = LoggerFactory.getLogger(AbstractTileDispatchTask.class);
    protected ITileProducer tileProducer;
    protected ITileConsumer tileConsumer;
    protected boolean isInit = false;
    protected boolean cancel = false;
    protected boolean pause = false;
    protected boolean error = false;
    protected boolean success = false;
    protected boolean isReleased = false;
    protected ITaskCallback onSuccess;
    protected ITaskCallback onError;
    protected ITaskCallback onStart;
    protected ITaskCallback onCancel;
    protected ITaskCallback onPause;
    protected int nextIndex = 0;
    protected List<ITaskStage> stages = new ArrayList<ITaskStage>();
    protected boolean resume = false;
    protected IGridSystem grid;
    protected Integer beginLevel;
    protected Integer endLevel;
    protected String bbox;
    protected ExecutorService executor;
    protected ScheduledExecutorService logPool;
    private Boolean isChild = false;
    public static Integer dataPlateWaitingTime = null;

    public AbstractTileDispatchTask(String name) {
        super(name);
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void start() throws Exception {
        int subtasksNum = this.stages.size();
        boolean isV4Task = this instanceof MapCutTaskV4;
        logger.info(Log4jUtil.MARKER_DIAG, "==>\u542f\u52a8\u77e2\u91cf\u74e6\u7247\u9884\u70ed\u4efb\u52a1\uff1a{}, \u5206\u6bb5\u5b50\u4efb\u52a1\u4e2a\u6570\uff1a{}", (Object)this.name, (Object)subtasksNum);
        if (this.onStart != null) {
            this.onStart.callback();
        }
        try {
            long timeStart = 0L;
            this.log(this.name + " \u5f00\u59cb");
            for (int i = 0; i < this.stages.size(); ++i) {
                logger.info(Log4jUtil.MARKER_DIAG, "==>\u4efb\u52a1\u3010{}\u3011Stage-{} \u542f\u52a8, {}", new Object[]{this.getName(), i + 1, this.stages.get(i).getName()});
                timeStart = System.currentTimeMillis();
                if (this.cancel) {
                    throw new TaskCancelException("\u4efb\u52a1\u5728 " + this.stages.get(i).getName() + " \u5f00\u59cb\u524d\u88ab\u53d6\u6d88");
                }
                if (this.nextIndex > i) continue;
                if (dataPlateWaitingTime != null && (i > 0 || this.isChild.booleanValue()) && !isV4Task) {
                    this.log("\u7b49\u5f85\u6570\u636e\u843d\u76d8: " + dataPlateWaitingTime + "\u79d2");
                    Thread.sleep(dataPlateWaitingTime * 1000);
                }
                ITaskStage stage = this.stages.get(i);
                stage.init();
                stage.execute();
                ++this.nextIndex;
                double taskSeconds = (double)(System.currentTimeMillis() - timeStart) * 1.0 / 1000.0;
                logger.info(Log4jUtil.MARKER_DIAG, "==>\u4efb\u52a1\u3010{}\u3011Stage-{} \u7ed3\u675f, '{}' \u8017\u65f6: {} s, \u603b\u8fdb\u5ea6: {} / {}\n\n", new Object[]{this.getName(), i + 1, stage.getName(), String.format("%.3f", taskSeconds), i + 1, subtasksNum});
                this.log(String.format("==>\u4efb\u52a1\u3010%s\u3011Stage-%d \u7ed3\u675f, '%s' \u8017\u65f6: %s s, \u603b\u8fdb\u5ea6: %d / %d", this.getName(), i + 1, stage.getName(), String.format("%.3f", taskSeconds), i + 1, subtasksNum));
            }
        }
        catch (Exception e) {
            logger.error(Log4jUtil.MARKER_DIAG, "==>\u4efb\u52a1\u3010{}\u3011Stage-{} \u5f02\u5e38\u7ed3\u675f! \u603b\u8fdb\u5ea6: {} / {}\n", new Object[]{this.getName(), this.nextIndex + 1, this.nextIndex + 1, subtasksNum});
            logger.error("==>\u74e6\u7247\u9884\u70ed\u4efb\u52a1 " + this.getName() + " \u5f02\u5e38\u7ed3\u675f\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage(), (Throwable)e);
            this.log(this.name + " \u5f02\u5e38\u7ed3\u675f");
            this.log(e.getMessage());
            this.error();
            throw new TaskInterruptException(e);
        }
        logger.info("==>\u4efb\u52a1\u7ed3\u675f\uff1a" + this.getName());
        try {
            this.success();
        }
        catch (Exception exception) {
            logger.error("\u74e6\u7247\u9884\u70ed\u6210\u529f\u56de\u8c03\u4e8b\u4ef6\u54cd\u5e94\u5931\u8d25", (Throwable)exception);
            this.cutLogger.log("\u74e6\u7247\u9884\u70ed\u6210\u529f\u56de\u8c03\u4e8b\u4ef6\u54cd\u5e94\u5931\u8d25");
            this.error = true;
        }
        this.log(this.name + " \u7ed3\u675f");
    }

    public void success() throws Exception {
        if (this.onSuccess != null) {
            this.onSuccess.callback();
        }
        this.success = true;
    }

    public void error() {
        if (this.pause) {
            if (this.onPause != null) {
                this.onPause.callback();
            }
        } else if (this.cancel) {
            if (this.onCancel != null) {
                this.onCancel.callback();
            }
        } else {
            this.error = true;
            if (this.onError != null) {
                this.onError.callback();
            }
        }
    }

    @Override
    public void cancel() {
        if (!this.isInit) {
            return;
        }
        this.cancel = true;
        ITaskStage stage = this.stages.get(this.nextIndex);
        stage.cancel();
    }

    public void pause() {
        if (!this.isInit) {
            return;
        }
        this.cancel = true;
        this.pause = true;
        ITaskStage stage = this.stages.get(this.nextIndex);
        stage.cancel();
    }

    public void onSuccess(ITaskCallback onSuccess) {
        this.onSuccess = onSuccess;
    }

    public void onError(ITaskCallback onError) {
        this.onError = onError;
    }

    public void onStart(ITaskCallback onStart) {
        this.onStart = onStart;
    }

    public void onCancel(ITaskCallback onCancel) {
        this.onCancel = onCancel;
    }

    public void onPause(ITaskCallback onPause) {
        this.onPause = onPause;
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public void setLogger(ITaskLogger cutLogger) {
        this.cutLogger = cutLogger;
    }

    public void setLogPool(ScheduledExecutorService logPool) {
        this.logPool = logPool;
    }

    public boolean isResume() {
        return this.resume;
    }

    public void setResume(boolean resume) {
        this.resume = resume;
    }

    public void setIsChild(Boolean isChild) {
        this.isChild = isChild;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isFinished() {
        return this.success || this.cancel || this.error;
    }

    public void release() {
        this.isReleased = true;
    }
}

