/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.consumer.scroll;

import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.saver.MongoTileSaver;
import com.geoway.vtile.tiledispatch.consumer.scroll.ITileScroll;
import com.geoway.vtile.transform.cell.layout.TileLayout;
import com.mongodb.client.FindIterable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileLayoutScroll
implements ITileScroll {
    protected Logger logger = LoggerFactory.getLogger(TileLayoutScroll.class);
    public boolean init = false;
    protected IGridSystem grid;
    protected int pageSize = 1000000;
    protected int current = 0;
    protected int level;
    protected MongoTileSaver tileSaver;
    protected ConcurrentLinkedQueue<String> tileKey = new ConcurrentLinkedQueue();
    protected long count = 0L;
    protected boolean isOver = false;
    protected boolean loged = true;
    protected Integer filterLevel;

    public TileLayoutScroll(int level, IGridSystem grid, MongoTileSaver tileSaver, Integer filterLevel, boolean loged) {
        this.grid = grid;
        this.tileSaver = tileSaver;
        this.level = level;
        this.loged = loged;
        this.filterLevel = filterLevel;
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.isOver) {
            return false;
        }
        if (!this.tileKey.isEmpty()) {
            return true;
        }
        this.getTilesPlan(this.loged);
        if (this.tileKey.isEmpty()) {
            this.isOver = true;
            return false;
        }
        return true;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        this.count = this.level == this.grid.getBeginLevel() ? this.getCount(this.level + 1).longValue() : this.getCount(this.level).longValue();
        this.init = true;
        if (GlobalTileSettings.MG_SCROLL_PAGESIZE > 10) {
            this.pageSize = GlobalTileSettings.MG_SCROLL_PAGESIZE;
        }
    }

    @Override
    public Long getCount() {
        if (this.level == this.grid.getBeginLevel()) {
            return this.count;
        }
        return this.count * 4L;
    }

    @Override
    public TileLayout next() {
        String tile = this.tileKey.poll();
        if (tile == null) {
            return null;
        }
        if (this.tileKey.isEmpty()) {
            boolean hasNextBatch = this.current > 0;
            this.isOver = !hasNextBatch;
        }
        return this.getGridExtentByTileKey(tile);
    }

    private void getTilesPlan(boolean loged) {
        List<String> tileKeyprevious;
        int fetchedCount;
        if (loged) {
            this.logger.info("\u67e5\u8be2\u4e0a\u7ea7\u74e6\u7247\u6846\u67b6\uff1a{}\u7ea7, \u5206\u9875\uff08{} ~ {}\uff09", new Object[]{this.level - 1, this.current, this.current + this.pageSize});
        }
        if ((fetchedCount = (tileKeyprevious = this.getCreateTiles(this.level - 1, this.current, this.pageSize)).size()) > 0) {
            this.current += fetchedCount;
            this.logger.info("\u5206\u9875\u67e5\u8be2\u83b7\u5f97\u4e0a\u7ea7\u74e6\u7247\u4e2a\u6570\uff1a {}", (Object)fetchedCount);
            if (Log4jUtil.isDiagnoseEnable()) {
                this.logger.info("{} \u7ea7\u5f53\u524d\u6279\u6b21\u5f85\u5904\u7406\u74e6\u7247\u4e2a\u6570\u7ea6\u4e3a: {}", (Object)this.level, (Object)(fetchedCount * 4));
                if (this.current > fetchedCount && this.current < this.pageSize) {
                    this.logger.warn("\u3010\u6027\u80fd\u8b66\u544a\u3011\u5206\u9875\u67e5\u8be2\u74e6\u7247\u6846\u67b6\u6162\uff0c\u5efa\u8bae\u4f18\u5316mongodb\u6570\u636e\u5e93\u670d\u52a1\u5668\u6027\u80fd\u3002{}", (Object)this.tileSaver.getUri());
                }
            }
        } else {
            this.logger.info("\u5206\u9875\u52a0\u8f7d\u5b8c\u6210");
        }
        if (tileKeyprevious.size() == 0 && this.current == 0 && this.level == this.grid.getBeginLevel()) {
            tileKeyprevious = this.getCreateTiles(this.level, this.current, this.pageSize);
            for (String keyprevious : tileKeyprevious) {
                this.tileKey.offer(keyprevious);
            }
        } else {
            if (tileKeyprevious.size() == 0) {
                return;
            }
            HashSet<String> keys = new HashSet<String>(tileKeyprevious);
            for (String keyprevious : keys) {
                String surplus = "";
                String tileKeyStr = keyprevious;
                if (keyprevious.contains("@")) {
                    int index = keyprevious.indexOf("@");
                    surplus = keyprevious.substring(index);
                    tileKeyStr = keyprevious.substring(0, index);
                }
                String[] previousTileKeys = tileKeyStr.split("_");
                if (Log4jUtil.isDiagnoseEnable() && tileKeyprevious.size() < 10) {
                    this.logger.info("\u6839\u636e\u4e0a\u7ea7\u7f51\u683c{}\uff0c\u5206\u88c2\u51fa4\u4e2a\u74e6\u7247", (Object)tileKeyStr);
                }
                int previousX = Integer.parseInt(previousTileKeys[0]);
                int previousY = Integer.parseInt(previousTileKeys[1]);
                this.tileKey.offer(previousX * 2 + "_" + previousY * 2 + "_" + this.level + surplus);
                this.tileKey.offer(previousX * 2 + 1 + "_" + previousY * 2 + "_" + this.level + surplus);
                this.tileKey.offer(previousX * 2 + "_" + (previousY * 2 + 1) + "_" + this.level + surplus);
                this.tileKey.offer(previousX * 2 + 1 + "_" + (previousY * 2 + 1) + "_" + this.level + surplus);
            }
        }
    }

    private TileLayout getGridExtentByTileKey(String tileKey) {
        String[] levelAndLayers = tileKey.split("@");
        String[] key = levelAndLayers[0].split("_");
        GridExtent gridExtent = this.grid.getGridExtent(Integer.parseInt(key[2]), Integer.parseInt(key[0]), Integer.parseInt(key[1]));
        String layers = null;
        if (levelAndLayers.length > 1) {
            layers = levelAndLayers[1];
        }
        return new TileLayout(gridExtent, layers);
    }

    public List<String> getCreateTiles(int level, int begin, int length) {
        Document data = new Document();
        data.put(MongoTileSaver.lName, (Object)level);
        if (this.filterLevel != null) {
            data.put(MongoTileSaver.isLayout, (Object)1);
            data.put("ffilterLevel", (Object)this.filterLevel);
        }
        Document fields = new Document();
        fields.put(MongoTileSaver.lName, (Object)1);
        fields.put(MongoTileSaver.rName, (Object)1);
        fields.put(MongoTileSaver.cName, (Object)1);
        fields.put("flayers", (Object)1);
        FindIterable fi = this.tileSaver.getMongoDao().findCollection((Bson)data, (Bson)fields);
        fi = fi.skip(begin).limit(length);
        ArrayList<String> keyList = new ArrayList<String>();
        for (Document doc : fi) {
            keyList.add(TileLayoutScroll.getKey(doc));
        }
        return keyList;
    }

    static String getKey(Document doc) {
        String key = doc.get((Object)MongoTileSaver.rName) + "_" + doc.get((Object)MongoTileSaver.cName) + "_" + doc.get((Object)MongoTileSaver.lName);
        if (doc.get((Object)"flayers") != null) {
            key = key + "@";
            key = key + doc.get((Object)"flayers");
        }
        return key;
    }

    public Long getCount(int level) {
        Document data = new Document();
        data.put(MongoTileSaver.lName, (Object)(level - 1));
        if (this.filterLevel != null) {
            data.put(MongoTileSaver.isLayout, (Object)1);
            data.put("ffilterLevel", (Object)this.filterLevel);
        }
        long tileCount = this.tileSaver.getMongoDao().count((Bson)data);
        this.logger.info("\u67e5\u8be2mongo\u4e2d{}\u7ea7\u7684\u74e6\u7247\u603b\u6570\u4e3a\uff1a{} {}", new Object[]{level - 1, tileCount, this.filterLevel != null ? "\u3002\u6846\u67b6\u8fc7\u6ee4\u7ea7\u522b\uff1a" + this.filterLevel : ""});
        return tileCount;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void release() {
    }

    public void setBatch(int begin, int end) {
        this.current = begin;
    }
}

