/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.cluster.pipeline;

import com.geoway.vtile.cluster.bean.TaskContext;
import com.geoway.vtile.cluster.pipeline.ITaskHandler;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.scroll.ITileScroll;
import com.geoway.vtile.tiledispatch.consumer.scroll.TileListScroll;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.transform.cell.layout.MapTilePrecutter;
import com.geoway.vtile.transform.cell.layout.TileLayout;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridsFilterHandler
implements ITaskHandler {
    private static Logger logger = LoggerFactory.getLogger(GridsFilterHandler.class);
    private TaskContext ctx;
    private MapTilePrecutter mapPrecutter;

    @Override
    public Object handleGrids(TaskContext ctx) {
        if (ctx.getStageLevel1() > 15) {
            return null;
        }
        System.out.println("\u9884\u5904\u7406\uff1a\u67e5\u8be2\u8fc7\u6ee4\u7a7a\u7f51\u683c");
        this.ctx = ctx;
        this.initMapPrecutter();
        long timeStart = System.currentTimeMillis();
        ITileScroll scroll = ctx.getGridsScroll();
        TileListScroll listScroll = new TileListScroll();
        while (scroll.hasNext()) {
            if (!this.ctx.isRunning()) {
                this.mapPrecutter.cancel();
                break;
            }
            TileLayout tileLayout = scroll.next();
            GridExtent grid = tileLayout.getExtent();
            if (this.hitGrid(tileLayout)) {
                listScroll.add(grid);
                continue;
            }
            System.out.println("\u8fc7\u6ee4\u65e0\u6548\u7684\u7a7a\u7f51\u683c\uff1a" + grid.getCodeXYL());
            ctx.getTileOptimizer().registerEmptyGrid(grid);
        }
        double taskSeconds = (double)(System.currentTimeMillis() - timeStart) * 1.0 / 1000.0;
        logger.info(Log4jUtil.MARKER_DIAG, "==> \u8fc7\u6ee4 {} \u7ea7\u7f51\u683c\u7ed3\u675f, \u8017\u65f6: {} s", (Object)this.ctx.getStageLevel1(), (Object)String.format("%.3f", taskSeconds));
        ctx.setGridsScroll(listScroll);
        return listScroll;
    }

    private boolean hitGrid(TileLayout tileLayout) {
        try {
            GridExtent extent = tileLayout.getExtent();
            TileCutOptions options = new TileCutOptions();
            options.setStart(0);
            options.setLimit(1);
            List layouts = this.mapPrecutter.cut(extent, options);
            boolean isGridHasData = null != layouts;
            return isGridHasData;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private void initMapPrecutter() {
        IVectorService map = this.ctx.getMapService();
        ExecutorService threadPool = TileDispatchTaskManager.getInstance().getNewExecutor();
        MapTilePrecutter mapPrecut = new MapTilePrecutter(map, threadPool);
        mapPrecut.setMainLevel(Integer.valueOf(this.ctx.getStageLevel1()));
        mapPrecut.setDown(0);
        mapPrecut.init();
        this.mapPrecutter = mapPrecut;
    }
}

