/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.consumer.handler;

import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.handler.TileListCutHandler;
import com.geoway.vtile.tiledispatch.consumer.handler.error.ITileErrorHandler;
import com.geoway.vtile.tiledispatch.consumer.saver.ITileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.layout.TileLayout;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.enums.LAYER_TYPE;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class TileListCutLabelHandler
extends TileListCutHandler {
    protected ITileCutterCell<GridExtent, Map<LAYER_TYPE, List<Object[]>>> cell;
    protected ITileSaver labelSaver;
    protected IDocumentEncoder labelEncoder;

    public TileListCutLabelHandler(ExecutorService executor, int bufferSize) {
        super(executor, bufferSize);
    }

    public TileListCutLabelHandler(ExecutorService executor, int bufferSize, ITileCutterCell cell, ITileSaver saver, ITileSaver labelSaver, IDocumentEncoder encoder, IDocumentEncoder labelEncode) {
        super(executor, bufferSize, cell, saver, encoder);
        this.cell = cell;
        this.labelSaver = labelSaver;
        this.labelEncoder = labelEncode;
    }

    public TileListCutLabelHandler(ExecutorService executor, int bufferSize, ITileCutterCell cell, ITileSaver saver, ITileSaver labelSaver, ITileErrorHandler errorHandler, IDocumentEncoder encoder, IDocumentEncoder labelEncode) {
        super(executor, bufferSize, cell, saver, errorHandler, encoder);
        this.cell = cell;
        this.labelSaver = labelSaver;
        this.labelEncoder = labelEncode;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        if (this.cell != null) {
            this.cell.init();
        }
        this.saver.init();
        this.init = true;
    }

    @Override
    public void flush() {
    }

    @Override
    public void handle(TileLayout layout) {
        GridExtent extent = layout.getExtent();
        String extraFilter = layout.getExtraFilter();
        if (this.executor != null) {
            this.executor.execute(() -> this.handleItem(extent, extraFilter));
        } else {
            this.handleItem(extent, extraFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleItem(GridExtent extent, String extraFilter) {
        if (this.resume && this.saver.hasRecord(extent) || this.cancel) {
            this.count.countDown();
            return;
        }
        if (this.error) {
            this.count.countDown();
            return;
        }
        TileCutOptions options = new TileCutOptions();
        options.setExtraSqlFilter(extraFilter);
        Map data = null;
        try {
            data = (Map)this.cell.cut((Object)extent, options);
            if (data == null) {
                this.saver.save(null, this.encoder);
                this.labelSaver.save(null, this.labelEncoder);
            } else {
                this.saver.save((List)data.get(LAYER_TYPE.layer), this.encoder);
                this.labelSaver.save((List)data.get(LAYER_TYPE.label), this.labelEncoder);
            }
            if (data != null && data.containsKey(LAYER_TYPE.layer) && null != this.progressFunc) {
                boolean hasData = !((List)data.get(LAYER_TYPE.layer)).isEmpty();
                this.progressFunc.accept(hasData ? 1 : 0);
            }
        }
        catch (Throwable e) {
            if (this.errorHandler != null) {
                this.errorHandler.handle(extent);
            } else {
                this.e = e;
                this.error = true;
            }
        }
        finally {
            this.count.countDown();
        }
    }

    @Override
    public void cancel() {
        this.cell.cancel();
        super.cancel();
    }
}

