/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.consumer.saver;

import com.geoway.vtile.manager.task.log.ITaskLogger;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.saver.ITileSaveCallback;
import com.geoway.vtile.tiledispatch.consumer.saver.ITileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.github.javaparser.utils.Log;
import java.io.ByteArrayInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqliteTileSaver
implements ITileSaver {
    private static Logger LOG = LoggerFactory.getLogger(SqliteTileSaver.class);
    private static int INITIALIZE_TIMEOUT_SECONDs = 60;
    public static String f_l = "zoom_level";
    public static String f_x = "tile_column";
    public static String f_y = "tile_row";
    public static String f_data = "tile_data";
    private static String jdbcPrefix = "jdbc:sqlite:";
    private String dbfile;
    private String storageTableName;
    protected boolean init = false;
    private Connection dbConn;
    private ITileSaveCallback saveCallback = null;

    public SqliteTileSaver(String dbfile, String tableName) {
        this.dbfile = dbfile;
        this.storageTableName = tableName;
    }

    @Override
    public void init(ITaskLogger logger) {
        if (logger != null) {
            logger.log("\u8fde\u63a5\u672c\u5730\u6570\u636e\u5e93: " + this.dbfile);
        }
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(jdbcPrefix + this.dbfile);
            stmt = conn.createStatement();
            stmt.executeUpdate("PRAGMA journal_mode = WAL;");
            String deleteSql = "DROP TABLE IF EXISTS " + this.storageTableName;
            String sql = "CREATE TABLE IF NOT EXISTS " + this.storageTableName + " (zoom_level INTEGER NOT NULL,tile_column INTEGER NOT NULL,tile_row INTEGER NOT NULL,tile_data BLOB NOT NULL)";
            String index_sql = "CREATE INDEX idx_" + this.storageTableName + " ON " + this.storageTableName + "(zoom_level, tile_column, tile_row)";
            stmt.addBatch(deleteSql);
            stmt.addBatch(sql);
            stmt.addBatch(index_sql);
            stmt.executeBatch();
        }
        catch (Exception e) {
            throw new RuntimeException("\u521d\u59cb\u5316\u74e6\u7247\u8868\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (logger != null) {
            logger.log("\u5df2\u521d\u59cb\u5316\u74e6\u7247\u8868: " + this.storageTableName);
        }
        if (null != conn) {
            this.dbConn = conn;
        }
        this.init = true;
    }

    public void close() throws Exception {
        if (this.init && null != this.dbConn) {
            this.dbConn.close();
        }
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        CompletableFuture<Void> promise = CompletableFuture.runAsync(() -> this.init(null));
        try {
            promise.exceptionally(ex -> {
                throw new RuntimeException("\u521d\u59cb\u5316sqlite\u74e6\u7247\u96c6" + this.storageTableName + "\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)ex);
            });
            promise.get(INITIALIZE_TIMEOUT_SECONDs, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521d\u59cb\u5316sqlite\u74e6\u7247\u96c6" + this.storageTableName + "\u8d85\u65f6\uff0c\u5efa\u8bae\u68c0\u67e5\u6570\u636e\u5e93\u8def\u5f84\u914d\u7f6e\u3002", e);
        }
    }

    public void onSave(ITileSaveCallback callback) {
        this.saveCallback = callback;
    }

    @Override
    public <T> void save(List<T> data, IDocumentEncoder<T> encoder) {
        if (data == null || data.isEmpty()) {
            return;
        }
        Statement stmt = null;
        try {
            boolean oldCfg = this.dbConn.getAutoCommit();
            this.dbConn.setAutoCommit(false);
            String sql = "insert into " + this.storageTableName + " (zoom_level,tile_column,tile_row,tile_data) values(?,?,?,?)";
            stmt = this.dbConn.prepareStatement(sql);
            int batchCount = 0;
            for (T item : data) {
                List<Object> props = this.encodeTileData((Object[])item);
                stmt.setInt(1, (Integer)props.get(0));
                stmt.setInt(2, (Integer)props.get(1));
                stmt.setInt(3, (Integer)props.get(2));
                ByteArrayInputStream strm = new ByteArrayInputStream((byte[])props.get(3));
                stmt.setBlob(4, strm);
                stmt.addBatch();
                if (++batchCount % 100 == 0) {
                    stmt.executeBatch();
                    stmt.clearBatch();
                    batchCount = 0;
                    Log.info((String)"\u63d2\u5165100\u6761\u8bb0\u5f55", (Supplier[])new Supplier[0]);
                }
                if (null == this.saveCallback) continue;
                try {
                    this.saveCallback.saveTile((Integer)props.get(0), (Integer)props.get(1), (Integer)props.get(2));
                }
                catch (Exception exception) {}
            }
            int[] result = stmt.executeBatch();
            this.dbConn.commit();
            this.dbConn.setAutoCommit(oldCfg);
            Log.info((String)("\u6279\u91cf\u63d2\u5165\u5b8c\u6210\uff0c\u5171\u63d2\u5165 " + result.length + " \u6761\u74e6\u7247\u8bb0\u5f55"), (Supplier[])new Supplier[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8fde\u63a5db\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private List<Object> encodeTileData(Object[] data) {
        GridExtent extent = (GridExtent)data[0];
        if (null == data[1]) {
            return null;
        }
        byte[] bytes = (byte[])data[1];
        ArrayList<Object> oneTileData = new ArrayList<Object>(4);
        oneTileData.add(extent.getLevel());
        oneTileData.add(extent.getX());
        oneTileData.add(extent.getY());
        oneTileData.add(bytes);
        return oneTileData;
    }

    @Override
    public <T> void saveItem(T data, IDocumentEncoder<T> encoder) {
        if (data == null) {
            return;
        }
        ArrayList<T> datas = new ArrayList<T>(1);
        datas.add(data);
        this.save(datas, encoder);
    }

    @Override
    public void setEndTime(List<GridExtent> extents, long time) {
        throw new NotImplementedException("\u5f85\u5b9e\u73b0\u529f\u80fd\uff01");
    }

    @Override
    public <T> void updateEndTimeAndSave(List<T> data, long time, IDocumentEncoder<T> encoder) {
        throw new NotImplementedException("\u5f85\u5b9e\u73b0\u529f\u80fd\uff01");
    }

    @Override
    public void setBeginTime(List<GridExtent> extents, long time) {
        throw new NotImplementedException("\u5f85\u5b9e\u73b0\u529f\u80fd\uff01");
    }

    @Override
    public Map<String, byte[]> getTiles(List<GridExtent> extents, Long time) {
        throw new NotImplementedException("\u5f85\u5b9e\u73b0\u529f\u80fd\uff01");
    }

    @Override
    public Map<String, byte[]> getTiles(Set<String> extentKeys, Long time) {
        throw new NotImplementedException("\u5f85\u5b9e\u73b0\u529f\u80fd\uff01");
    }

    @Override
    public void updateTiles(Map<String, byte[]> tiles) {
        throw new NotImplementedException("\u5f85\u5b9e\u73b0\u529f\u80fd\uff01");
    }

    @Override
    public void remove(List<GridExtent> extents) {
        if (extents == null || extents.isEmpty()) {
            return;
        }
        Statement stmt = null;
        try {
            boolean oldCfg = this.dbConn.getAutoCommit();
            this.dbConn.setAutoCommit(false);
            String sql = "DELETE FROM " + this.storageTableName + " WHERE zoom_level=? AND tile_column=? AND tile_row=? ";
            stmt = this.dbConn.prepareStatement(sql);
            int batchCount = 0;
            for (GridExtent item : extents) {
                stmt.setInt(1, item.getLevel());
                stmt.setInt(2, item.getX());
                stmt.setInt(3, item.getY());
                stmt.addBatch();
                ++batchCount;
            }
            int[] result = stmt.executeBatch();
            this.dbConn.commit();
            this.dbConn.setAutoCommit(oldCfg);
            Log.info((String)("\u5df2\u5220\u9664 " + result.length + " \u6761\u74e6\u7247\u8bb0\u5f55"), (Supplier[])new Supplier[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("\u8fde\u63a5db\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public boolean hasRecord(GridExtent extent) {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(jdbcPrefix + this.dbfile);
            stmt = conn.createStatement();
            String sql = "SELECT 1 FROM " + this.storageTableName + " WHERE zoom_level=" + extent.getLevel() + "AND tile_column=" + extent.getX() + "AND tile_row=" + extent.getY();
            int ret = stmt.executeUpdate(sql);
            boolean bl = ret > 0;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8fde\u63a5db\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
        finally {
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public boolean hasRecord(GridExtent extent, Long beginTime) {
        throw new NotImplementedException("\u5f85\u5b9e\u73b0\u529f\u80fd\uff01");
    }

    @Override
    public void removeAndUpdateEndTime(GridExtent extent, Long timestamp, Long nextTime) {
        throw new NotImplementedException("\u5f85\u5b9e\u73b0\u529f\u80fd\uff01");
    }
}

