/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.task;

import com.geoway.vtile.model.vector_service.CacheInfoBean;
import com.geoway.vtile.model.vector_service.CacheInfoShell;
import com.geoway.vtile.model.vector_service.ICacheable;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.service.mapserver.MapServerAccess;
import com.geoway.vtile.tiledispatch.consumer.ITileConsumer;
import com.geoway.vtile.tiledispatch.consumer.VectorCutMongoConsumer;
import com.geoway.vtile.tiledispatch.consumer.handler.ImageCacheHandler;
import com.geoway.vtile.tiledispatch.consumer.saver.ImageCacheTileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.MongoTileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.TileDataDocumentEncoder;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.TileLayoutDocumentEncoder;
import com.geoway.vtile.tiledispatch.consumer.scroll.ITileScroll;
import com.geoway.vtile.tiledispatch.consumer.scroll.ImageCacheMongoDataScroll;
import com.geoway.vtile.tiledispatch.executor.DoubleQueueExecutor;
import com.geoway.vtile.tiledispatch.producer.ITileProducer;
import com.geoway.vtile.tiledispatch.producer.TileLayoutProducer;
import com.geoway.vtile.tiledispatch.task.stage.TileConsumeStage;
import com.geoway.vtile.tiledispatch.task.stage.TileProduceStage;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.ImgCacheCell;
import com.geoway.vtile.transform.cell.layout.ITileLayoutPrecutter;
import com.geoway.vtile.transform.cell.layout.MapTilePrecutter;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class ImagePreheatTask
extends AbstractTileDispatchTask {
    MongodbDataSource mongodbDataSource;
    IVectorService vectorService;
    ICacheable cacheable;
    ImageCacheTileSaver saver;
    MongoTileSaver gridSaver;
    Integer beginLevel;
    Integer endLevel;
    List<String> styleIds;
    List<Integer> tileSizeList;
    List<Integer> ratioList;
    Integer type;
    Boolean cover;
    ExecutorService cutExecutor;

    public ImagePreheatTask(String name, MongodbDataSource mongodbDataSource, IVectorService vectorService, List<String> styleIds, List<Integer> tileSizeList, List<Integer> ratioList, Integer beginLevel, Integer endLevel, Integer cacheType, Boolean cover) {
        super(name);
        this.mongodbDataSource = mongodbDataSource;
        this.vectorService = vectorService;
        this.beginLevel = beginLevel;
        this.endLevel = endLevel;
        this.cacheable = this.vectorService.getCacheInfo();
        this.styleIds = styleIds;
        this.tileSizeList = tileSizeList;
        this.ratioList = ratioList;
        this.type = cacheType;
        this.cover = cover;
        this.bbox = vectorService.getBbox();
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.gridSaver = this.createGridSaver((String)this.vectorService.getId() + "_img_cache_grid");
        int taskNum = Runtime.getRuntime().availableProcessors();
        if (this.executor == null) {
            this.executor = new DoubleQueueExecutor(taskNum);
        }
        this.cutExecutor = new DoubleQueueExecutor(taskNum * 2);
        this.grid = this.vectorService.getGridTree();
        this.buildStages();
    }

    @Override
    public void success() throws Exception {
        CacheInfoBean cacheInfoBean = this.cacheable.getCacheInfoBean();
        cacheInfoBean.setImgCacheSourceId(this.mongodbDataSource.getId());
        cacheInfoBean.setDataCacheSourceId(this.mongodbDataSource.getId());
        this.vectorService.addCacheInfo((ICacheable)new CacheInfoShell(this.vectorService.getClient(), cacheInfoBean));
        this.vectorService.getClient().getVectorServiceManager().update((Object)this.vectorService);
        super.success();
    }

    protected void buildStages() {
        boolean needProducer = true;
        if (needProducer) {
            String produceStageName = "\u751f\u4ea7" + this.beginLevel + "\u81f3" + this.endLevel + "\u7ea7\u522b\u74e6\u7247\u6846\u67b6";
            MapTilePrecutter layoutCell = new MapTilePrecutter(this.vectorService, this.cutExecutor);
            layoutCell.setMainLevel(Integer.valueOf(this.endLevel + 1));
            layoutCell.setDown(0);
            ITileProducer producer = this.createProducer(this.beginLevel, this.endLevel, (ITileLayoutPrecutter)layoutCell);
            TileProduceStage gridStage = new TileProduceStage(produceStageName, producer, null, null);
            gridStage.setLogger(this.cutLogger);
            this.stages.add(gridStage);
        }
        MapServerAccess.ImgCacheType imgCacheType = this.type == 0 ? MapServerAccess.ImgCacheType.all : (this.type == 1 ? MapServerAccess.ImgCacheType.layer : MapServerAccess.ImgCacheType.label);
        try {
            for (String styleId : this.styleIds) {
                this.saver = this.createTileSaver((String)this.vectorService.getId() + "_" + styleId + "_img_cache");
                for (Integer tileSize : this.tileSizeList) {
                    for (Integer ratio : this.ratioList) {
                        String ratioName = ratio == 1 ? "\u6807\u51c6" : "\u9ad8\u6e05";
                        ImgCacheCell cell = new ImgCacheCell((String)this.vectorService.getId(), styleId, tileSize, ratio, this.vectorService.getClient().getMapServerAccess(), this.vectorService.getClient().getNodeManager(), imgCacheType);
                        for (int level = this.beginLevel.intValue(); level <= this.endLevel; ++level) {
                            ImageCacheMongoDataScroll scroll = new ImageCacheMongoDataScroll(level, this.grid, this.gridSaver, null, true);
                            this.tileConsumer = this.createConsumer(cell, scroll, level);
                            String consumeStageName = "\u751f\u4ea7\u6837\u5f0f\u4e3a" + styleId + ",\u5927\u5c0f\u4e3a" + tileSize + "\u7684\u7b2c" + level + "\u7ea7\u522b" + ratioName + "\u56fe\u7247\u7f13\u5b58\u74e6\u7247";
                            TileConsumeStage cacheStage = new TileConsumeStage(consumeStageName, this.tileConsumer);
                            cacheStage.setLogger(this.cutLogger);
                            this.stages.add(cacheStage);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this.log(ex.getMessage());
        }
    }

    protected ITileProducer createProducer(int start, int end, ITileLayoutPrecutter cell) {
        TileLayoutProducer tileProducer = new TileLayoutProducer(cell, this.gridSaver, this.executor, start, end, this.grid, this.bbox, (String)this.vectorService.getId(), new TileLayoutDocumentEncoder());
        tileProducer.setLogPool(this.logPool);
        tileProducer.setLogger(this.cutLogger);
        tileProducer.setUtfgrid(true);
        tileProducer.init();
        return tileProducer;
    }

    private ITileConsumer createConsumer(ImgCacheCell cell, ITileScroll scroll, Integer level) {
        ImageCacheHandler handlerStream = new ImageCacheHandler(this.executor, 1, (ITileCutterCell)cell, this.saver, new TileDataDocumentEncoder(), this.cover);
        handlerStream.setResume(this.resume);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    private ImageCacheTileSaver createTileSaver(String storageName) {
        try {
            ImageCacheTileSaver tileSaver = new ImageCacheTileSaver(this.mongodbDataSource.getUri(), storageName);
            tileSaver.setEnableSharding(true);
            tileSaver.init(this.cutLogger);
            return tileSaver;
        }
        catch (Exception ex) {
            this.log("\u521b\u5efa\u7f13\u5b58\u5b58\u50a8\u5931\u8d25 :" + ex.getMessage());
            throw new RuntimeException(ex.getMessage());
        }
    }

    private MongoTileSaver createGridSaver(String storageName) {
        try {
            MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), storageName);
            tileSaver.setEnableSharding(true);
            tileSaver.init(this.cutLogger);
            return tileSaver;
        }
        catch (Exception ex) {
            this.log("\u521b\u5efa\u683c\u7f51\u5b58\u50a8\u5931\u8d25 :" + ex.getMessage());
            throw new RuntimeException(ex.getMessage());
        }
    }
}

