/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.v4;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.ProjConfigBean;
import com.geoway.vtile.model.vector_service.ProjectedMapInfo;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.layer.Label;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.tiledispatch.consumer.scroll.ITileScroll;
import com.geoway.vtile.tiledispatch.consumer.scroll.TileRangeScroll;
import com.geoway.vtile.transform.cellv4.LayerFilterSchema;
import com.geoway.vtile.transform.cellv4.TileOptimizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapPrecutSchema {
    private static Logger logger = LoggerFactory.getLogger(MapPrecutSchema.class);
    private IVectorService mapService;
    private int startLevel;
    private int endLevel;
    private String bbox;
    private Map<Integer, ITileScroll> levelLayouts = null;
    private Map<Integer, Map<Integer, List<Integer>>> savedTileGrids = null;

    public void prepare(IVectorService mapService, String bbox, Integer beginLevel, Integer endLevel) {
        this.mapService = mapService;
        this.bbox = bbox;
        this.startLevel = beginLevel;
        this.endLevel = endLevel;
        this.produceLayoutGrids();
    }

    private void produceLayoutGrids() {
        IGridSystem grid = this.mapService.getGridTree();
        String mapExtent = this.bbox;
        TileRangeScroll gridsCursor = null;
        this.levelLayouts = new LinkedHashMap<Integer, ITileScroll>();
        ProjConfigBean projConf = this.mapService.getProjConfig();
        if (null != projConf && projConf.isProject) {
            ProjectedMapInfo projectMeta = this.mapService.getProjectedMeta();
            grid = projectMeta.getGridTree();
            mapExtent = projectMeta.getBbox();
        }
        logger.info("build layout grids, level: {}~{}", (Object)this.startLevel, (Object)this.endLevel);
        for (int i = this.startLevel; i <= this.endLevel; ++i) {
            int level = i;
            gridsCursor = new TileRangeScroll(level, mapExtent, grid);
            gridsCursor.init();
            this.levelLayouts.put(level, gridsCursor);
            if (!Log4jUtil.isDiagnoseEnable()) continue;
            logger.info("level {} grids count: {}", (Object)level, (Object)gridsCursor.getCount());
        }
    }

    public void saveGrid(int level, int x, int y) {
        List<Integer> colArr;
        if (null == this.savedTileGrids) {
            this.savedTileGrids = new LinkedHashMap<Integer, Map<Integer, List<Integer>>>();
        }
        if (level > 15) {
            return;
        }
        Map<Integer, List<Integer>> mapOfLevel = this.savedTileGrids.get(level);
        if (null == mapOfLevel) {
            mapOfLevel = new HashMap<Integer, List<Integer>>();
            this.savedTileGrids.put(level, mapOfLevel);
        }
        if (null == (colArr = mapOfLevel.get(x))) {
            colArr = new ArrayList<Integer>();
            mapOfLevel.put(x, colArr);
        }
        colArr.add(y);
    }

    public void refineGrids(TileOptimizer optm, boolean isResumeTask) {
    }

    public ITileScroll getScroll(int level) {
        return this.levelLayouts.get(level);
    }

    public List<GridExtent> deriveLayoutScroll(int level) {
        if (null == this.savedTileGrids) {
            return null;
        }
        Map<Integer, List<Integer>> mapOfLevel = this.savedTileGrids.get(level - 1);
        if (null == mapOfLevel) {
            logger.warn("\u4e0a\u4e00\u4e2a\u5c42\u7ea7" + (level - 1) + "\u65e0\u74e6\u7247\u8bb0\u5f55\u3002");
            return null;
        }
        IGridSystem gridsys = this.mapService.getGridTree();
        ArrayList<GridExtent> list = new ArrayList<GridExtent>();
        mapOfLevel.forEach((x, ylist) -> ylist.forEach(y -> {
            list.add(gridsys.getGridExtent(level, 2 * x, 2 * y));
            list.add(gridsys.getGridExtent(level, 2 * x, 2 * y + 1));
            list.add(gridsys.getGridExtent(level, 2 * x + 1, 2 * y));
            list.add(gridsys.getGridExtent(level, 2 * x + 1, 2 * y + 1));
        }));
        logger.info(level + "\u7ea7\u9884\u8ba1\u6709 " + list.size() + " \u4e2a\u7f51\u683c");
        return list;
    }

    public void analyzeFilters(TileOptimizer optm) {
        Map layers = this.mapService.getLayerMap();
        HashMap<String, LayerFilterSchema> filtersMap = new HashMap<String, LayerFilterSchema>();
        for (ILayer layer : layers.values()) {
            String layerName = layer.getId();
            Boolean hasLabel = layer.isHaveLabel();
            Label layerLabel = layer.getLabel();
            LayerFilterSchema filterSchema = new LayerFilterSchema();
            filterSchema.layerName = layerName;
            for (int i = this.startLevel; i <= this.endLevel; ++i) {
                String currLevelLabelFilter;
                String currLevelFilter;
                ILayerLevel llevel = (ILayerLevel)layer.getLevelMap().get(i);
                if (null == llevel) continue;
                filterSchema.baseFilters[i] = currLevelFilter = llevel.getFilterExpression();
                if (!hasLabel.booleanValue() || null == layerLabel) continue;
                filterSchema.labelFilters[i] = currLevelLabelFilter = layerLabel.getFilterAtLevel(String.valueOf(i));
            }
            filtersMap.put(layerName, filterSchema);
        }
        optm.setLayerFilters(filtersMap);
        boolean allSame = optm.isSameFilterAtLevels(this.startLevel, this.endLevel);
        optm.setAllLayerSameFilter(allSame);
    }

    public void release() {
        if (null == this.levelLayouts) {
            return;
        }
        this.levelLayouts.clear();
    }
}

