/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.task.update;

import com.geoway.vtile.model.vector_service.ICacheable;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.tiledispatch.consumer.ITileConsumer;
import com.geoway.vtile.tiledispatch.consumer.VectorCutMongoConsumer;
import com.geoway.vtile.tiledispatch.consumer.handler.update.VectorServerUpdateHandler;
import com.geoway.vtile.tiledispatch.consumer.saver.ITileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.MongoTileSaver;
import com.geoway.vtile.tiledispatch.consumer.scroll.ITileScroll;
import com.geoway.vtile.tiledispatch.consumer.scroll.WktArrayScroll;
import com.geoway.vtile.tiledispatch.executor.DoubleQueueExecutor;
import com.geoway.vtile.tiledispatch.task.stage.TileConsumeStage;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractUpdateTask;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.ServerTileCutterCell;
import com.geoway.vtile.transform.cell.process.ProcessList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class TileServerUpdateTask
extends AbstractUpdateTask {
    IVectorService vectorService;
    MongodbDataSource mongodbDataSource;
    MongoTileSaver saver;
    public static final int CUT_INTERVAL = 2;
    ExecutorService cutExecutor;
    Map<String, List<String>> updateRegions;
    long timestamp;

    public TileServerUpdateTask(String name, IVectorService vectorService, IGridSystem grid, Map<String, List<String>> updateRegions, Long timestamp) {
        super(name);
        this.vectorService = vectorService;
        this.grid = grid;
        IStorageInfo storageInfo = this.vectorService.getStorageInfo();
        if (storageInfo == null) {
            throw new RuntimeException("\u672a\u9884\u70ed\u74e6\u7247\u7684\u670d\u52a1\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mongodbDataSource = (MongodbDataSource)storageInfo.getDataSource().getBean();
        this.beginLevel = storageInfo.getStartLevel();
        this.endLevel = storageInfo.getEndLevel();
        this.updateRegions = updateRegions;
        this.timestamp = timestamp == null ? new Date().getTime() : timestamp.longValue();
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.saver = this.createTileSaver();
        int taskNum = Runtime.getRuntime().availableProcessors();
        if (this.executor == null) {
            this.executor = new DoubleQueueExecutor(taskNum);
        }
        ProcessList.clearCache();
        this.cutExecutor = new DoubleQueueExecutor(taskNum * 2);
        this.buildStages();
    }

    private ITileConsumer createConsumer(int start, int end) {
        ServerTileCutterCell cutterCell = new ServerTileCutterCell(this.vectorService, this.cutExecutor);
        cutterCell.setDown(end - start);
        cutterCell.setMainLevel(Integer.valueOf(start));
        ServerTileCutterCell serverTileCutterCell = cutterCell;
        serverTileCutterCell.setReturnWriter(true);
        VectorServerUpdateHandler handlerStream = new VectorServerUpdateHandler(this.executor, 1, (ITileCutterCell)cutterCell, (ITileSaver)this.saver, this.timestamp, this.removeOldTile);
        handlerStream.setResume(this.resume);
        ITileScroll scroll = this.getTileScroll(start);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    private ITileScroll getTileScroll(int start) {
        return new WktArrayScroll(this.updateRegions, this.grid, start);
    }

    private MongoTileSaver createTileSaver() {
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), (String)this.vectorService.getId());
        tileSaver.init();
        return tileSaver;
    }

    @Override
    public void success() throws Exception {
        IStorageInfo storageInfo = this.vectorService.getStorageInfo();
        storageInfo.setCompleted(true);
        try {
            this.vectorService.getClient().getVectorServiceManager().update((Object)this.vectorService);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ICacheable cacheable = this.vectorService.getCacheInfo();
        if (cacheable != null && !this.resume) {
            cacheable.drop((String)this.vectorService.getId(), null);
        }
        super.success();
    }

    private void buildStages() {
        this.stages = new ArrayList();
        int interval = this.beginLevel <= 10 ? 0 : 2;
        int end = this.beginLevel;
        int start = this.beginLevel;
        while (start <= this.endLevel) {
            int n = end = start + interval < this.endLevel ? start + interval : this.endLevel;
            if (this.endLevel - end <= 3) {
                end = this.endLevel;
            }
            int startLevel = start;
            if (end >= 10) {
                interval = 2;
            }
            ITileConsumer tileConsumer = this.createConsumer(start, end);
            String consumeStageName = "\u751f\u4ea7" + start + "\u81f3" + end + "\u7ea7\u522b\u74e6\u7247";
            TileConsumeStage stage = new TileConsumeStage(consumeStageName, tileConsumer);
            stage.setLogger(this.cutLogger);
            this.stages.add(stage);
            start = end + 1;
        }
    }

    @Override
    public void release() {
        if (null != this.cutExecutor && !this.cutExecutor.isShutdown()) {
            this.cutExecutor.shutdown();
        }
        ProcessList.clearCache();
        super.release();
    }
}

