/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell.layout;

import com.geoway.vtile.model.data_service.DataServiceBean;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datasource.db.DbDataSource;
import com.geoway.vtile.resources.datatable.ITable;
import com.geoway.vtile.resources.datatable.dao.IMapDAO;
import com.geoway.vtile.resources.sql.jdbc.Transactions;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.cell.abstractclass.AbstractLayerTileCell;
import com.geoway.vtile.transform.cell.layout.ITileLayoutPrecutter;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerTilePrecutter
extends AbstractLayerTileCell
implements ITileLayoutPrecutter<GridExtent, List<GridExtent>> {
    Logger logger = LoggerFactory.getLogger(LayerTilePrecutter.class);
    protected Integer filterLevel;
    private boolean isSameFilter = true;

    public LayerTilePrecutter(ILayer layer) {
        this.layer = layer;
    }

    @Override
    public void setDown(int down) {
        this.down = down;
    }

    @Override
    public Integer getDown() {
        return this.down;
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.isSameFilter = this.isSameDataFilter();
    }

    private boolean isSameDataFilter() {
        Map levelMap = this.layer.getLevelMap();
        ILayerLevel level = (ILayerLevel)levelMap.values().iterator().next();
        IDataSet dataSet = level.getDataSet();
        String filter = dataSet.getFilter();
        boolean isSame = !levelMap.values().stream().filter(l -> !ObjectUtils.equals((Object)l.getDataSet().getFilter(), (Object)filter)).findFirst().isPresent();
        return isSame;
    }

    private boolean checkIsSameFilter() {
        HashSet<String> levelFilters = new HashSet<String>();
        int start = this.mainLevel;
        int end = this.mainLevel + this.down;
        for (int i = start; i <= end; ++i) {
            Map levelMap = this.layer.getLevelMap();
            if (!levelMap.containsKey(i)) {
                if (this.layer.getBeginLevel() <= end && this.layer.getEndLevel() >= start) continue;
                this.logger.info("\u56fe\u5c42 {} \u4e0d\u5728\u74e6\u7247\u9884\u70ed\u5c42\u7ea7\u8303\u56f4 {}~{} \u5185", new Object[]{this.layer.getId(), start, end});
                return false;
            }
            String currLevelFilter = ((ILayerLevel)this.layer.getLevelMap().get(i)).getFilterExpression();
            levelFilters.add(currLevelFilter);
        }
        boolean isAllSame = 1 == levelFilters.size();
        return isAllSame;
    }

    @Override
    public List<GridExtent> cut(GridExtent extent, TileCutOptions options) throws Exception {
        return this.cut(extent, options.getExtraSqlFilter(), options.getStart(), options.getLimit(), options.getLimitMark());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GridExtent> cut(GridExtent extent, String extraSqlFilter, int start, int limit, Boolean limitMark) throws Exception {
        DbDataSource dataSource;
        boolean isAllLevelNotCut;
        Integer extentLevel = extent.getLevel();
        ILayerLevel layerLevel = (ILayerLevel)this.layer.getLevelMap().get(extentLevel);
        if (layerLevel == null) {
            if (extentLevel < this.layer.getBeginLevel()) {
                layerLevel = (ILayerLevel)this.layer.getLevelMap().get(this.filterLevel);
                if (layerLevel == null) {
                    layerLevel = (ILayerLevel)this.layer.getLevelMap().get(this.layer.getBeginLevel());
                }
            } else {
                return null;
            }
        }
        if (isAllLevelNotCut = this.isAllLevelNotCut()) {
            return null;
        }
        if (this.isCancel()) {
            return null;
        }
        int bufferSize = ((DataServiceBean)layerLevel.getDataSet().getDataService().getBean()).getAdvancedOptions().getBufferSize();
        extent.setBufferSize(Integer.valueOf(bufferSize));
        String wkt = extent.getExtentByBuffer(bufferSize).getWkt();
        IDataSet dbDataSet = layerLevel.getDataSet();
        ITable table = dbDataSet.getDataService().getTable();
        QueryFilter filter = this.buildFilter(dbDataSet, table, wkt, extent, extraSqlFilter, start, limit);
        IMapDAO persistEntityDao = table.mapDao();
        List i = null;
        if (dbDataSet.getDataSource().getDataSourceType() == Constants.DATA_SOURCE_TYPE.postgreSQL || dbDataSet.getDataSource().getDataSourceType() == Constants.DATA_SOURCE_TYPE.kingbase) {
            dataSource = (DbDataSource)table.getDataSource();
            Transactions.useSingleConnectionInThread((DbDataSource)dataSource);
            dataSource.genericDao().doExecuteSql("set enable_seqscan = false", null, null);
        }
        try {
            i = persistEntityDao.queryArray(filter, Integer.valueOf(1000));
        }
        catch (Exception e) {
            this.logger.error("\u74e6\u7247\u683c\u7f51\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (dbDataSet.getDataSource().getDataSourceType() == Constants.DATA_SOURCE_TYPE.postgreSQL || dbDataSet.getDataSource().getDataSourceType() == Constants.DATA_SOURCE_TYPE.kingbase) {
                dataSource = (DbDataSource)table.getDataSource();
                dataSource.genericDao().doExecuteSql("set enable_seqscan = true", null, null);
                Transactions.connectionInThreadRelease((DbDataSource)dataSource);
            }
        }
        if (i.isEmpty()) {
            return null;
        }
        ArrayList<GridExtent> list = new ArrayList<GridExtent>(1);
        list.add(extent);
        return list;
    }

    private boolean isAllLevelNotCut() {
        Map levelMap = this.layer.getLevelMap();
        int from = this.mainLevel;
        int to = this.mainLevel + this.down;
        for (ILayerLevel layerLevel : levelMap.values()) {
            if (layerLevel.getLevel() < from || layerLevel.getLevel() > to || "1 = 2".equals(layerLevel.getFilterExpression())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setFilterLevel(Integer filterLevel) {
        this.filterLevel = filterLevel;
    }

    @Override
    public Integer getFilterLevel() {
        return this.filterLevel;
    }

    @Override
    public boolean isSameFilter() {
        return this.isSameFilter;
    }
}

