/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cache;

import com.geoway.vtile.diagnose.GlobalMetrics;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.geofeature.GeoFeature;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoFeatureLruCache<T> {
    protected int size;
    protected ConcurrentMap<String, GeoFeature<T>> cache = null;
    protected Logger logger = LoggerFactory.getLogger(GeoFeatureLruCache.class);

    public GeoFeatureLruCache(int size) {
        this.size = size;
        this.cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity((long)this.size).listener((key, geoFeature) -> {
            this.logger.debug(key + " \u88ab\u6e05\u9664");
            if (geoFeature.getGeo() instanceof GeoBuffer) {
                ((GeoBuffer)geoFeature.getGeo()).destroy();
            }
        }).build();
    }

    public void put(String key, GeoFeature feature) {
        this.cache.put(key, feature);
        if (Log4jUtil.isDiagnoseEnable()) {
            GlobalMetrics.Current.getnFeatureCacheSize().set(this.cache.size());
        }
    }

    public GeoFeature get(String key) {
        GeoFeature feature = (GeoFeature)this.cache.get(key);
        if (feature == null) {
            return null;
        }
        return feature;
    }

    public void clear() {
        this.cache.clear();
        if (Log4jUtil.isDiagnoseEnable()) {
            GlobalMetrics.Current.getnFeatureCacheSize().set(this.cache.size());
        }
    }
}

