/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.tools;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferPool {
    private Logger log = LoggerFactory.getLogger(BufferPool.class);
    private static BufferPool bufferPoolObject;
    private static int minSize;
    private static int maxSize;
    private static int smallBufferSize;
    private static volatile Integer used;
    private ConcurrentLinkedQueue<ByteBuffer> pool;

    private BufferPool(int minSize, int maxSize, int bufferSize) {
        BufferPool.maxSize = maxSize;
        BufferPool.minSize = minSize;
        smallBufferSize = bufferSize;
        this.pool = new ConcurrentLinkedQueue();
        for (int i = 0; i < minSize; ++i) {
            this.pool.offer(ByteBuffer.allocateDirect(bufferSize));
        }
    }

    public static BufferPool getInstance() {
        return bufferPoolObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferPool getInstance(int minSize, int maxSize, int bufferSize) {
        if (bufferPoolObject != null) return bufferPoolObject;
        Class<BufferPool> clazz = BufferPool.class;
        synchronized (BufferPool.class) {
            if (bufferPoolObject != null) return bufferPoolObject;
            bufferPoolObject = new BufferPool(minSize, maxSize, bufferSize);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return bufferPoolObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getBuffer() {
        Serializable serializable;
        ByteBuffer buffer = this.pool.poll();
        if (buffer == null) {
            if (used < maxSize && used >= minSize) {
                if (this.pool.isEmpty()) {
                    buffer = ByteBuffer.allocateDirect(smallBufferSize);
                }
            } else {
                this.log.info("\u5bf9\u8c61\u6c60\u6ca1\u6709\u53ef\u7528\u5bf9\u8c61: \u6700\u5927\uff1a" + maxSize + "; \u5df2\u4f7f\u7528" + used);
                this.log.info("\u7ebf\u7a0b\u963b\u585e......");
                while (this.pool.isEmpty()) {
                }
                serializable = this.pool;
                synchronized (serializable) {
                    buffer = this.pool.poll();
                }
            }
        }
        serializable = used;
        synchronized (serializable) {
            Integer n = used;
            Integer n2 = used = Integer.valueOf(used + 1);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBuffer(ByteBuffer buffer) {
        buffer.clear();
        this.pool.offer(buffer);
        Integer n = used;
        synchronized (n) {
            Integer n2 = used;
            Integer n3 = used = Integer.valueOf(used - 1);
        }
    }

    public synchronized void clean() {
        for (int i = this.pool.size(); i > minSize; --i) {
            this.pool.poll().clear();
        }
        used = 0;
    }

    public static int getMinSize() {
        return minSize;
    }

    public static int getMaxSize() {
        return maxSize;
    }

    static {
        minSize = 50;
        maxSize = 100;
        used = 0;
    }
}

