/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.writer;

import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.commons.util.IntBuilder;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.transform.tools.DynamicByteBuffer;
import com.geoway.vtile.transform.tools.PropertyUtil;
import com.geoway.vtile.transform.tools.varint.DecodingVarint;
import com.geoway.vtile.transform.tools.varint.EncodingVarint;
import com.geoway.vtile.transform.writer.Writer;
import com.github.davidmoten.rtree.InternalStructure;
import com.github.davidmoten.rtree.RTree;
import com.github.davidmoten.rtree.Serializer;
import com.github.davidmoten.rtree.Serializers;
import com.github.davidmoten.rtree.geometry.Geometries;
import com.github.davidmoten.rtree.geometry.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public class ConcurrentFeatureDoubleWriter
implements Writer {
    Logger logger = LoggerFactory.getLogger(ConcurrentFeatureDoubleWriter.class);
    private Map<Long, StringBuilder> featureMap;
    private Map<Long, DynamicByteBuffer> coordinatesBufferMap;
    private Map<Long, List<Rectangle>> rectanglesMap;
    private Map<Long, IntBuilder> offsetIndexMap;
    private Map<Long, Integer> offsetMap;
    private double area;
    private int unModifiedNum = 0;
    private int lastSize = 0;
    private int unFlushNum = 0;
    private Constants.GEO_TYPE geoType;
    private static byte[] headerArr;
    private static Properties pro;
    private static final String featureSpace = "#@";
    private static final String encoding = "utf-8";
    public static final int BBOX_LENGTH = 32;

    public ConcurrentFeatureDoubleWriter() {
        this.coordinatesBufferMap = new ConcurrentHashMap<Long, DynamicByteBuffer>(1);
        this.featureMap = new ConcurrentHashMap<Long, StringBuilder>(1);
        this.offsetIndexMap = new ConcurrentHashMap<Long, IntBuilder>(1);
        this.offsetMap = new ConcurrentHashMap<Long, Integer>(1);
        this.rectanglesMap = new ConcurrentHashMap<Long, List<Rectangle>>(1);
    }

    private ConcurrentFeatureDoubleWriter(ConcurrentFeatureDoubleWriter writer) {
        this.coordinatesBufferMap = new ConcurrentHashMap<Long, DynamicByteBuffer>(writer.coordinatesBufferMap);
        this.featureMap = new ConcurrentHashMap<Long, StringBuilder>(writer.featureMap);
        this.offsetIndexMap = new ConcurrentHashMap<Long, IntBuilder>(writer.offsetIndexMap);
        this.offsetMap = new ConcurrentHashMap<Long, Integer>(writer.offsetMap);
        this.rectanglesMap = new ConcurrentHashMap<Long, List<Rectangle>>(writer.rectanglesMap);
        this.geoType = writer.geoType;
    }

    @Override
    public void beginFeature() {
    }

    public void addGeometry(Geometry geometry) {
        WKBWriter wkbWriter = new WKBWriter();
        byte[] wkb = wkbWriter.write(geometry);
        DynamicByteBuffer coordinatesBuffer = this.getCoordinatesBuffer();
        Envelope envelope = geometry.getEnvelopeInternal();
        coordinatesBuffer.putDouble(envelope.getMinX());
        coordinatesBuffer.putDouble(envelope.getMinY());
        coordinatesBuffer.putDouble(envelope.getMaxX());
        coordinatesBuffer.putDouble(envelope.getMaxY());
        coordinatesBuffer.put(wkb);
        Integer offset = this.getOffset();
        IntBuilder offsetIndex = this.getOffsetIndex();
        offsetIndex.add(offset.intValue());
        offsetIndex.add(wkb.length + 32);
        this.setOffset(coordinatesBuffer.position());
        List<Rectangle> rectangles = this.getRectangles();
        rectangles.add(Geometries.rectangle((double)envelope.getMinX(), (double)envelope.getMinY(), (double)envelope.getMaxX(), (double)envelope.getMaxY()));
    }

    public StringBuilder createPropertysPart(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject, Object ... otherProperties) {
        this.geoType = geoType;
        StringBuilder sb = new StringBuilder();
        this.setPropertys(sb, propertyFields, propertyObject, otherProperties);
        return sb;
    }

    @Override
    public void setPropertysPart(Object part) {
        StringBuilder feature = this.getFeature();
        feature.append(part).append(featureSpace);
    }

    public byte[] getData() {
        ConcurrentFeatureDoubleWriter.headerArr[0] = this.isExceed() ? (byte)1 : 0;
        try {
            if (this.featureMap.size() == 0) {
                return new byte[0];
            }
            Iterator<Long> threadIterator = this.featureMap.keySet().iterator();
            Long firstThread = threadIterator.next();
            StringBuilder feature = this.featureMap.get(firstThread);
            IntBuilder offsetIndex = this.offsetIndexMap.get(firstThread);
            Integer offset = this.offsetMap.get(firstThread);
            int coordinatesBytesNum = this.coordinatesBufferMap.values().stream().mapToInt(coordinatesBuffer -> coordinatesBuffer.position()).sum();
            while (threadIterator.hasNext()) {
                Long threadId = threadIterator.next();
                StringBuilder nextFeature = this.featureMap.get(threadId);
                feature.append((CharSequence)nextFeature);
                IntBuilder nextOffsetIndex = this.offsetIndexMap.get(threadId);
                Integer nextOffset = this.offsetMap.get(threadId);
                int offsetSize = nextOffsetIndex.size() / 2;
                for (int i = 0; i < offsetSize; ++i) {
                    offsetIndex.add(nextOffsetIndex.get(i * 2) + offset);
                    offsetIndex.add(nextOffsetIndex.get(i * 2 + 1));
                }
                offset = offset + nextOffset;
            }
            if (feature.length() == 0) {
                return null;
            }
            ByteBuffer offsetIndexBuffer = ByteBuffer.allocate(offsetIndex.size() * 4);
            for (int i = 0; i < offsetIndex.size(); ++i) {
                offsetIndexBuffer.put(EncodingVarint.int2Variant(offsetIndex.get(i)));
            }
            offsetIndexBuffer.flip();
            threadIterator = this.featureMap.keySet().iterator();
            int index = 0;
            RTree tree = RTree.create();
            while (threadIterator.hasNext()) {
                Long threadId = threadIterator.next();
                List<Rectangle> rectangles = this.rectanglesMap.get(threadId);
                for (Rectangle rectangle : rectangles) {
                    tree = tree.add((Object)index, (com.github.davidmoten.rtree.geometry.Geometry)rectangle);
                    ++index;
                }
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            Serializer serializer = Serializers.flatBuffers().javaIo();
            serializer.write(tree, (OutputStream)os);
            byte[] rtreeContent = os.toByteArray();
            byte[] snappyBytes = Snappy.compress((byte[])feature.toString().getBytes(encoding));
            int featureLength = snappyBytes.length;
            String headPro = "gType:" + this.geoType.name();
            byte[] headProByte = Snappy.compress((byte[])headPro.getBytes(encoding));
            int indexLength = offsetIndexBuffer.limit();
            int total = 16 + headerArr.length + headProByte.length + snappyBytes.length + offsetIndexBuffer.limit() + rtreeContent.length + coordinatesBytesNum;
            ByteBuffer layerBuffer = ByteBuffer.allocate(total);
            layerBuffer.put(headerArr);
            layerBuffer.putInt(headProByte.length);
            layerBuffer.put(headProByte);
            layerBuffer.putInt(featureLength);
            layerBuffer.put(snappyBytes);
            layerBuffer.putInt(indexLength);
            layerBuffer.put(offsetIndexBuffer);
            layerBuffer.putInt(rtreeContent.length);
            layerBuffer.put(rtreeContent);
            for (Long threadId : this.featureMap.keySet()) {
                DynamicByteBuffer coordinatesBuffer2 = this.coordinatesBufferMap.get(threadId);
                coordinatesBuffer2.flip();
                layerBuffer.put(coordinatesBuffer2.getByteArray());
            }
            layerBuffer.flip();
            return layerBuffer.array();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public byte[] getAndMerge(ByteBuffer byteBuffer) {
        if (this.featureMap.size() == 0) {
            return byteBuffer.array();
        }
        ByteBuffer layerBuffer = null;
        try {
            int i;
            byteBuffer.position(headerArr.length);
            int typeLength = byteBuffer.getInt();
            byte[] typeBytes = new byte[typeLength];
            byteBuffer.get(typeBytes);
            int featureLength = byteBuffer.getInt();
            byte[] snappyBytes = new byte[featureLength];
            byteBuffer.get(snappyBytes);
            byte[] featureBytes = Snappy.uncompress((byte[])snappyBytes);
            int indexLength = byteBuffer.getInt();
            byte[] indexBytes = new byte[indexLength];
            byteBuffer.get(indexBytes);
            int rtreeLength = byteBuffer.getInt();
            byte[] rtreeBytes = new byte[rtreeLength];
            byteBuffer.get(rtreeBytes);
            int[] array = DecodingVarint.Varint2IntArray(indexBytes);
            int featureNums = array.length / 2;
            if (featureNums == 0) {
                return this.getData();
            }
            Serializer serializer = Serializers.flatBuffers().javaIo();
            ByteArrayInputStream bin = new ByteArrayInputStream(rtreeBytes);
            RTree tree = serializer.read((InputStream)bin, (long)rtreeLength, InternalStructure.DEFAULT);
            ByteBuffer geoBuffer = byteBuffer.slice();
            Iterator<Long> threadIterator = this.featureMap.keySet().iterator();
            StringBuilder feature = new StringBuilder();
            int oldOffsetSize = array.length;
            int offsetIndexSize = this.offsetIndexMap.values().stream().mapToInt(offsetIndex -> offsetIndex.size()).sum();
            IntBuilder offsetIndex2 = new IntBuilder(offsetIndexSize);
            Integer offset = geoBuffer.limit();
            while (threadIterator.hasNext()) {
                Long threadId = threadIterator.next();
                StringBuilder nextFeature = this.featureMap.get(threadId);
                feature.append((CharSequence)nextFeature);
                IntBuilder nextOffsetIndex = this.offsetIndexMap.get(threadId);
                Integer nextOffset = this.offsetMap.get(threadId);
                int offsetSize = nextOffsetIndex.size() / 2;
                for (int i2 = 0; i2 < offsetSize; ++i2) {
                    offsetIndex2.add(nextOffsetIndex.get(i2 * 2) + offset);
                    offsetIndex2.add(nextOffsetIndex.get(i2 * 2 + 1));
                }
                offset = offset + nextOffset;
            }
            if (feature.length() == 0) {
                return null;
            }
            ByteBuffer offsetIndexBuffer = ByteBuffer.allocate((array.length + offsetIndex2.size()) * 4);
            for (i = 0; i < oldOffsetSize; ++i) {
                offsetIndexBuffer.put(EncodingVarint.int2Variant(array[i]));
            }
            for (i = 0; i < offsetIndex2.size(); ++i) {
                offsetIndexBuffer.put(EncodingVarint.int2Variant(offsetIndex2.get(i)));
            }
            offsetIndexBuffer.flip();
            threadIterator = this.featureMap.keySet().iterator();
            int index = tree.size();
            while (threadIterator.hasNext()) {
                Long threadId = threadIterator.next();
                List<Rectangle> rectangles = this.rectanglesMap.get(threadId);
                for (Rectangle rectangle : rectangles) {
                    tree = tree.add((Object)index, (com.github.davidmoten.rtree.geometry.Geometry)rectangle);
                    ++index;
                }
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            serializer.write(tree, (OutputStream)os);
            byte[] rtreeContent = os.toByteArray();
            byte[] newFeatureBytes = feature.toString().getBytes(encoding);
            ByteBuffer concatFeatureBuffer = ByteBuffer.allocate(featureBytes.length + newFeatureBytes.length);
            concatFeatureBuffer.put(featureBytes);
            concatFeatureBuffer.put(newFeatureBytes);
            byte[] concatSnappyBytes = Snappy.compress((byte[])concatFeatureBuffer.array());
            int allFeatureLength = concatSnappyBytes.length;
            String headPro = "gType:" + this.geoType.name();
            byte[] headProByte = Snappy.compress((byte[])headPro.getBytes(encoding));
            indexLength = offsetIndexBuffer.limit();
            int coordinatesBytesNum = geoBuffer.limit() + this.coordinatesBufferMap.values().stream().mapToInt(coordinatesBuffer -> coordinatesBuffer.limit()).sum();
            int total = 16 + headerArr.length + headProByte.length + allFeatureLength + offsetIndexBuffer.limit() + rtreeContent.length + coordinatesBytesNum;
            layerBuffer = ByteBuffer.allocate(total);
            layerBuffer.put(headerArr);
            layerBuffer.putInt(headProByte.length);
            layerBuffer.put(headProByte);
            layerBuffer.putInt(allFeatureLength);
            layerBuffer.put(concatSnappyBytes);
            layerBuffer.putInt(indexLength);
            layerBuffer.put(offsetIndexBuffer);
            layerBuffer.putInt(rtreeContent.length);
            layerBuffer.put(rtreeContent);
            layerBuffer.put(geoBuffer);
            for (Long threadId : this.featureMap.keySet()) {
                DynamicByteBuffer coordinatesBuffer2 = this.coordinatesBufferMap.get(threadId);
                coordinatesBuffer2.flip();
                layerBuffer.put(coordinatesBuffer2.getByteArray());
            }
            layerBuffer.flip();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return layerBuffer.array();
    }

    @Override
    public Integer getAccuracy() {
        return null;
    }

    @Override
    public void setGeoType(Constants.GEO_TYPE geoType) {
        this.geoType = geoType;
    }

    @Override
    public Constants.GEO_TYPE getGeoType() {
        return this.geoType;
    }

    protected void setPropertys(StringBuilder sbproperty, String[] propertyFields, Object[] propertyObject, Object ... otherProperties) {
        int i;
        if (propertyObject == null || propertyObject.length == 0) {
            return;
        }
        Object o = null;
        String value = null;
        for (i = 0; i < propertyObject.length; ++i) {
            o = propertyObject[i];
            value = o != null ? (o instanceof Date ? ((Date)o).getTime() + "" : o.toString()) : null;
            if (value == null || value.length() == 0) {
                sbproperty.append(featureSpace);
                continue;
            }
            sbproperty.append(featureSpace).append(value);
        }
        for (i = 0; i < otherProperties.length; ++i) {
            o = otherProperties[i];
            value = o != null ? o.toString() : null;
            if (value == null || value.length() == 0) {
                sbproperty.append(featureSpace);
                continue;
            }
            sbproperty.append(featureSpace).append(value);
        }
        sbproperty.delete(0, 2);
    }

    public StringBuilder getFeature() {
        Long threadId = Thread.currentThread().getId();
        StringBuilder feature = this.featureMap.get(threadId);
        if (feature == null) {
            feature = new StringBuilder();
            this.featureMap.put(threadId, feature);
        }
        return feature;
    }

    public DynamicByteBuffer getCoordinatesBuffer() {
        Long threadId = Thread.currentThread().getId();
        DynamicByteBuffer coordinatesBuffer = this.coordinatesBufferMap.get(threadId);
        if (coordinatesBuffer == null) {
            coordinatesBuffer = new DynamicByteBuffer();
            this.coordinatesBufferMap.put(threadId, coordinatesBuffer);
        }
        return coordinatesBuffer;
    }

    public List<Rectangle> getRectangles() {
        Long threadId = Thread.currentThread().getId();
        List<Rectangle> rectList = this.rectanglesMap.get(threadId);
        if (rectList == null) {
            rectList = new ArrayList<Rectangle>();
            this.rectanglesMap.put(threadId, rectList);
        }
        return rectList;
    }

    public IntBuilder getOffsetIndex() {
        Long threadId = Thread.currentThread().getId();
        IntBuilder offsetIndex = this.offsetIndexMap.get(threadId);
        if (offsetIndex == null) {
            offsetIndex = new IntBuilder();
            this.offsetIndexMap.put(threadId, offsetIndex);
        }
        return offsetIndex;
    }

    public Integer getOffset() {
        Long threadId = Thread.currentThread().getId();
        Integer offset = this.offsetMap.get(threadId);
        if (offset == null) {
            offset = 0;
            this.offsetMap.put(threadId, offset);
        }
        return offset;
    }

    public void setOffset(Integer offset) {
        Long threadId = Thread.currentThread().getId();
        this.offsetMap.put(threadId, offset);
    }

    private boolean isExceed() {
        return false;
    }

    @Override
    public void setExceed(boolean exceed) {
    }

    public int getCoordinatesSize() {
        return this.coordinatesBufferMap.values().stream().mapToInt(buffer -> buffer.position()).sum();
    }

    public void clear() {
        this.coordinatesBufferMap.clear();
        this.featureMap.clear();
        this.offsetIndexMap.clear();
        this.offsetMap.clear();
        this.rectanglesMap.clear();
    }

    @Override
    public void beginTile() {
    }

    @Override
    public void endTile() {
    }

    @Override
    public void featureNext() {
    }

    @Override
    public void beginServerTile() {
    }

    @Override
    public void endServerTile() {
    }

    @Override
    public void beginPath() {
    }

    @Override
    public void endPath() {
    }

    @Override
    public void addFull(Boolean clockwise) {
    }

    @Override
    public <T> T createPropertysPart(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject) {
        return null;
    }

    @Override
    public void addLayer(String id, byte[] bytes) {
    }

    @Override
    public void addCoordinates(double x, double y, double times) {
    }

    @Override
    public void addCoordinates(DoubleBuilder points, double times) {
    }

    @Override
    public void addCoordinates(double[] points, double times) {
    }

    @Override
    public void endFeature() {
    }

    @Override
    public void setPropertys(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject) {
    }

    public double getArea() {
        return this.area;
    }

    public void setArea(double area) {
        this.area = area;
    }

    public int getUnModifiedNum() {
        return this.unModifiedNum;
    }

    public void setUnModifiedNum(int unModifiedNum) {
        this.unModifiedNum = unModifiedNum;
    }

    public int getLastSize() {
        return this.lastSize;
    }

    public void setLastSize(int lastSize) {
        this.lastSize = lastSize;
    }

    public int getUnFlushNum() {
        return this.unFlushNum;
    }

    public void setUnFlushNum(int unFlushNum) {
        this.unFlushNum = unFlushNum;
    }

    public void substractArea(double subArea) {
        this.area -= subArea;
    }

    public ConcurrentFeatureDoubleWriter clone() {
        return new ConcurrentFeatureDoubleWriter(this);
    }

    static {
        pro = PropertyUtil.readProperties("conf/varint.properties");
        int headerSize = Integer.valueOf(pro.getProperty("headerSize"));
        headerArr = new byte[headerSize];
        Random random = new Random();
        for (int i = 0; i < headerSize; ++i) {
            ConcurrentFeatureDoubleWriter.headerArr[i] = Byte.valueOf(random.nextInt(70) + 1 + "");
        }
    }
}

