/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.dataholder.bucket;

import com.alibaba.fastjson.annotation.JSONField;
import com.geoway.vtile.transform.dataholder.IMetricsHolder;
import io.protostuff.Schema;
import io.protostuff.Tag;
import io.protostuff.runtime.RuntimeSchema;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BucketHolder {
    public static final Schema<BucketHolder> schema = RuntimeSchema.getSchema(BucketHolder.class);
    @Tag(value=3)
    Map<String, BucketHolder> buckets;
    @Tag(value=1)
    String name;
    @Tag(value=2)
    double number = 0.0;

    BucketHolder() {
    }

    public BucketHolder(String name, double value) {
        this.number = value;
        this.name = name;
        this.buckets = new HashMap<String, BucketHolder>();
    }

    public BucketHolder(String name, double value, boolean isRoot) {
        this(name, value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, BucketHolder> getBuckets() {
        return this.buckets;
    }

    public void setBuckets(Map<String, BucketHolder> buckets) {
        this.buckets = buckets;
    }

    public Double getNumber() {
        return this.number;
    }

    public void setNumber(double number) {
        this.number = number;
    }

    @JSONField(serialize=false)
    public Collection<BucketHolder> getBucketsList() {
        return this.buckets.values();
    }

    public BucketHolder getBucket(String name) {
        return this.buckets.get(name);
    }

    public void addBucket(BucketHolder bucket) {
        this.buckets.put(bucket.getName(), bucket);
    }

    @JSONField(name="number")
    public void add(double number) {
        this.number += number;
    }

    public void accumulate(double number) {
    }

    public static BucketHolder mergeBucketsList(List<BucketHolder> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        BucketHolder root = list.get(0);
        BucketHolder item = null;
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            item = list.get(i);
            BucketHolder.mergeBucket(root, item);
        }
        return root;
    }

    public static void mergeBucket(BucketHolder target, BucketHolder source) {
        target.add(source.getNumber());
        Map<String, BucketHolder> sourceBucketsMap = source.getBuckets();
        if (sourceBucketsMap == null) {
            return;
        }
        Set<Map.Entry<String, BucketHolder>> sourceKeys = sourceBucketsMap.entrySet();
        for (Map.Entry<String, BucketHolder> sourceEntry : sourceKeys) {
            BucketHolder targetBucket = target.getBucket(sourceEntry.getKey());
            if (targetBucket == null) {
                target.addBucket(sourceEntry.getValue());
                continue;
            }
            BucketHolder.mergeBucket(targetBucket, sourceEntry.getValue());
        }
    }

    public static BucketHolder createBucket(IMetricsHolder<Object[]> source) {
        BucketHolder root;
        Object[] properties = source.getProperties();
        BucketHolder holder = root = new BucketHolder(null, source.getMetrics(), true);
        for (int i = 0; i < properties.length; ++i) {
            String obj = properties[i].toString();
            BucketHolder next = new BucketHolder(obj, source.getMetrics());
            holder.addBucket(next);
            holder = next;
        }
        return root;
    }

    public static void mergeBuckets(BucketHolder holder, IMetricsHolder<Object[]> source) {
        Object[] properties = source.getProperties();
        Map<String, BucketHolder> bucketsMap = holder.getBuckets();
        holder.add(source.getMetrics());
        for (int i = 0; i < properties.length; ++i) {
            String obj = properties[i].toString();
            if (bucketsMap.get(obj) != null) {
                bucketsMap.get(obj).add(source.getMetrics());
            } else {
                bucketsMap.put(obj, new BucketHolder(obj, source.getMetrics()));
            }
            bucketsMap = bucketsMap.get(obj).getBuckets();
        }
    }
}

