/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.writer;

import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.commons.util.IntBuilder;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.transform.tools.DynamicByteBuffer;
import com.geoway.vtile.transform.tools.PropertyUtil;
import com.geoway.vtile.transform.tools.varint.DecodingVarint;
import com.geoway.vtile.transform.tools.varint.EncodingVarint;
import com.geoway.vtile.transform.writer.Writer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public class ConcurrentVarintWriter
implements Writer {
    Logger logger = LoggerFactory.getLogger(ConcurrentVarintWriter.class);
    protected Integer accuracy = 1;
    private Map<Long, StringBuilder> featureMap;
    private Map<Long, DynamicByteBuffer> coordinatesBufferMap = new ConcurrentHashMap<Long, DynamicByteBuffer>(1);
    private Map<Long, IntBuilder> offsetIndexMap;
    private Map<Long, Integer> offsetMap;
    private Map<Long, Boolean> isNullMap;
    private Constants.GEO_TYPE geoType;
    private static byte[] spacingBytes;
    private static byte[] headerArr;
    private static Properties pro;
    private static int precision;
    private Boolean exceed = false;
    private int unModifiedNum = 0;
    private int lastSize = 0;
    private int unFlushNum = 0;
    private static String featureSpace;
    private static String encoding;

    public ConcurrentVarintWriter() {
        this.featureMap = new ConcurrentHashMap<Long, StringBuilder>(1);
        this.offsetIndexMap = new ConcurrentHashMap<Long, IntBuilder>(1);
        this.offsetMap = new ConcurrentHashMap<Long, Integer>(1);
        this.isNullMap = new ConcurrentHashMap<Long, Boolean>(1);
    }

    @Override
    public void beginTile() {
    }

    @Override
    public void endTile() {
    }

    @Override
    public void featureNext() {
    }

    @Override
    public void beginFeature() {
        this.setNull(true);
    }

    @Override
    public void endFeature() {
        if (this.isNull().booleanValue()) {
            return;
        }
        IntBuilder offsetIndex = this.getOffsetIndex();
        Integer offset = this.getOffset();
        DynamicByteBuffer coordinatesBuffer = this.getCoordinatesBuffer();
        int length = coordinatesBuffer.position() - offset;
        if (length == 0) {
            return;
        }
        offsetIndex.add(offset.intValue());
        offsetIndex.add(length);
        this.setOffset(coordinatesBuffer.position());
    }

    @Override
    public void setPropertys(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject) {
        this.geoType = geoType;
    }

    @Override
    public void beginPath() {
    }

    @Override
    public void endPath() {
    }

    @Override
    public void addFull(Boolean clockwise) {
    }

    public StringBuilder createPropertysPart(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject) {
        this.geoType = geoType;
        StringBuilder sb = new StringBuilder();
        this.setPropertys(sb, propertyFields, propertyObject);
        return sb;
    }

    @Override
    public void setPropertysPart(Object part) {
        if (this.isNull().booleanValue()) {
            return;
        }
        this.getFeature().append(part).append(featureSpace);
    }

    @Override
    public void addCoordinates(DoubleBuilder points, double times) {
        int size = points.size();
        if (size == 0) {
            return;
        }
        this.setNull(false);
        DynamicByteBuffer coordinatesBuffer = this.getCoordinatesBuffer();
        Integer offset = this.getOffset();
        if (coordinatesBuffer.position() != offset.intValue()) {
            coordinatesBuffer.put(spacingBytes);
        }
        int oldX = 0;
        int oldY = 0;
        for (int i = 0; i < size / 2; ++i) {
            int x = (int)(points.get(i * 2) * (double)precision);
            int y = (int)(points.get(i * 2 + 1) * (double)precision);
            coordinatesBuffer.put(EncodingVarint.int2Variant(x - oldX));
            coordinatesBuffer.put(EncodingVarint.int2Variant(y - oldY));
            oldX = x;
            oldY = y;
        }
        coordinatesBuffer.put(spacingBytes);
    }

    @Override
    public void addCoordinates(double[] points, double times) {
        int size = points.length;
        if (size == 0) {
            return;
        }
        this.setNull(false);
        DynamicByteBuffer coordinatesBuffer = this.getCoordinatesBuffer();
        Integer offset = this.getOffset();
        if (coordinatesBuffer.position() != offset.intValue()) {
            coordinatesBuffer.put(spacingBytes);
        }
        int oldX = 0;
        int oldY = 0;
        for (int i = 0; i < size / 2; ++i) {
            int x = (int)(points[i * 2] * (double)precision);
            int y = (int)(points[i * 2 + 1] * (double)precision);
            coordinatesBuffer.put(EncodingVarint.int2Variant(x - oldX));
            coordinatesBuffer.put(EncodingVarint.int2Variant(y - oldY));
            oldX = x;
            oldY = y;
        }
        coordinatesBuffer.put(spacingBytes);
    }

    @Override
    public void addCoordinates(double x, double y, double times) {
        this.setNull(false);
        DynamicByteBuffer coordinatesBuffer = this.getCoordinatesBuffer();
        Integer offset = this.getOffset();
        if (coordinatesBuffer.position() != offset.intValue()) {
            coordinatesBuffer.put(spacingBytes);
        }
        int xi = (int)(x * (double)precision);
        int yi = (int)(y * (double)precision);
        coordinatesBuffer.put(EncodingVarint.int2Variant(xi));
        coordinatesBuffer.put(EncodingVarint.int2Variant(yi));
        coordinatesBuffer.put(spacingBytes);
    }

    public byte[] getData() {
        if (this.featureMap.isEmpty()) {
            return null;
        }
        ConcurrentVarintWriter.headerArr[0] = this.isExceed() ? (byte)1 : 0;
        try {
            Iterator<Long> threadIterator = this.featureMap.keySet().iterator();
            Long firstThread = threadIterator.next();
            StringBuilder feature = this.featureMap.get(firstThread);
            IntBuilder offsetIndex = this.offsetIndexMap.get(firstThread);
            Integer offset = this.offsetMap.get(firstThread);
            int coordinatesBytesNum = this.coordinatesBufferMap.values().stream().mapToInt(coordinatesBuffer -> coordinatesBuffer.position()).sum();
            while (threadIterator.hasNext()) {
                Long threadId = threadIterator.next();
                StringBuilder nextFeature = this.featureMap.get(threadId);
                feature.append((CharSequence)nextFeature);
                IntBuilder nextOffsetIndex = this.offsetIndexMap.get(threadId);
                Integer nextOffset = this.offsetMap.get(threadId);
                int offsetSize = nextOffsetIndex.size() / 2;
                for (int i = 0; i < offsetSize; ++i) {
                    offsetIndex.add(nextOffsetIndex.get(i * 2) + offset);
                    offsetIndex.add(nextOffsetIndex.get(i * 2 + 1));
                }
                offset = offset + nextOffset;
            }
            if (feature.length() == 0) {
                return null;
            }
            feature.substring(0, feature.length() - featureSpace.length());
            ByteBuffer offsetIndexBuffer = ByteBuffer.allocate(offsetIndex.size() * 4);
            for (int i = 0; i < offsetIndex.size(); ++i) {
                offsetIndexBuffer.put(EncodingVarint.int2Variant(offsetIndex.get(i)));
            }
            offsetIndexBuffer.flip();
            byte[] snappyBytes = Snappy.compress((byte[])feature.toString().getBytes(encoding));
            int featureLength = snappyBytes.length;
            String headPro = "gType:" + this.geoType.name();
            byte[] headProByte = Snappy.compress((byte[])headPro.getBytes(encoding));
            int indexLength = offsetIndexBuffer.limit();
            int total = 12 + headerArr.length + headProByte.length + snappyBytes.length + offsetIndexBuffer.limit() + coordinatesBytesNum;
            ByteBuffer layerBuffer = ByteBuffer.allocate(total);
            layerBuffer.put(headerArr);
            layerBuffer.putInt(headProByte.length);
            layerBuffer.put(headProByte);
            layerBuffer.putInt(featureLength);
            layerBuffer.put(snappyBytes);
            layerBuffer.putInt(indexLength);
            layerBuffer.put(offsetIndexBuffer);
            for (Long threadId : this.featureMap.keySet()) {
                DynamicByteBuffer coordinatesBuffer2 = this.coordinatesBufferMap.get(threadId);
                coordinatesBuffer2.flip();
                layerBuffer.put(coordinatesBuffer2.getByteArray());
            }
            layerBuffer.flip();
            return layerBuffer.array();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getAndMerge(ByteBuffer byteBuffer) {
        if (this.featureMap.size() == 0) {
            return byteBuffer.array();
        }
        ByteBuffer layerBuffer = null;
        try {
            int i;
            byteBuffer.position(headerArr.length);
            int typeLength = byteBuffer.getInt();
            byte[] typeBytes = new byte[typeLength];
            byteBuffer.get(typeBytes);
            int featureLength = byteBuffer.getInt();
            byte[] snappyBytes = new byte[featureLength];
            byteBuffer.get(snappyBytes);
            byte[] featureBytes = Snappy.uncompress((byte[])snappyBytes);
            int indexLength = byteBuffer.getInt();
            byte[] indexBytes = new byte[indexLength];
            byteBuffer.get(indexBytes);
            int[] array = DecodingVarint.Varint2IntArray(indexBytes);
            int featureNums = array.length / 2;
            if (featureNums == 0) {
                return this.getData();
            }
            ByteBuffer geoBuffer = byteBuffer.slice();
            Iterator<Long> threadIterator = this.featureMap.keySet().iterator();
            StringBuilder feature = new StringBuilder();
            int oldOffsetSize = array.length;
            int offsetIndexSize = this.offsetIndexMap.values().stream().mapToInt(offsetIndex -> offsetIndex.size()).sum();
            IntBuilder offsetIndex2 = new IntBuilder(offsetIndexSize);
            Integer offset = geoBuffer.limit();
            while (threadIterator.hasNext()) {
                Long threadId = threadIterator.next();
                StringBuilder nextFeature = this.featureMap.get(threadId);
                feature.append((CharSequence)nextFeature);
                IntBuilder nextOffsetIndex = this.offsetIndexMap.get(threadId);
                Integer nextOffset = this.offsetMap.get(threadId);
                int offsetSize = nextOffsetIndex.size() / 2;
                for (int i2 = 0; i2 < offsetSize; ++i2) {
                    offsetIndex2.add(nextOffsetIndex.get(i2 * 2) + offset);
                    offsetIndex2.add(nextOffsetIndex.get(i2 * 2 + 1));
                }
                offset = offset + nextOffset;
            }
            if (feature.length() == 0) {
                return null;
            }
            ByteBuffer offsetIndexBuffer = ByteBuffer.allocate((array.length + offsetIndex2.size()) * 4);
            for (i = 0; i < oldOffsetSize; ++i) {
                offsetIndexBuffer.put(EncodingVarint.int2Variant(array[i]));
            }
            for (i = 0; i < offsetIndex2.size(); ++i) {
                offsetIndexBuffer.put(EncodingVarint.int2Variant(offsetIndex2.get(i)));
            }
            offsetIndexBuffer.flip();
            byte[] newFeatureBytes = feature.toString().getBytes(encoding);
            ByteBuffer concatFeatureBuffer = ByteBuffer.allocate(featureBytes.length + newFeatureBytes.length);
            concatFeatureBuffer.put(featureBytes);
            concatFeatureBuffer.put(newFeatureBytes);
            byte[] concatSnappyBytes = Snappy.compress((byte[])concatFeatureBuffer.array());
            int allFeatureLength = concatSnappyBytes.length;
            String headPro = "gType:" + this.geoType.name();
            byte[] headProByte = Snappy.compress((byte[])headPro.getBytes(encoding));
            indexLength = offsetIndexBuffer.limit();
            int coordinatesBytesNum = geoBuffer.limit() + this.coordinatesBufferMap.values().stream().mapToInt(coordinatesBuffer -> coordinatesBuffer.limit()).sum();
            int total = 12 + headerArr.length + headProByte.length + allFeatureLength + offsetIndexBuffer.limit() + coordinatesBytesNum;
            layerBuffer = ByteBuffer.allocate(total);
            layerBuffer.put(headerArr);
            layerBuffer.putInt(headProByte.length);
            layerBuffer.put(headProByte);
            layerBuffer.putInt(allFeatureLength);
            layerBuffer.put(concatSnappyBytes);
            layerBuffer.putInt(indexLength);
            layerBuffer.put(offsetIndexBuffer);
            layerBuffer.put(geoBuffer);
            for (Long threadId : this.featureMap.keySet()) {
                DynamicByteBuffer coordinatesBuffer2 = this.coordinatesBufferMap.get(threadId);
                coordinatesBuffer2.flip();
                layerBuffer.put(coordinatesBuffer2.getByteArray());
            }
            layerBuffer.flip();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return layerBuffer.array();
    }

    protected void setPropertys(StringBuilder sbproperty, String[] propertyFields, Object[] propertyObject) {
        if (propertyFields == null || propertyFields.length == 0) {
            return;
        }
        Object o = null;
        String value = null;
        for (int i = 0; i < propertyObject.length; ++i) {
            o = propertyObject[i];
            value = o != null ? (o instanceof Date ? ((Date)o).getTime() + "" : o.toString()) : null;
            if (value == null || value.length() == 0) {
                sbproperty.append(featureSpace);
                continue;
            }
            sbproperty.append(featureSpace).append(value);
        }
        sbproperty.delete(0, 2);
    }

    public StringBuilder getFeature() {
        Long threadId = Thread.currentThread().getId();
        StringBuilder feature = this.featureMap.get(threadId);
        if (feature == null) {
            feature = new StringBuilder();
            this.featureMap.put(threadId, feature);
        }
        return feature;
    }

    public DynamicByteBuffer getCoordinatesBuffer() {
        Long threadId = Thread.currentThread().getId();
        DynamicByteBuffer coordinatesBuffer = this.coordinatesBufferMap.get(threadId);
        if (coordinatesBuffer == null) {
            coordinatesBuffer = new DynamicByteBuffer();
            this.coordinatesBufferMap.put(threadId, coordinatesBuffer);
        }
        return coordinatesBuffer;
    }

    public IntBuilder getOffsetIndex() {
        Long threadId = Thread.currentThread().getId();
        IntBuilder offsetIndex = this.offsetIndexMap.get(threadId);
        if (offsetIndex == null) {
            offsetIndex = new IntBuilder();
            this.offsetIndexMap.put(threadId, offsetIndex);
        }
        return offsetIndex;
    }

    public Integer getOffset() {
        Long threadId = Thread.currentThread().getId();
        Integer offset = this.offsetMap.get(threadId);
        if (offset == null) {
            offset = 0;
            this.offsetMap.put(threadId, offset);
        }
        return offset;
    }

    public void setOffset(Integer offset) {
        Long threadId = Thread.currentThread().getId();
        this.offsetMap.put(threadId, offset);
    }

    public Boolean isNull() {
        Long threadId = Thread.currentThread().getId();
        return this.isNullMap.get(threadId);
    }

    public void setNull(Boolean isNull) {
        Long threadId = Thread.currentThread().getId();
        this.isNullMap.put(threadId, isNull);
    }

    public void clear() {
        this.coordinatesBufferMap.clear();
        this.featureMap.clear();
        this.offsetIndexMap.clear();
        this.offsetMap.clear();
        this.isNullMap.clear();
    }

    @Override
    public Integer getAccuracy() {
        return this.accuracy;
    }

    @Override
    public void setGeoType(Constants.GEO_TYPE geoType) {
        this.geoType = geoType;
    }

    @Override
    public Constants.GEO_TYPE getGeoType() {
        return this.geoType;
    }

    @Override
    public void beginServerTile() {
    }

    @Override
    public void addLayer(String id, byte[] bytes) {
    }

    @Override
    public void endServerTile() {
    }

    private boolean isExceed() {
        return this.exceed;
    }

    @Override
    public void setExceed(boolean exceed) {
        this.exceed = exceed;
    }

    public int getCoordinatesSize() {
        return this.coordinatesBufferMap.values().stream().mapToInt(buffer -> buffer.position()).sum();
    }

    public int getUnModifiedNum() {
        return this.unModifiedNum;
    }

    public void setUnModifiedNum(int unModifiedNum) {
        this.unModifiedNum = unModifiedNum;
    }

    public int getLastSize() {
        return this.lastSize;
    }

    public void setLastSize(int lastSize) {
        this.lastSize = lastSize;
    }

    public int getUnFlushNum() {
        return this.unFlushNum;
    }

    public void setUnFlushNum(int unFlushNum) {
        this.unFlushNum = unFlushNum;
    }

    static {
        featureSpace = "#@";
        encoding = "utf-8";
        pro = PropertyUtil.readProperties("conf/varint.properties");
        precision = Integer.valueOf(pro.getProperty("precision"));
        String[] spacingArr = pro.getProperty("spacingArr").split(",");
        spacingBytes = new byte[spacingArr.length];
        for (int i = 0; i < spacingArr.length; ++i) {
            ConcurrentVarintWriter.spacingBytes[i] = Byte.valueOf(spacingArr[i]);
        }
        int headerSize = Integer.valueOf(pro.getProperty("headerSize"));
        headerArr = new byte[headerSize];
        Random random = new Random();
        for (int i = 0; i < headerSize; ++i) {
            ConcurrentVarintWriter.headerArr[i] = Byte.valueOf(random.nextInt(70) + 1 + "");
        }
    }
}

