/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.tools;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadBufferPool {
    private Logger log = LoggerFactory.getLogger(ThreadBufferPool.class);
    private static int minSize = 50;
    private static int maxSize = 100;
    private int bufferSize;
    private static volatile int used = 0;
    static ThreadLocal<Map<Integer, ThreadBufferPool>> threadLocalPool = new ThreadLocal();
    private LinkedBlockingQueue<ByteBuffer> pool;

    private ThreadBufferPool(int minSize, int maxSize, int bufferSize) {
        ThreadBufferPool.maxSize = maxSize;
        ThreadBufferPool.minSize = minSize;
        this.bufferSize = bufferSize;
        this.pool = new LinkedBlockingQueue();
        for (int i = 0; i < minSize; ++i) {
            this.pool.offer(ByteBuffer.allocateDirect(bufferSize));
        }
    }

    public static ThreadBufferPool getInstance(int minSize, int maxSize, int bufferSize) {
        ThreadBufferPool pool = null;
        Map<Integer, ThreadBufferPool> bufferPoolMap = threadLocalPool.get();
        if (bufferPoolMap == null) {
            bufferPoolMap = new HashMap<Integer, ThreadBufferPool>(2);
            pool = new ThreadBufferPool(minSize, maxSize, bufferSize);
            bufferPoolMap.put(bufferSize, pool);
            threadLocalPool.set(bufferPoolMap);
            return pool;
        }
        pool = bufferPoolMap.get(bufferSize);
        if (pool == null) {
            pool = new ThreadBufferPool(minSize, maxSize, bufferSize);
        }
        bufferPoolMap.put(bufferSize, pool);
        return pool;
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buffer;
        if (used < minSize) {
            buffer = this.pool.poll();
        } else if (used < maxSize && used >= minSize) {
            buffer = this.pool.isEmpty() ? ByteBuffer.allocateDirect(this.bufferSize) : this.pool.poll();
        } else {
            this.log.info("\u5bf9\u8c61\u6c60\u6ca1\u6709\u53ef\u7528\u5bf9\u8c61: \u6700\u5927\uff1a" + maxSize + "; \u5df2\u4f7f\u7528" + used);
            this.log.info("\u7ebf\u7a0b\u963b\u585e......");
            while (used >= maxSize) {
            }
            buffer = this.pool.poll();
        }
        ++used;
        if (buffer == null) {
            buffer = ByteBuffer.allocateDirect(this.bufferSize);
        }
        return buffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        --used;
        buffer.clear();
        if (this.pool.size() < minSize) {
            this.pool.offer(buffer);
        }
    }

    public void clean() {
        for (int i = this.pool.size(); i > minSize; --i) {
            this.pool.poll().clear();
        }
        used = 0;
    }

    public static int getMinSize() {
        return minSize;
    }

    public static int getMaxSize() {
        return maxSize;
    }

    public int getBlockSize() {
        return this.bufferSize;
    }
}

