/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.bean;

import com.geoway.vtile.spatial.geofeature.GeoFeature;
import com.geoway.vtile.transform.bean.RtreeJtsGeometry;
import com.geoway.vtile.transform.tools.varint.DecodingVarint;
import com.github.davidmoten.rtree.Entry;
import com.github.davidmoten.rtree.InternalStructure;
import com.github.davidmoten.rtree.RTree;
import com.github.davidmoten.rtree.Serializer;
import com.github.davidmoten.rtree.Serializers;
import com.github.davidmoten.rtree.geometry.Geometry;
import com.github.davidmoten.rtree.geometry.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.xerial.snappy.Snappy;
import rx.Observable;
import rx.functions.Func2;

public class FeatureTile {
    private int headerLength = 4;
    private static String encoding = "utf8";
    private static String featureSpace = "#@";
    RTree<Integer, Rectangle> rTree;
    List<GeoFeature> features;

    public FeatureTile(byte[] content) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(content);
        byteBuffer.position(this.headerLength);
        int typeLength = byteBuffer.getInt();
        byte[] typeBytes = new byte[typeLength];
        byteBuffer.get(typeBytes);
        String type = new String(typeBytes, encoding);
        int featureLength = byteBuffer.getInt();
        byte[] snappyBytes = new byte[featureLength];
        byteBuffer.get(snappyBytes);
        int indexLength = byteBuffer.getInt();
        byte[] indexBytes = new byte[indexLength];
        byteBuffer.get(indexBytes);
        int rtreeLength = byteBuffer.getInt();
        byte[] rtreeBytes = new byte[rtreeLength];
        byteBuffer.get(rtreeBytes);
        int[] array = DecodingVarint.Varint2IntArray(indexBytes);
        int featureNums = array.length / 2;
        if (featureNums == 0) {
            return;
        }
        Serializer serializer = Serializers.flatBuffers().javaIo();
        ByteArrayInputStream bin = new ByteArrayInputStream(rtreeBytes);
        this.rTree = serializer.read((InputStream)bin, (long)rtreeLength, InternalStructure.DEFAULT);
        byte[] featureBytes = Snappy.uncompress((byte[])snappyBytes);
        Object[] props = new String(featureBytes, encoding).split(featureSpace);
        int fieldNums = props.length / featureNums;
        ArrayList<GeoFeature> geoFeatures = new ArrayList<GeoFeature>(featureNums);
        ByteBuffer geoBuffer = byteBuffer.slice();
        for (int i = 0; i < featureNums; ++i) {
            int offset = array[i * 2];
            int length = array[i * 2 + 1];
            geoBuffer.position(offset);
            double[] bbox = new double[]{geoBuffer.getDouble(), geoBuffer.getDouble(), geoBuffer.getDouble(), geoBuffer.getDouble()};
            byte[] bf = new byte[length - 32];
            geoBuffer.get(bf);
            geoFeatures.add(new GeoFeature(ArrayUtils.subarray((Object[])props, (int)(i * fieldNums), (int)((i + 1) * fieldNums)), (Object)bf, bbox));
        }
        this.features = geoFeatures;
    }

    public List<GeoFeature> search(RtreeJtsGeometry geometry) {
        Observable search = this.rTree.search((Geometry)geometry, (Func2)new Func2<Rectangle, RtreeJtsGeometry, Boolean>(){

            public Boolean call(Rectangle rectangle, RtreeJtsGeometry geometry) {
                return geometry.intersects(rectangle);
            }
        });
        Iterator iterator = search.toBlocking().getIterator();
        ArrayList<GeoFeature> result = new ArrayList<GeoFeature>();
        while (iterator.hasNext()) {
            Entry next = (Entry)iterator.next();
            result.add(this.features.get((Integer)next.value()));
        }
        return result;
    }

    public List<GeoFeature> getFeatures() {
        return this.features;
    }
}

