/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cellv4;

import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.data_service.DataServiceAdvancedOptions;
import com.geoway.vtile.model.data_service.DataServiceBean;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.layer.LayerBean;
import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datatable.ITable;
import com.geoway.vtile.resources.datatable.MoreThanOneSpatialField;
import com.geoway.vtile.resources.datatable.SpatialInfo;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.ScreenLoction;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.abstractclass.AbstractLayerTileCell;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.cell.process.CutTileProcesser;
import com.geoway.vtile.transform.cell.process.ProcessList;
import com.geoway.vtile.transform.dataholder.ExtentDataHolder;
import com.geoway.vtile.transform.dataholder.ExtentDataHolderArray;
import com.geoway.vtile.transform.dataholder.screenextent.impl.ScreenExtentArray;
import com.geoway.vtile.transform.dataholder.shovel.ScreenLoctionManager;
import com.geoway.vtile.transform.enums.LAYER_TYPE;
import com.geoway.vtile.transform.enums.TILE_TYPE;
import com.geoway.vtile.transform.enums.TILE_VERSION_ENUM;
import com.geoway.vtile.transform.writer.Writer;
import com.geoway.vtile.transform.writer.WriterManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayerTileBuilderCell
extends AbstractLayerTileCell
implements ITileCutterCell<GridExtent, List<Object[]>> {
    private static Logger logger = LoggerFactory.getLogger(LayerTileBuilderCell.class);
    public static final long TILE_FEATURE_COUNT_TOOMUCH = 5000000L;
    protected long MAX_SINGLE_THREAD_SIZE = 100000L;
    protected TILE_TYPE tileType = TILE_TYPE.vector_tile;
    protected TILE_VERSION_ENUM tileVersion = TILE_VERSION_ENUM.v2_0;
    private String layerName;
    protected ITable table;
    private boolean skipLayer = false;
    private String layerFilterString = null;

    @Override
    public void setDown(int down) {
        this.down = down;
    }

    @Override
    public Integer getDown() {
        return this.down;
    }

    public String getLayerFilter() {
        return this.layerFilterString;
    }

    public void setLayerFilter(String layerFilter) {
        this.layerFilterString = layerFilter;
    }

    public LayerTileBuilderCell(ILayer layer, LAYER_TYPE baseOrLabel, String filterString) {
        this.layer = layer;
        this.layerName = layer.getId();
        this.layerFilterString = filterString;
        this.isVectorCellOrLabelCell = baseOrLabel;
        if (LAYER_TYPE.label == baseOrLabel) {
            this.layerName = this.layerName + LayerBean.LABEL_SUFFIX;
        }
    }

    @Override
    public void init() {
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u521d\u59cb\u5316\u56fe\u5c42\u9884\u70ed\u5355\u5143\uff1a{}, \u56fe\u5c42\u5728 {} \u7ea7\u7684\u8fc7\u6ee4\u6761\u4ef6\u4e3a\uff1a{}", new Object[]{this.layerName, this.mainLevel, this.layerFilterString});
        }
        this.skipLayer = !this.layer.isHaveLabel() && LAYER_TYPE.label == this.isVectorCellOrLabelCell;
    }

    @Override
    public List<Object[]> cut(GridExtent extent, TileCutOptions options) throws Exception {
        List oidList;
        int hitCount;
        if (this.skipLayer || this.isCancel()) {
            return null;
        }
        String extraSqlFilter = options.getExtraSqlFilter();
        int offset = options.getStart();
        int limit = options.getLimit();
        Boolean limitMark = options.getLimitMark();
        boolean isLable = LAYER_TYPE.label == this.isVectorCellOrLabelCell;
        Integer extentLevel = extent.getLevel();
        if (StringUtils.isNotBlank((CharSequence)extraSqlFilter)) {
            logger.info("\u56fe\u5c42" + this.layerName + " \u7f51\u683c " + extent.getCodeXYL() + " \u9644\u52a0\u8fc7\u6ee4\u6761\u4ef6\uff1a " + extraSqlFilter);
            extraSqlFilter = extraSqlFilter.replace("\"", "'");
        }
        int currentLevel = extentLevel;
        int endLevel = currentLevel + this.down;
        ILayerLevel layerLevel = (ILayerLevel)this.layer.getLevelMap().get(extentLevel);
        while (layerLevel == null && currentLevel <= endLevel) {
            layerLevel = (ILayerLevel)this.layer.getLevelMap().get(++currentLevel);
        }
        if (layerLevel == null) {
            return null;
        }
        DataServiceAdvancedOptions advancedOptions = ((DataServiceBean)layerLevel.getDataSet().getDataService().getBean()).getAdvancedOptions();
        int bufferSize = advancedOptions.getBufferSize();
        extent.setBufferSize(Integer.valueOf(bufferSize));
        String wkt = extent.getExtentByBuffer(bufferSize).getWkt();
        IDataSet dbDataSet = layerLevel.getDataSet();
        ITable table = dbDataSet.getDataService().getTable();
        ScreenLoction screenLoction = ScreenLoctionManager.getScreenLoction(this.layer, this.isVectorCellOrLabelCell, table.spatialInfo().getGeometryType(), extent, this.down);
        QueryFilter filter = this.buildQueryFilter(dbDataSet, table, wkt, extent, extraSqlFilter, offset, limit);
        long queryStart = 0L;
        if (Log4jUtil.isDiagnoseEnable()) {
            queryStart = System.currentTimeMillis();
            logger.info(Log4jUtil.MARKER_DIAG, "\u7f51\u683c {}({}) \u7a7a\u95f4\u67e5\u8be2\u5f00\u59cb{}", new Object[]{this.layerName, extent.getCodeXYL(), isLable ? " - for\u6ce8\u8bb0" : ""});
        }
        int n = hitCount = null != (oidList = table.mapDao().queryArray(filter, Integer.valueOf(1000))) ? oidList.size() : 0;
        if (Log4jUtil.isDiagnoseEnable()) {
            double querySeconds = (double)(System.currentTimeMillis() - queryStart) * 1.0 / 1000.0;
            logger.info(Log4jUtil.MARKER_DIAG, "\u7f51\u683c {}({}) \u67e5\u8be2\u7ed3\u675f, count: {}, \u8017\u65f6: {} s", new Object[]{this.layerName, extent.getCodeXYL(), hitCount, String.format("%.3f", querySeconds)});
        }
        if ((long)hitCount >= 5000000L) {
            logger.warn("\u3010\u6027\u80fd\u8b66\u544a\u3011\uff1a\u5f53\u524d\u7f51\u683c {}({}) \u6570\u636e\u91cf\u592a\u5927: {}\uff0c\u8bf7\u4f18\u5316\u914d\u56fe\u548c\u74e6\u7247\u9884\u70ed\u7ea7\u522b!", new Object[]{this.layerName, extent.getCodeXYL(), hitCount});
        }
        if (0 == hitCount) {
            if (Log4jUtil.isDiagnoseEnable()) {
                logger.info(Log4jUtil.MARKER_DIAG, "\u7f51\u683c {}({}) \u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u65e0\u9700\u5904\u7406", (Object)this.layerName, (Object)extent.getCodeXYL());
            }
            return null;
        }
        Boolean isExceed = false;
        if (limitMark.booleanValue() && limit == oidList.size()) {
            isExceed = true;
        }
        boolean isUseMultiThread = false;
        Class<? extends Writer> writerClass = WriterManager.getWriterClass(this.tileType, this.tileVersion, isUseMultiThread);
        ScreenExtentArray tileFactory = new ScreenExtentArray(extent, this.down, writerClass);
        this.filterExtentByLevel(tileFactory, extentLevel, layerLevel.getLevel());
        tileFactory.begin();
        ProcessList processBatch = new ProcessList(isUseMultiThread);
        CutTileProcesser cutter = new CutTileProcesser(this, this.layer, tileFactory, screenLoction);
        processBatch.init(table, cutter);
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u7f51\u683c {}_{}_{} \u5f00\u59cb\u5904\u7406\u6570\u636e", new Object[]{extent.getX(), extent.getY(), extent.getLevel()});
            queryStart = System.currentTimeMillis();
        }
        for (Object[] item : oidList) {
            if (this.isCancel()) {
                return null;
            }
            Object id = item[0];
            processBatch.push(id);
        }
        processBatch.end();
        processBatch.waitEnd();
        tileFactory.end();
        if (Log4jUtil.isDiagnoseEnable()) {
            double costSeconds = (double)(System.currentTimeMillis() - queryStart) * 1.0 / 1000.0;
            logger.info("\u7f51\u683c {}({}) {} \u74e6\u7247\u9884\u70ed\u7ed3\u675f\uff0c\u8017\u65f6: {} s", new Object[]{this.layerName, extent.getCodeXYL(), isLable ? "\u6ce8\u8bb0" : "", String.format("%.3f", costSeconds)});
        }
        ExtentDataHolder[] tileDataHolders = tileFactory.getExtentDataHolderArr();
        ArrayList<Object[]> gridList = new ArrayList<Object[]>();
        for (ExtentDataHolder item : tileDataHolders) {
            item.setExceed(isExceed);
            Object tileData = item.getData();
            GridExtent subextent = item.getExtent();
            Integer level = subextent.getLevel();
            ILayerLevel subLevel = (ILayerLevel)this.layer.getLevelMap().get(level);
            if (subLevel != null && subLevel.isVirtual().booleanValue() || tileData == null || ((byte[])tileData).length == 0) continue;
            gridList.add(new Object[]{subextent, tileData, isExceed});
        }
        return gridList;
    }

    private QueryFilter buildQueryFilter(IDataSet dataSet, ITable table, String wkt, GridExtent extent, String extraFilter, int offset, int limit) {
        String sortStr;
        QueryFilter filter = new QueryFilter();
        if (limit != -1) {
            filter.setStart(Integer.valueOf(offset));
            filter.setLimit(Integer.valueOf(limit));
        }
        SpatialInfo spatialInfo = null;
        try {
            spatialInfo = table.spatialInfo();
        }
        catch (MoreThanOneSpatialField moreThanOneSpatialField) {
            moreThanOneSpatialField.printStackTrace();
        }
        Integer srid = spatialInfo.getSrid() == null ? 0 : spatialInfo.getSrid();
        filter.setSRID(srid);
        if (dataSet.getDataSource().getDataSourceType() == Constants.DATA_SOURCE_TYPE.spark) {
            filter.setOutputFieldNames(dataSet.getFieldsArr());
        } else {
            filter.setOutputFieldNames(dataSet.getIdField());
        }
        Constants.OPERATION operation = Constants.OPERATION.MBR_INTERSECTS;
        if (dataSet.getDataSource().getDataSourceType() != Constants.DATA_SOURCE_TYPE.oracle && (dataSet.getGeometryType() == Constants.GEO_TYPE.LINESTRING || dataSet.getGeometryType() == Constants.GEO_TYPE.MULTILINESTRING)) {
            operation = Constants.OPERATION.INTERSECTS;
        }
        if (GlobalTileSettings.bAccurateIntersect) {
            operation = Constants.OPERATION.INTERSECTS;
        }
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u7f51\u683c {} \u7a7a\u95f4\u67e5\u8be2\u6761\u4ef6\uff1a\"{}\" {} '{}' ", new Object[]{extent.getCodeXYL(), spatialInfo.getSpatialField(), operation, wkt});
        }
        filter.addFilter(spatialInfo.getSpatialField(), operation, new Object[]{wkt});
        String dataFilterStr = dataSet.getFilter();
        if (StringUtils.isNotEmpty((CharSequence)dataFilterStr)) {
            if (dataFilterStr.startsWith("Q")) {
                filter.addQueryFilterStr(dataFilterStr, 1);
            } else {
                filter.addSQL(dataFilterStr);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)extraFilter)) {
            if (extraFilter.startsWith("Q")) {
                filter.addQueryFilterStr(extraFilter, 1);
            } else {
                if (extraFilter.indexOf("\\\"") != -1) {
                    extraFilter = extraFilter.replaceAll("\\\\\"", "\"");
                }
                filter.addSQL(extraFilter, Constants.RELATION.AND);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.layerFilterString)) {
            filter.addSQL(this.layerFilterString, Constants.RELATION.AND);
        }
        if ((sortStr = dataSet.getSortFiled()) != null && !"".equalsIgnoreCase(sortStr)) {
            filter.addSorted(sortStr, QueryFilter.SORT.valueOf((String)dataSet.getSort()));
        }
        return filter;
    }

    void filterExtentByLevel(ExtentDataHolderArray tileFactory, int mainLevel, int beginLevel) {
        int currentLevel;
        if (mainLevel >= beginLevel) {
            return;
        }
        ExtentDataHolder mainHolder = tileFactory.getMainHolder();
        ArrayList<Object> all = new ArrayList<Object>();
        all.add(mainHolder);
        List<Object> children = mainHolder.getChildren() == null ? new ArrayList() : Arrays.asList(mainHolder.getChildren());
        for (currentLevel = mainLevel + 1; currentLevel < beginLevel; ++currentLevel) {
            ArrayList newChildren = new ArrayList();
            children.forEach(child -> newChildren.addAll(Arrays.asList(child.getChildren())));
            children = newChildren;
        }
        mainHolder.setChildren((ExtentDataHolder[])children.stream().toArray(ExtentDataHolder[]::new));
        int endLevel = mainLevel + this.down;
        while (currentLevel < endLevel) {
            all.addAll(children);
            ArrayList newChildren = new ArrayList();
            children.forEach(child -> newChildren.addAll(Arrays.asList(child.getChildren())));
            children = newChildren;
            ++currentLevel;
        }
        all.addAll(children);
        tileFactory.setExtentDataHolderArr((ExtentDataHolder[])all.stream().toArray(ExtentDataHolder[]::new));
    }
}

