/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell;

import com.geoway.vtile.model.data_service.DataServiceBean;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.spatial.Geom;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.grid.GridManager;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.spatial.grid.ScanLine;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.bean.ExtentGeometry;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.abstractclass.AbstractLayerTileCell;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import com.geoway.vtile.transform.enums.TILE_TYPE;
import com.geoway.vtile.transform.tools.Boxset;
import com.geoway.vtile.transform.utils.GeometryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.locationtech.jts.operation.union.UnaryUnionOp;

public class AreaLabelCutCell
extends AbstractLayerTileCell
implements ITileCutterCell<Object[], List<Object[]>> {
    protected TILE_TYPE tileType = TILE_TYPE.vector_tile;
    private final IGridSystem grid;
    public static final double[] areas = new double[]{518400.0, 129600.0, 32400.0, 8100.0, 2025.0, 506.25, 126.5625, 31.640625, 7.91015625, 1.9775390625, 0.494384765625, 0.12359619140625, 0.0308990478515625, 0.007724761962890625, 0.0019311904907226562, 4.8279762268066406E-4, 1.2069940567016602E-4, 3.0174851417541504E-5, 7.543712854385376E-6, 1.885928213596344E-6};
    Integer[] singlePolygonLabelLevel = new Integer[0];

    public AreaLabelCutCell(ILayer layer, IGridSystem grid, Integer level) {
        this.layer = layer;
        this.mainLevel = level;
        this.grid = grid;
    }

    @Override
    public void init() {
    }

    @Override
    public List<Object[]> cut(Object[] data, TileCutOptions options) throws Exception {
        if (data == null) {
            return null;
        }
        ILayerLevel layerLevel = (ILayerLevel)this.layer.getLevelMap().get(this.mainLevel);
        int currentLevel = this.mainLevel;
        int endLevel = currentLevel + this.down;
        while (layerLevel == null && currentLevel <= endLevel) {
            layerLevel = (ILayerLevel)this.layer.getLevelMap().get(++currentLevel);
        }
        this.singlePolygonLabelLevel = ((DataServiceBean)layerLevel.getDataSet().getDataService().getBean()).getAdvancedOptions().getSinglePolygonLabelLevel();
        Object[] fields = layerLevel.getDataSet().getFieldsArr();
        String spatialField = layerLevel.getDataSet().getSpatialField();
        String idField = layerLevel.getDataSet().getIdField();
        int spatialIndex = ArrayUtils.indexOf((Object[])fields, (Object)spatialField);
        int idIndex = ArrayUtils.indexOf((Object[])fields, (Object)idField);
        GeoBuffer geo = ((Geom)data[spatialIndex]).toGeoBuffer();
        Object[] item = ArrayUtils.remove((Object[])data, (int)spatialIndex);
        if (this.isCancel()) {
            return null;
        }
        Geometry geometry = geo.toJTSGeometry();
        int numGeometries = geometry.getNumGeometries();
        ArrayList<Object[]> all = new ArrayList<Object[]>();
        for (int i = 0; i < numGeometries; ++i) {
            Object[] itemi = ArrayUtils.clone((Object[])item);
            itemi[idIndex] = itemi[idIndex] + "" + i;
            List<Object[]> result = this.dealWithPolygon(itemi, geometry.getGeometryN(i));
            if (result == null) continue;
            all.addAll(result);
        }
        return all;
    }

    private List<Object[]> dealWithPolygon(Object[] item, Geometry geometry) throws Exception {
        Integer rootLevel;
        Point interiorPoint = geometry.getInteriorPoint();
        double[] feaCenter = new double[]{interiorPoint.getX(), interiorPoint.getY()};
        List<ExtentGeometry> extents = this.getRootExtentByEnv(geometry);
        if (extents.isEmpty()) {
            return null;
        }
        if (extents.size() == 1) {
            extents.get(0).setCenter(feaCenter);
        }
        if ((rootLevel = Integer.valueOf(extents.get(0).getExtent().getLevel())) < this.mainLevel + this.down) {
            extents = this.getExtentByRoot(extents, rootLevel, this.mainLevel, this.down);
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>(extents.size());
        for (ExtentGeometry extentGeometry : extents) {
            GridExtent extent = extentGeometry.getExtent();
            double[] center = ArrayUtils.indexOf((Object[])this.singlePolygonLabelLevel, (Object)rootLevel) >= 0 || feaCenter[0] >= extent.getLeft() && feaCenter[0] <= extent.getRight() && feaCenter[1] >= extent.getBottom() && feaCenter[1] <= extent.getTop() ? feaCenter : extentGeometry.getCenter();
            double[] now = Boxset.createEmptyDoubleArray();
            this.toExtentCoordinate(center[0], center[1], extent, now, 1.0, null);
            double distance = this.getDistance(center, feaCenter);
            Object[] newProps = ArrayUtils.add((Object[])item, (Object)distance);
            Object[] arr = new Object[]{extent.getKey(), newProps, now[0], now[1]};
            result.add(arr);
        }
        return result;
    }

    private double getDistance(double[] p1, double[] p2) {
        return Math.sqrt(p1[0] - p2[0]) + Math.sqrt(p1[1] - p2[1]);
    }

    private List<ExtentGeometry> getExtentByRoot(List<ExtentGeometry> rootMaps, Integer rootLevel, Integer beginLevel, Integer downLevel) {
        int endLevel = beginLevel + downLevel;
        ArrayList<ExtentGeometry> nextLevelExtents = null;
        List<GridExtent> sub = null;
        ArrayList<ExtentGeometry> result = new ArrayList<ExtentGeometry>();
        if (rootLevel == beginLevel) {
            result.addAll(rootMaps);
        }
        while (rootLevel < endLevel) {
            nextLevelExtents = new ArrayList<ExtentGeometry>(rootMaps.size() * 4);
            for (ExtentGeometry holder : rootMaps) {
                sub = this.buildDownArray(holder.getExtent());
                for (GridExtent subExtent : sub) {
                    Geometry intersection;
                    if (holder.isFull()) {
                        ExtentGeometry extentGeometry = new ExtentGeometry(subExtent, this.getGeometryByExtent(subExtent), true);
                        extentGeometry.setCenter(new double[]{(subExtent.getLeft() + subExtent.getRight()) / 2.0, (subExtent.getTop() + subExtent.getBottom()) / 2.0});
                        nextLevelExtents.add(extentGeometry);
                        continue;
                    }
                    Geometry extentGeom = this.getGeometryByExtent(subExtent);
                    Geometry envelope = holder.getGeometry().getEnvelope();
                    if (envelope.coveredBy(extentGeom)) {
                        ExtentGeometry extentGeometry = new ExtentGeometry(subExtent, holder.getGeometry(), false);
                        nextLevelExtents.add(extentGeometry);
                        break;
                    }
                    if (!envelope.intersects(extentGeom) || (intersection = this.getIntersectionWithExtent(holder.getGeometry(), extentGeom)) == null || intersection.isEmpty()) continue;
                    boolean isFull = extentGeom.coveredBy(intersection);
                    ExtentGeometry extentGeometry = new ExtentGeometry(subExtent, intersection, isFull);
                    if (isFull) {
                        extentGeometry.setCenter(new double[]{(subExtent.getLeft() + subExtent.getRight()) / 2.0, (subExtent.getTop() + subExtent.getBottom()) / 2.0});
                    }
                    nextLevelExtents.add(extentGeometry);
                }
                if (nextLevelExtents.size() != 1) continue;
                ((ExtentGeometry)nextLevelExtents.get(0)).setCenter(holder.getCenter());
            }
            rootMaps = nextLevelExtents;
            if (rootLevel >= beginLevel && rootLevel <= endLevel) {
                result.addAll(nextLevelExtents);
            }
            Integer n = rootLevel;
            Integer n2 = rootLevel = Integer.valueOf(rootLevel + 1);
        }
        return result;
    }

    private List<GridExtent> buildDownArray(GridExtent extent) {
        ArrayList<GridExtent> list = new ArrayList<GridExtent>();
        int x = extent.getX();
        int y = extent.getY();
        int l = extent.getLevel() + 1;
        GridExtent extent0 = this.grid.getExtent(l, x * 2, y * 2);
        GridExtent extent1 = this.grid.getExtent(l, x * 2 + 1, y * 2);
        GridExtent extent2 = this.grid.getExtent(l, x * 2, y * 2 + 1);
        GridExtent extent3 = this.grid.getExtent(l, x * 2 + 1, y * 2 + 1);
        list.add(extent0);
        list.add(extent1);
        list.add(extent2);
        list.add(extent3);
        return list;
    }

    private List<ExtentGeometry> getRootExtentByEnv(Geometry geometry) throws Exception {
        Geometry env = geometry.getEnvelope();
        ArrayList<ExtentGeometry> rootMaps = new ArrayList<ExtentGeometry>(4);
        double envArea = env.getArea();
        Integer rootLevel = this.getLevelByArea(envArea);
        double[][] points = GeometryUtils.getPointsFromGeometry(env);
        ScanLine scanLine = new ScanLine(Integer.valueOf(1), new Integer[]{rootLevel}, this.grid);
        scanLine.calculate(points);
        Set set = (Set)scanLine.getExtents().get(rootLevel);
        for (String colrow : set) {
            int x = Integer.valueOf(colrow.split("_")[0]);
            int y = Integer.valueOf(colrow.split("_")[1]);
            GridExtent extent = this.grid.getExtent(rootLevel.intValue(), x, y);
            if (set.size() > 1) {
                Geometry extentGeom = this.getGeometryByExtent(extent);
                Geometry intersection = this.getIntersectionWithExtent(geometry, extentGeom);
                if (intersection == null || intersection.isEmpty()) continue;
                rootMaps.add(new ExtentGeometry(extent, intersection, false));
                continue;
            }
            rootMaps.add(new ExtentGeometry(extent, geometry, false));
        }
        return rootMaps;
    }

    private Geometry getIntersectionWithExtent(Geometry geometry, Geometry extentGeom) {
        OverlayOp op = new OverlayOp(extentGeom, geometry);
        Geometry intersectArea = null;
        try {
            intersectArea = op.getResultGeometry(1);
        }
        catch (Exception e) {
            geometry = GeometryFixer.fix((Geometry)geometry);
            op = new OverlayOp(extentGeom, geometry);
            intersectArea = op.getResultGeometry(1);
        }
        if (intersectArea instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)intersectArea;
            int num = geometryCollection.getNumGeometries();
            ArrayList<Geometry> polygons = new ArrayList<Geometry>(num);
            for (int i = 0; i < num; ++i) {
                Geometry geometryN = geometryCollection.getGeometryN(i);
                if (!(geometryN instanceof Polygon) && !(geometryN instanceof MultiPolygon)) continue;
                polygons.add(geometryN);
            }
            if (polygons.isEmpty()) {
                return null;
            }
            UnaryUnionOp unaryUnionOp = new UnaryUnionOp(polygons);
            Geometry union = unaryUnionOp.union();
            return union;
        }
        return intersectArea;
    }

    private Geometry getGeometryByExtent(GridExtent extent) {
        double[] points = GeometryUtils.getDoubleArrayFromExtent4Point(extent.getBBoxCoordinates());
        return GeometryUtils.getPolygonFromPoints(points);
    }

    private Integer getLevelByArea(double area) {
        for (int i = 0; i < this.mainLevel; ++i) {
            if (!(area > areas[i])) continue;
            return i;
        }
        return this.mainLevel;
    }

    @Override
    public void setDown(int down) {
        this.down = down;
    }

    protected void toExtentCoordinate(double x, double y, GridExtent extent, double[] now, double times, double[] bbox) {
        double _x = (double)Math.round((x - extent.getLeft()) / extent.getResolution() * times) / times;
        double _y = (double)Math.round((extent.getTop() - y) / extent.getResolution() * times) / times;
        now[0] = _x;
        now[1] = _y;
        if (bbox != null) {
            if (Double.isNaN(bbox[0]) || bbox[0] > _x) {
                bbox[0] = _x;
            }
            if (Double.isNaN(bbox[1]) || bbox[1] > _y) {
                bbox[1] = _y;
            }
            if (Double.isNaN(bbox[2]) || bbox[2] < _x) {
                bbox[2] = _x;
            }
            if (Double.isNaN(bbox[3]) || bbox[3] < _y) {
                bbox[3] = _y;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        String wkt = "POLYGON ((112.880792831 35.979297768, 112.880792773 35.979326858, 112.88079268 35.979373401, 112.880796148 35.97940555, 112.880798957 35.979431592, 112.880818047 35.979478167, 112.880843472 35.979553843, 112.880862561 35.979600419, 112.880875222 35.979664437, 112.880865395 35.979746955, 112.880865318 35.979785718, 112.880865195 35.979847737, 112.880890553 35.979948561, 112.880899497 35.97996382, 112.881013115 35.979904217, 112.881077053 35.979833833, 112.881112402 35.979660383, 112.880792831 35.979297768))";
        WKTReader reader = new WKTReader();
        Geometry read = reader.read(wkt);
        AreaLabelCutCell areaLabelCutCell = new AreaLabelCutCell(null, (IGridSystem)GridManager.getQuadtreeGrid((String)"tdt_degrees_base512"), 10);
        areaLabelCutCell.setDown(0);
        Object[] data = new Object[]{13, "\u798f\u5efa\u7701"};
        try {
            areaLabelCutCell.dealWithPolygon(data, read);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

