/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.writer;

import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.commons.util.StringUtility;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.transform.tools.TypeTool;
import com.geoway.vtile.transform.writer.Writer;
import com.geoway.vtile.transform.writer.json.JsonWriter;
import com.geoway.vtile.transform.writer.json.JsonWriterImpl;
import java.io.UnsupportedEncodingException;

public class JsonWriterVersion1_0
implements Writer {
    protected StringBuilder sb = new StringBuilder();
    protected StringBuilder _objectJSONTmp = new StringBuilder();
    protected StringBuilder _pathJSONTmp = new StringBuilder();
    protected JsonWriter jsonWriter = new JsonWriterImpl();
    protected Integer accuracy = 1;

    @Override
    public void beginTile() {
        this.jsonWriter.arrayBegin(this.sb);
    }

    @Override
    public void endTile() {
        this.jsonWriter.arrayEnd(this.sb);
    }

    @Override
    public void featureNext() {
        if (!this.isObjectJSONTmpEmpty().booleanValue()) {
            this.jsonWriter.arrayNextElement(this.sb);
        }
        this._objectJSONTmp.delete(0, this._objectJSONTmp.length());
    }

    @Override
    public void beginFeature() {
        this.jsonWriter.arrayBegin(this._objectJSONTmp);
    }

    protected Boolean isObjectJSONTmpEmpty() {
        if (this._objectJSONTmp.charAt(this._objectJSONTmp.length() - 1) == ']' && this._objectJSONTmp.charAt(this._objectJSONTmp.length() - 2) == '[') {
            return true;
        }
        return false;
    }

    protected Boolean isPathJSONTmpEmpty() {
        if (this._pathJSONTmp.toString().equals("[]")) {
            return true;
        }
        return false;
    }

    @Override
    public void endFeature() {
        if (!this.isObjectJSONTmpEmpty().booleanValue()) {
            this.jsonWriter.arrayEnd(this._objectJSONTmp);
            this.sb.append((CharSequence)this._objectJSONTmp);
        }
    }

    @Override
    public void setPropertys(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject) {
    }

    @Override
    public void beginPath() {
        this.jsonWriter.arrayBegin(this._pathJSONTmp);
    }

    @Override
    public void endPath() {
        this.jsonWriter.arrayEnd(this._pathJSONTmp);
        if (!this.isPathJSONTmpEmpty().booleanValue()) {
            this._objectJSONTmp.append((CharSequence)this._pathJSONTmp).append(JsonWriterImpl.comma);
        }
        this._pathJSONTmp.delete(0, this._pathJSONTmp.length());
    }

    @Override
    public void addFull(Boolean clockwise) {
    }

    public StringBuilder createPropertysPart(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject) {
        StringBuilder sb = new StringBuilder();
        this.jsonWriter.arrayBegin(sb);
        sb.append(JsonWriterImpl.marks).append(geoType.name()).append(JsonWriterImpl.marks);
        this.jsonWriter.arrayNextElement(sb);
        this.setPropertys(sb, propertyFields, propertyObject);
        this.jsonWriter.arrayEnd(sb);
        return sb;
    }

    @Override
    public void setPropertysPart(Object part) {
        if (!this.isObjectJSONTmpEmpty().booleanValue()) {
            StringBuilder partBuilder = (StringBuilder)part;
            this.jsonWriter.arrayEnd(this._objectJSONTmp);
            this._objectJSONTmp = this._objectJSONTmp.insert(0, partBuilder);
        }
    }

    @Override
    public void addCoordinates(DoubleBuilder points, double times) {
        int size = points.size();
        for (int i = 0; i < size / 2; ++i) {
            double x = points.get(i * 2);
            double y = points.get(i * 2 + 1);
            this._pathJSONTmp.append(x).append(',').append(y).append(',');
        }
    }

    @Override
    public void addCoordinates(double[] points, double times) {
        int size = points.length;
        for (int i = 0; i < size / 2; ++i) {
            double x = points[i * 2];
            double y = points[i * 2 + 1];
            this._pathJSONTmp.append(x).append(',').append(y).append(',');
        }
    }

    @Override
    public void addCoordinates(double x, double y, double times) {
        this._pathJSONTmp.append(x).append(',').append(y).append(',');
    }

    public byte[] getData() {
        try {
            return this.sb.toString().getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Integer getAccuracy() {
        return this.accuracy;
    }

    @Override
    public void setGeoType(Constants.GEO_TYPE geoType) {
    }

    @Override
    public Constants.GEO_TYPE getGeoType() {
        return null;
    }

    @Override
    public void beginServerTile() {
        this.jsonWriter.objectBegin(this.sb);
    }

    @Override
    public void addLayer(String id, byte[] bytes) {
        this.jsonWriter.setPropertyName(id, this.sb);
        this.jsonWriter.setPropertyWraper(new StringBuilder(new String(bytes)), this.sb);
        this.jsonWriter.propertyEnd(this.sb);
    }

    @Override
    public void endServerTile() {
        this.jsonWriter.objectEnd(this.sb);
    }

    @Override
    public void setExceed(boolean exceed) {
    }

    protected void setPropertys(StringBuilder sbproperty, String[] propertyFields, Object[] propertyObject) {
        if (propertyFields == null || propertyFields.length == 0) {
            return;
        }
        this.jsonWriter.arrayBegin(sbproperty);
        for (int i = 0; i < propertyFields.length; ++i) {
            Object value = propertyObject[i];
            if (value == null) {
                sbproperty.append("\"\"");
                this.jsonWriter.arrayNextElement(sbproperty);
                continue;
            }
            Object[] info = TypeTool.getTypeAndValue(value);
            if (info == null) continue;
            String type = (String)info[0];
            if ("number".equals(type)) {
                sbproperty.append(info[1]);
            }
            if ("string".equals(type)) {
                String valueJsonStr = StringUtility.changeHtm((String)String.valueOf(info[1]));
                sbproperty.append(JsonWriterImpl.marks).append(valueJsonStr).append(JsonWriterImpl.marks);
            }
            if ("date".equals(type)) {
                sbproperty.append(info[1]);
            }
            this.jsonWriter.arrayNextElement(sbproperty);
        }
        this.jsonWriter.arrayEnd(sbproperty);
    }
}

