/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.tools.varint;

import com.geoway.vtile.transform.tools.varint.ZigZagUtil;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class EncodingVarint {
    public static byte[] IntArray2Variant(int[] data) {
        ByteBuffer buffer = ByteBuffer.allocate(data.length * 5);
        for (int i : data) {
            buffer.put(EncodingVarint.int2Variant(i));
        }
        buffer.flip();
        byte[] t = new byte[buffer.limit()];
        buffer.get(t);
        return t;
    }

    public static ByteArrayOutputStream IntArray2VariantStream(int[] data) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (int i : data) {
            stream.write(EncodingVarint.int2Variant(i));
        }
        return stream;
    }

    public static byte[] IntToByte(int num) {
        byte[] bytes = new byte[]{(byte)(num >> 24 & 0xFF), (byte)(num >> 16 & 0xFF), (byte)(num >> 8 & 0xFF), (byte)(num & 0xFF)};
        return bytes;
    }

    public static byte[] int2Variant(int num) {
        if (num == 0) {
            return new byte[]{0};
        }
        num = ZigZagUtil.encoding(num);
        ByteBuffer buffer = ByteBuffer.allocate(5);
        byte high = 0;
        for (int i = 5; i > 0; --i) {
            byte now = (byte)(num >> (i - 1) * 7 & 0x7F);
            if (high != 0) {
                now = (byte)(now | 0x80);
            }
            if (now != 0) {
                buffer.put(now);
            }
            high = now;
        }
        buffer.flip();
        byte[] t = new byte[buffer.limit()];
        buffer.get(t);
        return t;
    }

    public static ByteBuffer Int2VariantBuffer(int num) {
        if (num == 0) {
            return ByteBuffer.allocate(1);
        }
        ByteBuffer buffer = ByteBuffer.allocate(5);
        byte high = 0;
        for (int i = 5; i > 0; --i) {
            byte now = (byte)(num >> (i - 1) * 7 & 0x7F);
            if (high != 0) {
                now = (byte)(now | 0x80);
            }
            if (now != 0) {
                buffer.put(now);
            }
            high = now;
        }
        buffer.flip();
        return buffer;
    }
}

