/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.tools.varint;

import com.geoway.vtile.transform.tools.varint.DecodingVarint;
import com.geoway.vtile.transform.tools.varint.model.LayerContentModel;
import com.geoway.vtile.transform.tools.varint.model.LayerInfoModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;

public class VarintReader {
    private static Logger log = LoggerFactory.getLogger(VarintReader.class);
    private int headerLength;
    private Map<String, Integer> proSizeMap;
    private static String vectorName = "vector";
    private static String gTypeKey = "gType";
    private static String encoding = "utf8";
    private static String featureSpace = "#@";
    private Map<String, ByteBuffer> layerMap;
    private Map<String, String> vectorHeaderProMap;
    private Map<String, Map<String, String>> layerHeaderProMap;
    private Map<String, ByteBuffer> layerHeaderProBuffer;
    private Map<String, ByteBuffer> featureMap;
    private Map<String, List<String[]>> featureArrayMap;
    private Map<String, ByteBuffer> offsetBufferMap;
    private Map<String, int[]> offsetArrayMap;
    private Map<String, ByteBuffer> varintMap;

    public VarintReader(ByteBuffer buffer, int headerLength, Map<String, Integer> proSizeMap) throws Exception {
        this.headerLength = headerLength;
        this.proSizeMap = proSizeMap;
        this.layerMap = new LinkedHashMap<String, ByteBuffer>();
        this.vectorHeaderProMap = new HashMap<String, String>();
        this.layerHeaderProMap = new HashMap<String, Map<String, String>>();
        this.layerHeaderProBuffer = new HashMap<String, ByteBuffer>();
        this.featureMap = new HashMap<String, ByteBuffer>();
        this.featureArrayMap = new HashMap<String, List<String[]>>();
        this.offsetBufferMap = new HashMap<String, ByteBuffer>();
        this.offsetArrayMap = new HashMap<String, int[]>();
        this.varintMap = new HashMap<String, ByteBuffer>();
        this._parseVector(buffer);
    }

    public Map<String, String> getVectorHeaderProMap() {
        return this.vectorHeaderProMap;
    }

    public Map<String, Map<String, String>> getLayerHeaderProMap() {
        return this.layerHeaderProMap;
    }

    public ByteBuffer getLayerBuffer(String layerName) {
        return this.layerMap.get(layerName);
    }

    public LayerContentModel getLayerProByFilter(String layerName, int[] featureIndexArray) throws Exception {
        ArrayList<byte[]> coordinateBufferArray = new ArrayList<byte[]>();
        ByteBuffer varintBuffer = this.varintMap.get(layerName);
        int[] offsetArray = this.offsetArrayMap.get(layerName);
        List<String[]> featureArray = this._lazyParseFeature(layerName);
        ArrayList<String[]> filterArray = new ArrayList<String[]>();
        for (int i = 0; i < featureIndexArray.length; ++i) {
            int idx = featureIndexArray[i];
            filterArray.add(featureArray.get(idx));
            int offset = offsetArray[idx * 2];
            int length = offsetArray[idx * 2 + 1];
            varintBuffer.position(offset);
            byte[] tmp = new byte[length];
            varintBuffer.get(tmp);
            coordinateBufferArray.add(tmp);
        }
        varintBuffer.rewind();
        LayerContentModel model = new LayerContentModel();
        model.setLayerHeaderProBuffer(this.layerHeaderProBuffer.get(layerName));
        model.setFeatureArray(filterArray);
        model.setCoordinateBufferArray(coordinateBufferArray);
        return model;
    }

    public String[] getAllLayerNames() {
        return this.layerMap.keySet().toArray(new String[this.layerMap.size()]);
    }

    public String getGeometryType(String layerName) {
        return this.layerHeaderProMap.get(layerName).get(gTypeKey);
    }

    public String[] getLayerProByIndex(String layerName, int featureIndex) throws Exception {
        return this._lazyParseFeature(layerName).get(featureIndex);
    }

    public List<String[]> getLayerPro(String layerName) throws Exception {
        return this._lazyParseFeature(layerName);
    }

    public int[] getOffsetArray(String layerName) {
        return this.offsetArrayMap.get(layerName);
    }

    public int[] getOffsetByIndex(String layerName, int featureIndex) {
        int[] all = this.offsetArrayMap.get(layerName);
        int[] arr = new int[]{all[featureIndex * 2], all[featureIndex * 2 + 1]};
        return arr;
    }

    public ByteBuffer getLayerCoordinate(String layerName) {
        return this.varintMap.get(layerName);
    }

    public LayerInfoModel getLayerFeature(String layerName) {
        LayerInfoModel model = new LayerInfoModel();
        model.setFeatureBuffer(this.featureMap.get(layerName));
        model.setOffsetArray(this.offsetArrayMap.get(layerName));
        model.setVarintBuffer(this.varintMap.get(layerName));
        return model;
    }

    public List<double[]> getAllCoordinates(String layerName, int precision) {
        int[] ofs = this.offsetArrayMap.get(layerName);
        ByteBuffer buffer = this.varintMap.get(layerName);
        ArrayList<double[]> coorArray = new ArrayList<double[]>();
        for (int i = 0; i < ofs.length / 2; ++i) {
            int offset = ofs[i * 2];
            int length = ofs[i * 2 + 1];
            buffer.position(offset);
            byte[] bf = new byte[length];
            buffer.get(bf);
            coorArray.add(this._bufferToDoubleArray(bf, precision));
        }
        buffer.rewind();
        return coorArray;
    }

    public double[] getCoordinatesByIndex(String layerName, int proIndex, int precision) {
        int[] ofs = this.getOffsetByIndex(layerName, proIndex);
        ByteBuffer buffer = this.varintMap.get(layerName);
        int offset = ofs[0];
        int length = ofs[1];
        buffer.position(offset);
        byte[] bf = new byte[length];
        buffer.get(bf);
        buffer.rewind();
        return this._bufferToDoubleArray(bf, precision);
    }

    private void _parseVector(ByteBuffer vectorVarintBuffer) throws Exception {
        vectorVarintBuffer.position(this.headerLength);
        int typeLength = vectorVarintBuffer.getInt();
        byte[] typeBytes = new byte[typeLength];
        vectorVarintBuffer.get(typeBytes);
        String type = new String(typeBytes, encoding);
        if (!vectorName.equals(type)) {
            log.error("\u4e0d\u662f\u74e6\u7247\u6570\u636e\uff01");
            return;
        }
        this._parseHeaderPro(vectorVarintBuffer, this.vectorHeaderProMap);
        int indexLength = vectorVarintBuffer.getInt();
        byte[] indexBytes = new byte[indexLength];
        vectorVarintBuffer.get(indexBytes);
        ByteBuffer indexBuffer = ByteBuffer.wrap(indexBytes);
        int layerNameLength = 0;
        int i = 0;
        while (i < indexBuffer.limit()) {
            layerNameLength = indexBuffer.getInt();
            byte[] layerNameBytes = new byte[layerNameLength];
            indexBuffer.get(layerNameBytes);
            String layerName = new String(layerNameBytes, encoding);
            int dataLength = indexBuffer.getInt();
            byte[] layerDataBytes = new byte[dataLength];
            vectorVarintBuffer.get(layerDataBytes);
            ByteBuffer layerBuffer = ByteBuffer.wrap(layerDataBytes);
            this.layerMap.put(layerName, layerBuffer);
            this._parseLayer(layerName, layerBuffer);
            layerBuffer.rewind();
            i = indexBuffer.position();
        }
    }

    private void _parseLayer(String layerName, ByteBuffer layerBuffer) throws IOException {
        if (layerBuffer.limit() == 0) {
            return;
        }
        layerBuffer.position(this.headerLength);
        HashMap<String, String> map = new HashMap<String, String>();
        ByteBuffer buffer = this._parseHeaderPro(layerBuffer, map);
        this.layerHeaderProMap.put(layerName, map);
        this.layerHeaderProBuffer.put(layerName, buffer);
        int featureLength = layerBuffer.getInt();
        if (featureLength > 0) {
            byte[] featureBytes = new byte[featureLength];
            layerBuffer.get(featureBytes);
            featureBytes = Snappy.uncompress((byte[])featureBytes);
            this.featureMap.put(layerName, ByteBuffer.wrap(featureBytes));
        } else {
            this.featureMap.put(layerName, ByteBuffer.allocate(0));
        }
        this._parseIndex(layerName, layerBuffer);
        ByteBuffer nb = layerBuffer.slice();
        this.varintMap.put(layerName, nb);
    }

    private ByteBuffer _parseHeaderPro(ByteBuffer varintBuffer, Map<String, String> headerProMap) throws IOException {
        int headerProLength = varintBuffer.getInt();
        if (headerProLength == 0) {
            return ByteBuffer.allocate(0);
        }
        byte[] headerProBytes = new byte[headerProLength];
        varintBuffer.get(headerProBytes);
        byte[] proBytes = Snappy.uncompress((byte[])headerProBytes);
        String[] headerProArray = new String(proBytes, encoding).split(":");
        for (int i = 0; i < headerProArray.length / 2; ++i) {
            headerProMap.put(headerProArray[i * 2], headerProArray[i * 2 + 1]);
        }
        return ByteBuffer.wrap(headerProBytes);
    }

    private void _parseIndex(String layerName, ByteBuffer layerBuffer) {
        int length = layerBuffer.getInt();
        byte[] offsetBytes = new byte[length];
        layerBuffer.get(offsetBytes);
        int[] array = DecodingVarint.Varint2IntArray(offsetBytes);
        this.offsetBufferMap.put(layerName, ByteBuffer.wrap(offsetBytes));
        this.offsetArrayMap.put(layerName, array);
    }

    private List<String[]> _lazyParseFeature(String layerName) throws Exception {
        List<String[]> featureArray = this.featureArrayMap.get(layerName);
        int proSize = this.proSizeMap.get(layerName);
        if (featureArray == null || featureArray.isEmpty()) {
            int current;
            featureArray = new ArrayList<String[]>();
            ByteBuffer buffer = this.featureMap.get(layerName);
            if (buffer.limit() <= 0) {
                this.featureArrayMap.put(layerName, new ArrayList());
                return featureArray;
            }
            String[] props = new String(buffer.array(), encoding).split(featureSpace);
            int length = props.length / proSize;
            int next = current = 0;
            List<String> propsList = Arrays.asList(props);
            for (int i = 0; i < length; ++i) {
                next = current + proSize;
                featureArray.add(propsList.subList(current, next).toArray(new String[proSize]));
                current = next;
            }
            this.featureArrayMap.put(layerName, featureArray);
        }
        return featureArray;
    }

    private double[] _bufferToDoubleArray(byte[] buffer, int precision) {
        ArrayList<Byte> varintCode = new ArrayList<Byte>();
        ArrayList<Double> path = new ArrayList<Double>();
        ArrayList<Double> nums = new ArrayList<Double>();
        int bf_index = 0;
        int oldX = 0;
        int oldY = 0;
        boolean isX = true;
        for (int i = 0; i <= buffer.length; ++i) {
            int high = i == buffer.length ? 0 : 0 | buffer[i] >> 7 & 1;
            if (high == 0 && bf_index > 0) {
                if (bf_index > 0 && bf_index <= 5) {
                    byte[] tmp = this.listToBytes(varintCode);
                    if (isX) {
                        int x = DecodingVarint.varintToInt(tmp) + oldX;
                        path.add(Double.valueOf(x / precision));
                        isX = false;
                        oldX = x;
                    } else {
                        int y = DecodingVarint.varintToInt(tmp) + oldY;
                        path.add(Double.valueOf(y / precision));
                        isX = true;
                        oldY = y;
                    }
                    bf_index = 0;
                    varintCode.clear();
                } else if (bf_index > 5) {
                    oldX = 0;
                    oldY = 0;
                    bf_index = 0;
                    varintCode.clear();
                    nums.addAll(path);
                    path.clear();
                }
            }
            if (i != buffer.length) {
                varintCode.add(buffer[i]);
                ++bf_index;
                continue;
            }
            if (path.size() <= 0) continue;
            nums.addAll(path);
        }
        return this.listToDoubleArray(nums);
    }

    private byte[] listToBytes(List<Byte> varintCode) {
        byte[] bytes = new byte[varintCode.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = varintCode.get(i);
        }
        return bytes;
    }

    private double[] listToDoubleArray(List<Double> doubleList) {
        double[] ds = new double[doubleList.size()];
        for (int i = 0; i < ds.length; ++i) {
            ds[i] = doubleList.get(i);
        }
        return ds;
    }
}

