/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.dataholder.shovel.label;

import com.geoway.vtile.exception.ServerException;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.ScreenLoction;
import com.geoway.vtile.transform.dataholder.ExtentDataHolder;
import com.geoway.vtile.transform.dataholder.ExtentDataHolderArray;
import com.geoway.vtile.transform.dataholder.shovel.vector.ScreenLoctionVector;
import com.geoway.vtile.transform.tools.Boxset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenLoctionPolygonLabel
extends ScreenLoctionVector
implements ScreenLoction {
    Logger logger = LoggerFactory.getLogger(ScreenLoctionPolygonLabel.class);
    GeometryFactory factory = new GeometryFactory();
    Integer[] singlePolygonLabelLevel = new Integer[0];

    public ScreenLoctionPolygonLabel(Integer[] singlePolygonLabelLevel) {
        this.singlePolygonLabelLevel = singlePolygonLabelLevel;
    }

    @Override
    public void toScreenLoction(GeoBuffer geo, ExtentDataHolderArray holderArray, String[] propertyFields, Object[] propertyObject, int idIndex) {
        HashMap<String, Geometry> cacheMap = new HashMap<String, Geometry>();
        this.featrueType = geo.getGeoType();
        Geometry geometry = geo.toJTSGeometry();
        int maxLevel = holderArray.getMainHolder().getL() + holderArray.getDownLevel();
        double resolution = holderArray.getMainGridExtent().getGrid().getResolution(maxLevel);
        Point center = null;
        switch (geo.getGeoType()) {
            case POLYGON: {
                Geometry origin = geometry;
                if (geometry.getNumPoints() > 200) {
                    geometry = DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)resolution);
                }
                center = geometry.isEmpty() ? this.factory.createPoint(origin.getCoordinate()) : geometry.getInteriorPoint();
                cacheMap.put(holderArray.getMainGridExtent().getKey(), geometry);
                this.dealWithPoint(center, holderArray, holderArray.getMainHolder(), propertyFields, propertyObject, cacheMap);
                break;
            }
            case MULTIPOLYGON: {
                int geomNums = geometry.getNumGeometries();
                for (int i = 0; i < geomNums; ++i) {
                    Geometry sub = geometry.getGeometryN(i);
                    Object[] newProps = ArrayUtils.clone((Object[])propertyObject);
                    if (geomNums > 1) {
                        newProps[idIndex] = newProps[idIndex] + "" + i;
                    }
                    if (sub.getNumPoints() > 200) {
                        sub = DouglasPeuckerSimplifier.simplify((Geometry)sub, (double)resolution);
                    }
                    center = sub.isEmpty() ? this.factory.createPoint(geometry.getGeometryN(i).getCoordinate()) : sub.getInteriorPoint();
                    cacheMap.put(holderArray.getMainGridExtent().getKey(), sub);
                    this.dealWithPoint(center, holderArray, holderArray.getMainHolder(), propertyFields, propertyObject, cacheMap);
                }
                break;
            }
        }
    }

    protected void dealWithPoint(Point gcenter, ExtentDataHolderArray array, ExtentDataHolder holder, String[] propertyFields, Object[] propertyObject, Map<String, Geometry> cacheMap) {
        boolean intersects;
        if (array.isSave(holder.getLevel()).booleanValue() && !(intersects = this.dealWithPoint4Holder(gcenter, array, holder, propertyFields, propertyObject, cacheMap))) {
            return;
        }
        ExtentDataHolder[] children = holder.getChildren();
        if (children == null || children.length == 0) {
            return;
        }
        for (ExtentDataHolder child : children) {
            if (holder.isFull()) {
                child.full(true);
            }
            this.dealWithPoint(gcenter, array, child, propertyFields, propertyObject, cacheMap);
        }
    }

    protected boolean dealWithPoint4Holder(Point gcenter, ExtentDataHolderArray array, ExtentDataHolder holder, String[] propertyFields, Object[] propertyObject, Map<String, Geometry> cacheMap) {
        Geometry geometry = this.getHolderCache(cacheMap, holder);
        if (geometry == null) {
            this.logger.error("\u672a\u627e\u5230\u7236\u7f51\u683c\u5bf9\u5e94geometry : " + holder.getX() + "_" + holder.getY() + "_" + holder.getL());
            return false;
        }
        GridExtent extent = holder.getExtent();
        Envelope envelope = new Envelope(extent.getLeft(), extent.getRight(), extent.getTop(), extent.getBottom());
        if (!geometry.intersects(this.factory.toGeometry(envelope))) {
            return false;
        }
        this.getClass();
        int times = 0xA ^ array.getMainHolder().getAccuracy();
        if (array.isSave(holder.getLevel()).booleanValue()) {
            holder.beginFeature();
            double distance = 0.0;
            if (envelope.intersects(gcenter.getX(), gcenter.getY())) {
                double[] now = Boxset.createEmptyDoubleArray();
                this.toExtentCoordinate(gcenter.getX(), gcenter.getY(), extent, now, times, null);
                holder.savePoint(now[0], now[1], times);
                cacheMap.put(holder.getExtent().getKey(), geometry);
            } else if (ArrayUtils.indexOf((Object[])this.singlePolygonLabelLevel, (Object)holder.getLevel()) < 0) {
                double[] pointXY = null;
                try {
                    pointXY = this.dealOtherAreaPoint(geometry, times, holder, extent, envelope, cacheMap);
                }
                catch (ServerException message) {
                    this.logger.warn(message.getMessage() + StringUtils.join((Object[])propertyObject, (String)",") + "==>> " + holder.getX() + "_" + holder.getY() + "_" + holder.getLevel());
                }
                if (pointXY != null) {
                    Coordinate coordinate = new Coordinate(pointXY[0], pointXY[1]);
                    distance = gcenter.distance((Geometry)this.factory.createPoint(coordinate));
                } else {
                    holder.endFeature();
                    return true;
                }
            }
            Object[] newProps = ArrayUtils.addAll((Object[])propertyObject, (Object[])new Object[]{distance});
            StringBuilder sb = (StringBuilder)holder.getWriter().createPropertysPart(Constants.GEO_TYPE.POINT, propertyFields, newProps);
            holder.setPropertysPart(sb);
            holder.endFeature();
            return true;
        }
        return true;
    }

    private Geometry getHolderCache(Map<String, Geometry> cacheMap, ExtentDataHolder holder) {
        if (holder == null) {
            return null;
        }
        String key = holder.getExtent().getKey();
        Geometry geometry = cacheMap.get(key);
        if (geometry != null) {
            return geometry;
        }
        ExtentDataHolder parent = holder.getParent();
        return this.getHolderCache(cacheMap, parent);
    }

    private double[] dealOtherAreaPoint(Geometry geometry, int times, ExtentDataHolder holder, GridExtent extent, Envelope envelope, Map<String, Geometry> cacheMap) {
        double y;
        double x;
        Geometry extentGeom = this.factory.toGeometry(envelope);
        if (holder.isFull()) {
            x = envelope.getMinX() + envelope.getWidth() / 2.0;
            y = envelope.getMinY() + envelope.getHeight() / 2.0;
        } else if (this.coverBy(extentGeom, geometry)) {
            holder.full(true);
            x = envelope.getMinX() + envelope.getWidth() / 2.0;
            y = envelope.getMinY() + envelope.getHeight() / 2.0;
        } else {
            Geometry intersection;
            try {
                intersection = extentGeom.intersection(geometry);
            }
            catch (Exception e) {
                try {
                    intersection = extentGeom.intersection(GeometryFixer.fix((Geometry)geometry));
                }
                catch (Exception ex) {
                    throw new ServerException("\u9762\u72b6\u6ce8\u8bb0\u6c42\u4ea4\u96c6\u8ba1\u7b97\u51fa\u9519 : " + ex.getMessage());
                }
            }
            Point center = intersection.getInteriorPoint();
            if (!center.isEmpty()) {
                x = center.getX();
                y = center.getY();
                cacheMap.put(holder.getExtent().getKey(), intersection);
            } else {
                return null;
            }
        }
        Boxset boxset = holder.getBoxset();
        if (boxset.in(x, y)) {
            double[] now = Boxset.createEmptyDoubleArray();
            this.toExtentCoordinate(x, y, extent, now, times, null);
            holder.savePoint(now[0], now[1], times);
            return new double[]{x, y};
        }
        return null;
    }

    private boolean coverBy(Geometry extentGeom, Geometry geometry) {
        try {
            return extentGeom.coveredBy(geometry);
        }
        catch (Exception e) {
            try {
                return extentGeom.coveredBy(GeometryFixer.fix((Geometry)geometry));
            }
            catch (Exception ex) {
                throw new ServerException("\u9762\u72b6\u6ce8\u8bb0\u51e0\u4f55\u8ba1\u7b97\u9519\u8bef!");
            }
        }
    }
}

