/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell.layout;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.vtile.model.Constants;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.dataset.DataSetShell;
import com.geoway.vtile.model.vector_service.dataset.IDataSet;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.model.vector_service.layer.LayerBean;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.transform.cell.layout.ITileLayoutPrecutter;
import com.geoway.vtile.transform.cell.layout.LayerTilePrecutter;
import com.geoway.vtile.transform.cell.layout.TileLayout;
import com.geoway.vtile.transform.cell.options.TileCutOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTilePrecutter
implements ITileLayoutPrecutter<GridExtent, List<TileLayout>> {
    Logger logger = LoggerFactory.getLogger(MapTilePrecutter.class);
    private IVectorService server;
    private Map<String, LayerTilePrecutter> cellMap;
    protected ExecutorService executorService;
    private static final int TIME_OUT = 240;
    protected int down = 0;
    protected boolean isInit = false;
    protected Integer mainLevel;
    protected Integer filterLevel;
    private boolean isSameFilter = true;

    public MapTilePrecutter(IVectorService server, ExecutorService executorService) {
        this.server = server;
        this.executorService = executorService;
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        Map layerMap = this.server.getLayerMap();
        HashMap<String, LayerTilePrecutter> cellMap = new HashMap<String, LayerTilePrecutter>();
        layerMap.forEach((name, layer) -> {
            if (!this.isLayerVisible((ILayer)layer)) {
                return;
            }
            this.validateDatasetFilter((ILayer)layer);
            cellMap.put((String)name, new LayerTilePrecutter((ILayer)layer));
        });
        this.filterLevel = this.mainLevel;
        cellMap.values().forEach(cell -> {
            cell.setMainLevel(this.mainLevel);
            cell.setDown(this.down);
            cell.setFilterLevel(this.filterLevel);
            cell.setMapService(this.server);
            cell.init();
        });
        this.cellMap = cellMap;
        this.isSameFilter = !cellMap.values().stream().filter(cell -> !cell.isSameFilter()).findFirst().isPresent();
    }

    private boolean isLayerVisible(ILayer layer) {
        int start = this.mainLevel;
        int end = this.mainLevel + this.down;
        for (int i = start; i <= end; ++i) {
            Map levelMap = layer.getLevelMap();
            if (!levelMap.containsKey(i)) {
                if (layer.getBeginLevel() > end || layer.getEndLevel() < start) {
                    this.logger.info("\u56fe\u5c42 {} \u4e0d\u5728\u74e6\u7247\u9884\u70ed\u5c42\u7ea7\u8303\u56f4 {}~{} \u5185", new Object[]{layer.getId(), start, end});
                    return false;
                }
                return true;
            }
            String currLevelFilter = ((ILayerLevel)layer.getLevelMap().get(i)).getFilterExpression();
            if ("1 = 2".equals(currLevelFilter)) continue;
            return true;
        }
        return false;
    }

    private void validateDatasetFilter(ILayer layer) {
        try {
            ILayerLevel layerLevel = (ILayerLevel)layer.getLevelMap().get(this.mainLevel);
            IDataSet datset = layerLevel.getDataSet();
            String dsFilter = datset.getFilter();
            if (StringUtils.isNotEmpty((CharSequence)dsFilter) && dsFilter.contains("\"")) {
                dsFilter = dsFilter.replace("\"", "'");
                ((DataSetShell)datset).getDataSet().setFilter(dsFilter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<TileLayout> cut(GridExtent extent, TileCutOptions options) throws Exception {
        String extraSqlFilter = options.getExtraSqlFilter();
        HashMap filter = extraSqlFilter != null ? (HashMap)JSON.parseObject((String)extraSqlFilter, (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]) : null;
        if (this.isCancel()) {
            return null;
        }
        Integer level = extent.getLevel();
        Stream stream = this.server.getLayerMap().entrySet().stream();
        ArrayList layerList = new ArrayList();
        CompletableFuture[] promiseArr = (CompletableFuture[])stream.filter(entry -> {
            if (filter == null) {
                return true;
            }
            String layerKey = (String)entry.getKey();
            return filter.get(layerKey) != null;
        }).map(entry -> {
            ILayer layer = (ILayer)entry.getValue();
            String layerKey = (String)entry.getKey();
            if (this.mainLevel + this.down < layer.getBeginLevel()) {
                return null;
            }
            String filterStrForLayer = null;
            if (filter != null && "all".equalsIgnoreCase(filterStrForLayer = (String)filter.get(layerKey))) {
                filterStrForLayer = null;
            }
            TileCutOptions layerOptions = options.clone();
            layerOptions.setExtraSqlFilter(filterStrForLayer);
            CompletableFuture<Object[]> promise = this.cutLayer(extent, layer, layerOptions);
            return promise;
        }).filter(p -> p != null).toArray(CompletableFuture[]::new);
        if (promiseArr.length == 0) {
            return null;
        }
        CompletableFuture.allOf(promiseArr);
        CompletableFuture<List> allData = CompletableFuture.supplyAsync(() -> {
            TileLayout result = this.dataUnion(promiseArr, extent);
            if (result != null) {
                result.setFilterLevel(this.filterLevel);
                ArrayList<TileLayout> list = new ArrayList<TileLayout>(1);
                list.add(result);
                return list;
            }
            return null;
        });
        allData.exceptionally(e -> {
            throw new RuntimeException();
        });
        allData.join();
        return allData.get();
    }

    protected CompletableFuture<Object[]> cutLayer(GridExtent extent, ILayer layer, TileCutOptions options) {
        LayerTilePrecutter layerCell = this.cellMap.get(layer.getId());
        CompletableFuture<Object[]> promise = CompletableFuture.supplyAsync(() -> {
            List<GridExtent> layerExtent = null;
            try {
                this.logger.debug(layer.getId() + ": start");
                layerExtent = layerCell.cut(extent, options);
                this.logger.debug(layer.getId() + ": end");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return new Object[]{layer, layerExtent};
        }, this.executorService);
        return promise;
    }

    protected TileLayout dataUnion(CompletableFuture<Object[]>[] promiseArr, GridExtent extent) {
        HashMap<String, String> layersMap = new HashMap<String, String>(promiseArr.length);
        for (int i = 0; i < promiseArr.length; ++i) {
            Object[] o = null;
            try {
                if (this.isCancel()) {
                    return null;
                }
                o = promiseArr[i].get(240L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
                this.logger.error("\u670d\u52a1:" + (String)this.server.getId() + "\u683c\u7f51\u53f7" + extent.toString() + "\u8bf7\u6c42\u8d85\u65f6");
                o = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (o == null) continue;
            ILayer layer = (ILayer)o[0];
            if (o[1] == null) continue;
            layersMap.put(layer.getId(), "all");
            if (layer.getLabel() == null || layer.getLabel().getType() == Constants.LABEL_TYPE.point) continue;
            layersMap.put(layer.getId() + LayerBean.LABEL_SUFFIX, "all");
        }
        String layerStr = null;
        if (layersMap.isEmpty()) {
            return null;
        }
        layerStr = JSON.toJSONString(layersMap);
        return new TileLayout(extent, layerStr);
    }

    protected CompletableFuture<String> getEmptyPromise() {
        CompletableFuture<String> promise = CompletableFuture.supplyAsync(() -> null);
        return promise;
    }

    @Override
    public void setDown(int down) {
        this.down = down;
    }

    @Override
    public void setMainLevel(Integer mainLevel) {
        this.mainLevel = mainLevel;
    }

    @Override
    public void cancel() {
    }

    @Override
    public boolean isCancel() {
        return false;
    }

    @Override
    public Integer getDown() {
        return this.down;
    }

    @Override
    public void setFilterLevel(Integer filterLevel) {
    }

    @Override
    public Integer getFilterLevel() {
        return this.filterLevel;
    }

    @Override
    public boolean isSameFilter() {
        return this.isSameFilter;
    }
}

