/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.writer;

import com.geoway.vtile.exception.ServerException;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.transform.tools.PropertyUtil;
import com.geoway.vtile.transform.writer.VarintWriter;
import com.geoway.vtile.transform.writer.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.xerial.snappy.Snappy;

public class VarintFeatureWriter
extends VarintWriter
implements Writer {
    private static byte[] spacingBytes;
    private static byte[] headerArr;
    private static Properties pro;
    List<String> props = new ArrayList<String>();
    byte[] coodinateByteArr;
    int size;

    @Override
    public void endTile() {
        this.coordinatesBuffer.flip();
        this.coodinateByteArr = this.coordinatesBuffer.getByteArray();
        this.coordinatesBuffer = null;
    }

    @Override
    public void setPropertysPart(Object part) {
        Object[] propsArr = (Object[])part;
        int len = propsArr.length;
        for (int i = 0; i < len; ++i) {
            this.props.add(propsArr[i].toString());
        }
        ++this.size;
    }

    @Override
    public Object createPropertysPart(Constants.GEO_TYPE geoType, String[] propertyFields, Object[] propertyObject) {
        this.geoType = geoType;
        return propertyObject;
    }

    public Object[] getFeatures(int index) {
        int fieldsNum = this.props.size() / this.size();
        String[] props = new String[fieldsNum];
        for (int i = 0; i < fieldsNum; ++i) {
            props[i] = this.props.get(index * fieldsNum + i);
        }
        int offset = this.offsetIndex.get(index * 2);
        int length = this.offsetIndex.get(index * 2 + 1);
        ByteBuffer coordinateBuf = ByteBuffer.wrap(this.coodinateByteArr, offset, length);
        return new Object[]{props, coordinateBuf};
    }

    @Override
    public byte[] getData() {
        try {
            if (this.props.size() == 0) {
                return new byte[0];
            }
            ByteBuffer offsetIndexBuffer = this.getOffsetByte();
            offsetIndexBuffer.flip();
            String feature = StringUtils.join(this.props, (String)featureSpace);
            byte[] snappyBytes = Snappy.compress((byte[])feature.getBytes(encoding));
            int featureLength = snappyBytes.length;
            String headPro = "gType:" + this.geoType.name();
            byte[] headProByte = Snappy.compress((byte[])headPro.getBytes(encoding));
            int indexLength = offsetIndexBuffer.limit();
            int total = 12 + headerArr.length + headProByte.length + snappyBytes.length + offsetIndexBuffer.limit() + this.coodinateByteArr.length;
            ByteBuffer layerBuffer = ByteBuffer.allocate(total);
            layerBuffer.put(headerArr);
            layerBuffer.putInt(headProByte.length);
            layerBuffer.put(headProByte);
            layerBuffer.putInt(featureLength);
            layerBuffer.put(snappyBytes);
            layerBuffer.putInt(indexLength);
            layerBuffer.put(offsetIndexBuffer);
            layerBuffer.put(this.coodinateByteArr);
            layerBuffer.flip();
            return layerBuffer.array();
        }
        catch (Exception e) {
            throw new ServerException(e.getMessage());
        }
    }

    public int size() {
        return this.size;
    }

    public static void main(String[] args) {
        String a = "aa#@bb#@cc";
        a.split("#@");
    }

    static {
        pro = PropertyUtil.readProperties("conf/varint.properties");
        String[] spacingArr = pro.getProperty("spacingArr").split(",");
        spacingBytes = new byte[spacingArr.length];
        for (int i = 0; i < spacingArr.length; ++i) {
            VarintFeatureWriter.spacingBytes[i] = Byte.valueOf(spacingArr[i]);
        }
        int headerSize = Integer.valueOf(pro.getProperty("headerSize"));
        headerArr = new byte[headerSize];
        Random random = new Random();
        for (int i = 0; i < headerSize; ++i) {
            VarintFeatureWriter.headerArr[i] = Byte.valueOf(random.nextInt(70) + 1 + "");
        }
    }
}

