/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.tools.varint;

import com.geoway.vtile.transform.tools.DynamicByteBuffer;
import com.geoway.vtile.transform.tools.varint.EncodingVarint;
import com.geoway.vtile.transform.tools.varint.model.LayerContentModel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xerial.snappy.Snappy;

public class VarintBuilder {
    private int headerLength;
    private static String vectorName = "vector";
    private static String encoding = "utf8";
    private static String space = "#@";
    private Map<String, ByteBuffer> layerMap;

    public VarintBuilder(int headerLength) {
        this.headerLength = headerLength;
        this.layerMap = new LinkedHashMap<String, ByteBuffer>();
    }

    public void addLayerBuffer(String layerName, ByteBuffer layerVarintBuffer) {
        if (layerVarintBuffer == null || layerVarintBuffer.limit() == 0) {
            return;
        }
        this.layerMap.put(layerName, layerVarintBuffer);
    }

    public void addLayerByLayerContentModel(String layerName, LayerContentModel layerContentModel) throws IOException {
        ByteBuffer headerProBuffer = layerContentModel.getLayerHeaderProBuffer();
        List<String[]> featureBufferArray = layerContentModel.getFeatureArray();
        List<byte[]> coordinateBufferArray = layerContentModel.getCoordinateBufferArray();
        ByteBuffer coordinateOffsetBuffer = this._buildIndexBuffer(coordinateBufferArray);
        ByteBuffer coordinateBuffer = this.byteListConcat(coordinateBufferArray);
        ByteBuffer layerVarintBuffer = this._builderLayerBuffer(layerName, headerProBuffer, featureBufferArray, coordinateOffsetBuffer, coordinateBuffer);
        this.layerMap.put(layerName, layerVarintBuffer);
    }

    public void removeLayer(String layerName) {
        this.layerMap.remove(layerName);
    }

    public ByteBuffer getVectorBuffer() throws Exception {
        if (this.layerMap.isEmpty()) {
            return null;
        }
        DynamicByteBuffer layerData = new DynamicByteBuffer();
        DynamicByteBuffer indexBuf = new DynamicByteBuffer();
        for (String layerName : this.layerMap.keySet()) {
            ByteBuffer layerBuf = this.layerMap.get(layerName);
            byte[] layerNameBytes = layerName.getBytes(encoding);
            indexBuf.putInt(layerNameBytes.length);
            indexBuf.put(layerNameBytes);
            indexBuf.putInt(layerBuf.limit());
            layerData.put(layerBuf);
        }
        indexBuf.flip();
        layerData.flip();
        DynamicByteBuffer vectorbuffer = new DynamicByteBuffer();
        byte[] typeByte = vectorName.getBytes(encoding);
        vectorbuffer.put(this.getHeaderArray(this.headerLength));
        vectorbuffer.putInt(typeByte.length);
        vectorbuffer.put(typeByte);
        vectorbuffer.putInt(0);
        vectorbuffer.putInt(indexBuf.limit());
        vectorbuffer.put(indexBuf);
        vectorbuffer.put(layerData);
        vectorbuffer.flip();
        return vectorbuffer.getBuffer();
    }

    private ByteBuffer _builderLayerBuffer(String layerName, ByteBuffer headerProBuffer, List<String[]> featureArray, ByteBuffer coordinateOffsetBuffer, ByteBuffer coordinateBuffer) throws IOException {
        int headerProLength = headerProBuffer.limit();
        StringBuffer featureStr = new StringBuffer();
        for (String[] features : featureArray) {
            for (String feature : features) {
                featureStr.append(feature).append(space);
            }
        }
        byte[] featureBytes = Snappy.compress((String)featureStr.toString());
        int featureLength = featureBytes.length;
        int offsetLength = coordinateOffsetBuffer.limit();
        DynamicByteBuffer buffer = new DynamicByteBuffer();
        buffer.put(this.getHeaderArray(this.headerLength));
        buffer.putInt(headerProLength);
        buffer.put(headerProBuffer);
        buffer.putInt(featureLength);
        buffer.put(featureBytes);
        buffer.putInt(offsetLength);
        buffer.put(coordinateOffsetBuffer);
        buffer.put(coordinateBuffer);
        buffer.flip();
        return buffer.getBuffer();
    }

    private ByteBuffer _buildIndexBuffer(List<byte[]> bufferArray) {
        DynamicByteBuffer buffer = new DynamicByteBuffer();
        int offset = 0;
        int length = 0;
        for (int i = 0; i < bufferArray.size(); ++i) {
            length = bufferArray.get(i).length;
            buffer.put(EncodingVarint.int2Variant(offset));
            buffer.put(EncodingVarint.int2Variant(length));
            offset += length;
        }
        buffer.flip();
        return buffer.getBuffer();
    }

    private ByteBuffer byteListConcat(List<byte[]> list) {
        DynamicByteBuffer buffer = new DynamicByteBuffer();
        for (byte[] bs : list) {
            buffer.put(bs);
        }
        buffer.flip();
        return buffer.getBuffer();
    }

    private byte[] getHeaderArray(int headerLength) {
        byte[] harr = new byte[headerLength];
        for (int i = 0; i < headerLength; ++i) {
            harr[i] = (byte)this._getRandomNum();
        }
        return harr;
    }

    private int _getRandomNum() {
        int Range = 80;
        double Rand = Math.random();
        return (int)(50L + Math.round(Rand * (double)Range));
    }
}

