/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.cell.process;

import com.alibaba.druid.support.json.JSONUtils;
import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.model.data_service.DataServiceAdvancedOptions;
import com.geoway.vtile.model.data_service.DataServiceBean;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.spatial.Geom;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.transform.ScreenLoction;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.process.AbstractProcesser;
import com.geoway.vtile.transform.cell.process.IProcesser;
import com.geoway.vtile.transform.dataholder.ExtentDataHolderArray;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutTileProcesser
extends AbstractProcesser<GeoBuffer>
implements IProcesser<GeoBuffer> {
    private static Logger logger = LoggerFactory.getLogger(CutTileProcesser.class);
    ExtentDataHolderArray extentDataHolderArray;
    ScreenLoction screenLoction;
    private final Map<Integer, ILayerLevel> layerLevelMap;

    public CutTileProcesser(ITileCutterCell cell, ILayer layer, ExtentDataHolderArray dataHolderArray, ScreenLoction screenLoction) {
        super(cell, layer);
        this.extentDataHolderArray = dataHolderArray;
        this.screenLoction = screenLoction;
        this.layerLevelMap = layer.getLevelMap();
    }

    @Override
    public void process(List<Object[]> dataArr, String[] propertyFields, int idIndex, int spatialIndex) {
        propertyFields = (String[])ArrayUtils.remove((Object[])propertyFields, (int)spatialIndex);
        for (Object[] data : dataArr) {
            if (this.cell.isCancel()) {
                return;
            }
            GeoBuffer geo = ((Geom)data[spatialIndex]).toGeoBuffer();
            data = ArrayUtils.remove((Object[])data, (int)spatialIndex);
            Map<Integer, Boolean> saveMap = this.createSaveMap(propertyFields, data);
            Map<Integer, Double> simplifyMap = this.createSimplifyMap();
            Map<Integer, Boolean> ignoreOnePointFeatureMap = this.createIgnoreOnePointFeatureMap();
            this.extentDataHolderArray.setSaveMap(saveMap);
            this.extentDataHolderArray.setSimplifyMap(simplifyMap);
            this.extentDataHolderArray.setIgnoreOnePointFeatureMap(ignoreOnePointFeatureMap);
            if (!this.layer.getCutOutScreen().booleanValue()) {
                this.extentDataHolderArray.setCutOutScreen(false);
            }
            try {
                this.screenLoction.toScreenLoction(geo, this.extentDataHolderArray, propertyFields, data, idIndex);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (GlobalTileSettings.SHOW_ERROR_DATA) {
                    logger.error("\u6570\u636e\u5f02\u5e38\uff1a{}, id:{}, \u6570\u636e\u8be6\u60c5\uff1a\n{} {}", new Object[]{e.getMessage(), data[idIndex], JSONUtils.toJSONString((Object)data), geo.toWkt()});
                }
                throw e;
            }
            this.extentDataHolderArray.next();
        }
    }

    private Map<Integer, Boolean> createSaveMap(String[] fieleNames, Object[] data) {
        HashMap<Integer, Boolean> saveMap = new HashMap<Integer, Boolean>();
        int beginLevel = this.extentDataHolderArray.getMainHolder().getLevel();
        int endLevel = beginLevel + this.cell.getDown();
        ILayerLevel layerLevel = null;
        for (int i = beginLevel; i <= endLevel; ++i) {
            Boolean save;
            layerLevel = this.layerLevelMap.get(i);
            if (layerLevel == null) {
                saveMap.put(i, false);
                continue;
            }
            try {
                save = layerLevel.isFeatureSave(fieleNames, data);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            saveMap.put(i, save);
        }
        return saveMap;
    }

    private Map<Integer, Double> createSimplifyMap() {
        HashMap<Integer, Double> simplifyMap = new HashMap<Integer, Double>();
        int beginLevel = this.extentDataHolderArray.getMainHolder().getLevel();
        int endLevel = beginLevel + this.cell.getDown();
        ILayerLevel layerLevel = null;
        for (int i = beginLevel; i <= endLevel; ++i) {
            layerLevel = this.layerLevelMap.get(i);
            if (layerLevel == null) continue;
            DataServiceAdvancedOptions advancedOptions = ((DataServiceBean)layerLevel.getDataSet().getDataService().getBean()).getAdvancedOptions();
            simplifyMap.put(i, advancedOptions.getSimplify());
        }
        return simplifyMap;
    }

    private Map<Integer, Boolean> createIgnoreOnePointFeatureMap() {
        HashMap<Integer, Boolean> ignoreOnePointFeatureMap = new HashMap<Integer, Boolean>();
        int beginLevel = this.extentDataHolderArray.getMainHolder().getLevel();
        int endLevel = beginLevel + this.cell.getDown();
        ILayerLevel layerLevel = null;
        for (int i = beginLevel; i <= endLevel; ++i) {
            layerLevel = this.layerLevelMap.get(i);
            if (layerLevel == null) continue;
            DataServiceAdvancedOptions advancedOptions = ((DataServiceBean)layerLevel.getDataSet().getDataService().getBean()).getAdvancedOptions();
            ignoreOnePointFeatureMap.put(i, advancedOptions.isIgnoreOnePointFeature());
        }
        return ignoreOnePointFeatureMap;
    }
}

