/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.transform.tools;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class CTerranArea {
    private static final BigDecimal bRadius = BigDecimal.valueOf(6356752.31414036);
    private static final BigDecimal ParaE1 = BigDecimal.valueOf(0.0066943800229);
    private static final BigDecimal ParaE2 = ParaE1.multiply(ParaE1);
    private static final BigDecimal ParaE3 = ParaE2.multiply(ParaE1);
    private static final BigDecimal ParaE4 = ParaE3.multiply(ParaE1);
    private static final BigDecimal BIGDEC_0p01953125 = BigDecimal.valueOf(0.01953125);
    private static final BigDecimal BIGDEC_0p0375 = BigDecimal.valueOf(0.0375);
    private static final BigDecimal BIGDEC_0p0625 = BigDecimal.valueOf(0.0625);
    private static final BigDecimal BIGDEC_0p078125 = BigDecimal.valueOf(0.078125);
    private static final BigDecimal BIGDEC_0p1875 = BigDecimal.valueOf(0.1875);
    private static final BigDecimal BIGDEC_0p2734375 = BigDecimal.valueOf(0.2734375);
    private static final BigDecimal BIGDEC_0p3125 = BigDecimal.valueOf(0.3125);
    private static final BigDecimal BIGDEC_0p375 = BigDecimal.valueOf(0.375);
    private static final BigDecimal BIGDEC_0p5 = BigDecimal.valueOf(0.5);
    private static final BigDecimal BIGDEC_0 = BigDecimal.valueOf(0L);
    private static final BigDecimal BIGDEC_1 = BigDecimal.valueOf(1L);
    private static final BigDecimal BIGDEC_2 = BigDecimal.valueOf(2L);
    private static final BigDecimal BIGDEC_3 = BigDecimal.valueOf(3L);
    private static final BigDecimal BIGDEC_5 = BigDecimal.valueOf(5L);
    private static final BigDecimal BIGDEC_6 = BigDecimal.valueOf(6L);
    private static final BigDecimal BIGDEC_7 = BigDecimal.valueOf(7L);
    private static final BigDecimal BIGDEC_9 = BigDecimal.valueOf(9L);
    private static final BigDecimal BIGDEC_112 = BigDecimal.valueOf(112L);
    private static final BigDecimal BIGDEC_420 = BigDecimal.valueOf(420L);
    private static final BigDecimal BIGDEC_2304 = BigDecimal.valueOf(2304L);
    private static final BigDecimal BIGDEC_3600 = BigDecimal.valueOf(3600L);
    private static final BigDecimal RHO = BigDecimal.valueOf(206264.8062471);
    private static final int SCALE16 = 16;
    private static final int SCALE6 = 6;
    private static final BigDecimal ParamA = BIGDEC_1.add(BIGDEC_0p5.multiply(ParaE1)).add(BIGDEC_0p375.multiply(ParaE2)).add(BIGDEC_0p3125.multiply(ParaE3)).add(BIGDEC_0p2734375.multiply(ParaE4));
    private static final BigDecimal ParamB = BIGDEC_1.divide(BIGDEC_6, 16, RoundingMode.HALF_UP).multiply(ParaE1).add(BIGDEC_0p1875.multiply(ParaE2)).add(BIGDEC_0p1875.multiply(ParaE3)).add(BIGDEC_420.divide(BIGDEC_2304, 16, RoundingMode.HALF_UP).multiply(ParaE4));
    private static final BigDecimal ParamC = BIGDEC_0p0375.multiply(ParaE2).add(BIGDEC_0p0625.multiply(ParaE3)).add(BIGDEC_0p078125.multiply(ParaE4));
    private static final BigDecimal ParamD = BIGDEC_1.divide(BIGDEC_112, 16, RoundingMode.HALF_UP).multiply(ParaE3).add(BIGDEC_0p01953125.multiply(ParaE4));
    private static final BigDecimal ParamE = BIGDEC_5.divide(BIGDEC_2304, 16, RoundingMode.HALF_UP).multiply(ParaE4);

    public static double CalculateTerranArea(Geometry geom) {
        String type = geom.getGeometryType();
        if ("Polygon".equals(type)) {
            return CTerranArea.CalculatePolygon(geom);
        }
        if ("MultiPolygon".equals(type)) {
            return CTerranArea.CalculateMultiPolygon(geom);
        }
        return 0.0;
    }

    private static double CalculatePolygon(Geometry geom) {
        Polygon geomPoly = (Polygon)geom;
        LinearRing exterRing = geomPoly.getExteriorRing();
        double area = CTerranArea.CalcEllipseAreaInSystem2000((Geometry)exterRing).abs().doubleValue();
        double holesArea = 0.0;
        int nCount = geomPoly.getNumInteriorRing();
        for (int i = 0; i < nCount; ++i) {
            LinearRing g = geomPoly.getInteriorRingN(i);
            holesArea += CTerranArea.CalcEllipseAreaInSystem2000((Geometry)g).abs().doubleValue();
        }
        return Math.abs(area - holesArea);
    }

    private static double CalculateMultiPolygon(Geometry geom) {
        MultiPolygon geomMultiPoly = (MultiPolygon)geom;
        int numGeoms = geomMultiPoly.getNumGeometries();
        double area = 0.0;
        for (int i = 0; i < numGeoms; ++i) {
            Geometry g = geomMultiPoly.getGeometryN(i);
            area += CTerranArea.CalculatePolygon(g);
        }
        return area;
    }

    private static BigDecimal CalcEllipseAreaInSystem2000(Geometry geom) {
        BigDecimal areaSum = BIGDEC_0;
        Coordinate[] points = geom.getCoordinates();
        int nCount = points.length;
        BigDecimal[] ItemValue = new BigDecimal[5];
        for (int i = 0; i < nCount - 1; ++i) {
            BigDecimal B = CTerranArea.ComputeXYGeo(BigDecimal.valueOf(points[i].y));
            BigDecimal L = CTerranArea.ComputeXYGeo(BigDecimal.valueOf(points[i].x));
            BigDecimal B1 = CTerranArea.ComputeXYGeo(BigDecimal.valueOf(points[i + 1].y));
            BigDecimal L1 = CTerranArea.ComputeXYGeo(BigDecimal.valueOf(points[i + 1].x));
            B = B.divide(RHO, 16, RoundingMode.HALF_UP);
            L = L.divide(RHO, 16, RoundingMode.HALF_UP);
            B1 = B1.divide(RHO, 16, RoundingMode.HALF_UP);
            L1 = L1.divide(RHO, 16, RoundingMode.HALF_UP);
            BigDecimal bDifference = B1.subtract(B).divide(BIGDEC_2, 16, RoundingMode.HALF_UP);
            BigDecimal bSum = B1.add(B).divide(BIGDEC_2, 16, RoundingMode.HALF_UP);
            BigDecimal lDifference = L1.add(L).divide(BIGDEC_2, 16, RoundingMode.HALF_UP);
            BigDecimal RadDiffVal = bRadius.multiply(lDifference).multiply(bRadius).multiply(BIGDEC_2);
            ItemValue[0] = ParamA.multiply(BigDecimal.valueOf(Math.sin(bDifference.doubleValue()))).multiply(BigDecimal.valueOf(Math.cos(bSum.doubleValue())));
            ItemValue[1] = ParamB.multiply(BigDecimal.valueOf(Math.sin(bDifference.multiply(BIGDEC_3).doubleValue()))).multiply(BigDecimal.valueOf(Math.cos(bSum.multiply(BIGDEC_3).doubleValue())));
            ItemValue[2] = ParamC.multiply(BigDecimal.valueOf(Math.sin(bDifference.multiply(BIGDEC_5).doubleValue()))).multiply(BigDecimal.valueOf(Math.cos(bSum.multiply(BIGDEC_5).doubleValue())));
            ItemValue[3] = ParamD.multiply(BigDecimal.valueOf(Math.sin(bDifference.multiply(BIGDEC_7).doubleValue()))).multiply(BigDecimal.valueOf(Math.cos(bSum.multiply(BIGDEC_7).doubleValue())));
            ItemValue[4] = ParamE.multiply(BigDecimal.valueOf(Math.sin(bDifference.multiply(BIGDEC_9).doubleValue()))).multiply(BigDecimal.valueOf(Math.cos(bSum.multiply(BIGDEC_9).doubleValue())));
            BigDecimal AreaVal = RadDiffVal.multiply(ItemValue[0].subtract(ItemValue[1]).add(ItemValue[2]).subtract(ItemValue[3]).add(ItemValue[4]));
            areaSum = areaSum.add(AreaVal);
        }
        return areaSum;
    }

    private static BigDecimal ComputeXYGeo(BigDecimal degree) {
        BigDecimal b = degree.multiply(BIGDEC_3600);
        BigDecimal second = b.setScale(6, RoundingMode.HALF_UP);
        return second;
    }
}

