/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.worker;

import com.alibaba.fastjson.JSONObject;
import com.geoway.atlas.license.authorize.LicenseCheck;
import com.geoway.vtile.cluster.sched.TaskClient;
import com.geoway.vtile.commons.concurrent.BlockThreadPool;
import com.geoway.vtile.commons.conf.GlobalTileSettings;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.tools.net.LocalIpAddressUtil;
import com.geoway.vtile.worker.conf.VTileConfig;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.util.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class VTileWorker {
    private static Logger Log = LoggerFactory.getLogger(VTileWorker.class);
    private static VTileConfig config;
    private static Client client;
    private static String ipAddr;

    public static void main(String[] args) {
        try {
            Log.info("vtile-worker \u6b63\u5728\u542f\u52a8 ...");
            VTileWorker.setUp(args);
            VTileWorker.runTaskClient();
        }
        catch (Exception e) {
            Log.error(e.getMessage());
            e.printStackTrace();
        }
        Log.info("vtile-worker \u5373\u5c06\u9000\u51fa\n");
    }

    private static void test() {
        block3: {
            Integer HALF_CORES_NUM = Runtime.getRuntime().availableProcessors() / 2;
            BlockThreadPool thpool = new BlockThreadPool(HALF_CORES_NUM.intValue(), 1);
            int i = 0;
            while (i < 1000) {
                int localX = i++;
                Log.info("\u5373\u5c06\u63d0\u4ea4\u4efb\u52a1\uff1a" + localX);
                CompletableFuture.runAsync(() -> {
                    int curr = localX;
                    Log.info("\u5904\u7406\u5f53\u4e2d\uff1a " + curr);
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }, (Executor)thpool);
            }
            CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                System.out.println("\u6211\u8fd0\u884c\u7684\u4efb\u52a1\u8fd8\u5728\u8dd1\u3002\u3002");
                return "Task Result";
            });
            try {
                String result = future.get(1L, TimeUnit.SECONDS);
                System.out.println("Task result: " + result);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                e.printStackTrace();
                if (!(e instanceof TimeoutException)) break block3;
                System.out.println("Task timed out.");
            }
        }
    }

    private static void setUp(String[] args) throws Exception {
        GlobalTileSettings.bAccurateCut = false;
        GlobalTileSettings.bAccurateIntersect = false;
        GlobalTileSettings.SHOW_ERROR_DATA = true;
        VTileWorker.loadConfig(args);
        Log4jUtil.enableDiagnose((boolean)config.isEnableDiagnoseLog());
        int cutThreads = config.getCutThreadsCount();
        if (cutThreads > 0) {
            Log.info("\u6307\u5b9a\u9884\u70ed\u7ebf\u7a0b\u6570\uff1a" + cutThreads);
            TileDispatchTaskManager.CUSTOM_THREAD_COUNT = cutThreads;
        }
        VTileWorker.checkLicense();
        client = Client.create((String)config.getBuziDBUrl(), (String)config.getRedisUrl(), (String)config.getMapserverUrl());
    }

    private static void loadConfig(String[] args) {
        String yamlFile = 0 == args.length ? "../application.yml" : args[0];
        try (FileInputStream in = new FileInputStream(yamlFile);){
            Yaml yaml = new Yaml();
            Map configMap = (Map)yaml.load((InputStream)in);
            if (null == configMap) {
                throw new RuntimeException("\u914d\u7f6e\u6587\u4ef6\u9519\u8bef");
            }
            Map commonMap = (Map)configMap.get("project");
            if (null == commonMap) {
                throw new RuntimeException("\u914d\u7f6e\u4e0d\u5168");
            }
            config = new VTileConfig();
            try {
                Map dsmap = (Map)((Map)configMap.get("spring")).get("datasource");
                String url = (String)dsmap.get("url");
                String username = (String)dsmap.get("username");
                String password = (String)dsmap.get("password");
                int index = url.indexOf("://") + 3;
                String pgUrl = url.substring(0, index) + username + ":" + password + "@" + url.substring(index);
                config.setBuziDBUrl(pgUrl);
            }
            catch (Exception ex) {
                throw new RuntimeException("\u89e3\u6790pg\u4e1a\u52a1\u5e93\u914d\u7f6e\u51fa\u9519:" + ex.getMessage(), ex);
            }
            config.setRedisUrl((String)((Map)configMap.get("redis")).get("uri"));
            config.setMapserverUrl((String)((Map)configMap.get("mapserver")).get("url"));
            if (null != commonMap.get("diagnoseLog")) {
                config.setEnableDiagnoseLog((Boolean)commonMap.get("diagnoseLog"));
            }
            if (null != commonMap.get("checkLicense")) {
                config.setCheckLicense((Boolean)commonMap.get("checkLicense"));
            }
            if (null != commonMap.get("cutThreadCount")) {
                config.setCutThreadsCount((Integer)commonMap.get("cutThreadCount"));
            }
            System.out.println(JSONObject.toJSONString((Object)config));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String host = NetUtils.getLocalHostname();
            List localIps = LocalIpAddressUtil.getLocalIP();
            ipAddr = StringUtils.join((Iterable)localIps, (String)"|");
            Log.info("\u5f53\u524d\u8282\u70b9\uff1a" + host + ", IP:" + (String)localIps.get(0));
        }
        catch (Exception ex) {
            Log.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private static void checkLicense() {
        boolean isCheckLic = config.isCheckLicense();
        if (isCheckLic) {
            Log.info("\u68c0\u67e5\u7f51\u7edc\u9501\u3002\u3002\u3002");
            boolean checkResult = LicenseCheck.isValid((int)64809);
            if (!checkResult) {
                Log.error("\u8bb8\u53ef\u8bc1\u4e0d\u53ef\u7528, \u7a0b\u5e8f\u5df2\u5173\u95ed\u3002\u3002\u3002");
                System.exit(0);
            } else {
                Log.info("\u8bb8\u53ef\u8bc1\u53ef\u7528");
            }
        } else {
            Log.info("\u672a\u68c0\u67e5\u7f51\u7edc\u6388\u6743");
        }
    }

    private static void runTaskClient() {
        Log.info("\u542f\u52a8\u5ba2\u6237\u7aef Worker \u8282\u70b9");
        TaskClient taskCli = new TaskClient(client);
        taskCli.setWorkerIps(ipAddr);
        taskCli.start();
    }
}

