/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onecode.api.action;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.common.web.ResponsePage;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.onecode.api.dto.DltbThroughResultDTO;
import com.geoway.onecode.api.dto.EntityDTO;
import com.geoway.onecode.api.dto.EntityFilterDTO;
import com.geoway.onecode.api.dto.EntitySpatialFilterDTO;
import com.geoway.onecode.api.dto.RelateFileDTO;
import com.geoway.onecode.api.dto.TbDTO;
import com.geoway.onecode.api.service.OneCodeQueryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
@Api(tags={"\u5b9e\u4f53\u67e5\u8be2"})
public class EntityQueryController {
    @Resource
    private OneCodeQueryService oneCodeQueryService;

    @ApiOperation(value="01-\u5b9e\u4f53\u67e5\u8be2")
    @PostMapping(value={"/entitys/query"})
    public ResponsePage<EntityDTO> entityQuery(@RequestBody EntityFilterDTO filter) {
        return ResponsePage.ok(this.oneCodeQueryService.queryEntitys(filter));
    }

    @ApiOperation(value="02-\u5b9e\u4f53\u7a7a\u95f4\u67e5\u8be2")
    @PostMapping(value={"/entitys/spatialQuery"})
    public ResponsePage<EntityDTO> spatialQuery(@RequestBody EntitySpatialFilterDTO filter) {
        return ResponsePage.ok(this.oneCodeQueryService.queryEntitys(filter));
    }

    @ApiOperation(value="03-\u5730\u7c7b\u56fe\u6591\u8d2f\u901a\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dltbID", value="\u56fe\u6591id")})
    @GetMapping(value={"/dltb/throughQuery"})
    public Response<DltbThroughResultDTO> queryDLTBThrough(@RequestParam String dltbID) {
        return Response.ok((Object)this.oneCodeQueryService.queryDLTBThrough(dltbID));
    }

    @ApiOperation(value="04-\u56fe\u6591\u5c5e\u6027\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tbID", value="\u56fe\u6591id"), @ApiImplicitParam(name="returnGeometry", value="\u662f\u5426\u8fd4\u56de\u56fe\u6591\u8303\u56f4")})
    @GetMapping(value={"/dltb/att"})
    public Response<DataQueryResult> queryDLTBAttribute(@RequestParam String tbID, @RequestParam(required=false, defaultValue="true") Boolean returnGeometry) {
        return Response.ok((Object)this.oneCodeQueryService.queryDLTBAttribute(tbID, returnGeometry));
    }

    @ApiOperation(value="05-\u4e1a\u52a1\u56fe\u6591\u5173\u8054\u9644\u4ef6\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tbID", value="\u56fe\u6591id")})
    @GetMapping(value={"/dltb/attachment"})
    public Response<List<RelateFileDTO>> queryTBAttachments(@RequestParam String tbID) {
        return Response.ok(this.oneCodeQueryService.queryTBAttachments(tbID));
    }

    @ApiOperation(value="06-\u4e1a\u52a1\u56fe\u6591\u5173\u8054\u9644\u4ef6\u9884\u89c8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tbID", value="\u56fe\u6591id"), @ApiImplicitParam(name="filePath", value="\u9644\u4ef6\u8def\u5f84")})
    @GetMapping(value={"/dltb/attachment/preview"})
    public void previewTBAttachment(String tbID, String filePath, HttpServletRequest request, HttpServletResponse response) {
        this.oneCodeQueryService.previewTBAttachment(tbID, filePath, request, response);
    }

    @ApiOperation(value="07-\u5730\u7c7b\u56fe\u6591\u4e13\u9879\u6570\u636e\u67e5\u8be2")
    @ApiImplicitParam(name="dltbID", value="\u56fe\u6591id")
    @GetMapping(value={"/dltb/specialData"})
    public Response<List<DataQueryResult>> queryDLTBSpecialData(@RequestParam String dltbID) {
        return Response.ok(this.oneCodeQueryService.queryDLTBSpecialData(dltbID));
    }

    @ApiOperation(value="08-\u5916\u4e1a\u6838\u67e5\u6570\u636e\u67e5\u8be2")
    @ApiImplicitParam(name="dltbID", value="\u56fe\u6591id")
    @GetMapping(value={"/dltb/wyhc"})
    public Response<DataQueryResult> queryWYHCData(@RequestParam String dltbID) {
        return Response.ok((Object)this.oneCodeQueryService.queryWYHCData(dltbID));
    }

    @ApiOperation(value="09-\u4e3e\u8bc1\u7167\u7247\u5217\u8868")
    @ApiImplicitParam(name="dltbID", value="\u56fe\u6591id")
    @GetMapping(value={"/dltb/jzzp"})
    public Response<List<RelateFileDTO>> queryJuZhengPictures(@RequestParam String dltbID) {
        return Response.ok(this.oneCodeQueryService.queryJuZhengPictures(dltbID));
    }

    @ApiOperation(value="10-\u4e3e\u8bc1\u7167\u7247\u9884\u89c8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tbID", value="\u56fe\u6591id"), @ApiImplicitParam(name="filePath", value="\u56fe\u7247\u8def\u5f84")})
    @GetMapping(value={"/dltb/jzzp/preview"})
    public void previewJuZhengPicture(String tbID, String filePath, HttpServletRequest request, HttpServletResponse response) {
        this.oneCodeQueryService.previewTBAttachment(tbID, filePath, request, response);
    }

    @ApiOperation(value="11-\u6839\u636e\u6807\u8bc6\u7801\u67e5\u8be2\u5b9e\u4f53\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="bsm", value="\u6807\u8bc6\u7801")})
    @GetMapping(value={"/dltb/byBSM"})
    public Response<TbDTO> previewJuZhengPicture(String bsm) {
        return Response.ok((Object)this.oneCodeQueryService.queryEntityByBSM(bsm));
    }
}

