/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onecode.api.config;

import com.geoway.adf.dms.common.util.StringUtil;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableAutoConfiguration(exclude={FlywayAutoConfiguration.class})
@EnableTransactionManagement
public class OneCodeFlywayConfig {
    private static final Logger log = LoggerFactory.getLogger(OneCodeFlywayConfig.class);
    private final String BASE_SQL_LOCATION = "onecode/db/sql";
    private final String ENCODING = "UTF-8";
    private final String baselineVersion = "20240913";
    @Value(value="${flyway.onecode.enabled:true}")
    private Boolean enabled;
    @Value(value="${flyway.onecode.defaultSchema:public}")
    private String defaultSchema;
    @Value(value="${flyway.onecode.datasource:#{null}}")
    private String datasourceName;

    @Autowired
    public void migrate(ApplicationContext applicationContext) {
        try {
            if (this.enabled.booleanValue()) {
                DataSource dataSource = StringUtil.isEmptyOrWhiteSpace((String)this.datasourceName) ? (DataSource)applicationContext.getBean(DataSource.class) : (DataSource)applicationContext.getBean(this.datasourceName, DataSource.class);
                Flyway flyway = Flyway.configure().dataSource(dataSource).locations(new String[]{"onecode/db/sql"}).encoding("UTF-8").placeholderReplacement(false).cleanDisabled(true).validateOnMigrate(true).baselineOnMigrate(true).baselineVersion("20240913").defaultSchema(this.defaultSchema).table("t_onecode_history").load();
                flyway.migrate();
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5e93\u66f4\u65b0\u5931\u8d25", (Throwable)e);
        }
    }
}

