/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.onecode.api.service;

import cn.hutool.core.lang.Assert;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.edit.ResDatasetNodeOtherConfig;
import com.geoway.adf.dms.catalog.entity.AppCatalogNode;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.catalog.service.ResCatalogNodeService;
import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.util.FileViewerUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.frontscheme.FrontSchemeDTO;
import com.geoway.adf.dms.config.service.FrontSchemeService;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.FeatureResult;
import com.geoway.adf.dms.datasource.dto.query.ReturnField;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.ICursor;
import com.geoway.adf.gis.geodb.cursor.IRow;
import com.geoway.onecode.api.dao.ResultsCatalogConfigDao;
import com.geoway.onecode.api.dto.RelateFileDTO;
import com.geoway.onecode.api.entity.ResultsCatalogConfig;
import java.io.File;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class RelatedResultsService {
    private static final Logger log = LoggerFactory.getLogger(RelatedResultsService.class);
    @Resource
    private ResultsCatalogConfigDao resultsCatalogConfigDao;
    @Resource
    private FrontSchemeService frontSchemeService;
    private final String scheme_type = "onecode_catalog";
    private final String scheme_name = "\u6210\u679c\u76ee\u5f55";
    @Resource
    private AppCatalogNodeService appCatalogNodeService;
    @Resource
    private ResCatalogNodeService resCatalogNodeService;
    @Resource
    private GeoDatabaseService geoDatabaseService;

    public String getResultsCatalog() {
        try {
            FrontSchemeDTO schemeDTO = this.frontSchemeService.getDetail("onecode_catalog", "\u6210\u679c\u76ee\u5f55");
            if (schemeDTO == null) {
                return null;
            }
            return schemeDTO.getContent();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6210\u679c\u76ee\u5f55", (Throwable)e);
            return null;
        }
    }

    public void saveResultsCatalog(String catalogId) {
        FrontSchemeDTO schemeDTO = null;
        try {
            schemeDTO = this.frontSchemeService.getDetail("onecode_catalog", "\u6210\u679c\u76ee\u5f55");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6210\u679c\u76ee\u5f55", (Throwable)e);
        }
        if (schemeDTO == null) {
            schemeDTO = new FrontSchemeDTO();
            schemeDTO.setType("onecode_catalog");
            schemeDTO.setName("\u6210\u679c\u76ee\u5f55");
            schemeDTO.setContent(catalogId);
            this.frontSchemeService.add(schemeDTO);
        } else {
            schemeDTO.setContent(catalogId);
            this.frontSchemeService.update(schemeDTO);
        }
    }

    public ResultsCatalogConfig getResultsNodeConfig(String nodeId) {
        return this.resultsCatalogConfigDao.selectByPrimaryKey(nodeId);
    }

    public void saveResultsNodeConfig(ResultsCatalogConfig config) {
        Assert.notNull((Object)config.getNodeId(), (String)"\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResultsCatalogConfig existConfig = this.resultsCatalogConfigDao.selectByPrimaryKey(config.getNodeId());
        if (existConfig == null) {
            this.resultsCatalogConfigDao.insert(config);
        } else {
            this.resultsCatalogConfigDao.updateByPrimaryKey(config);
        }
    }

    public List<ResultsCatalogConfig> getAllConfigNodes() {
        List<ResultsCatalogConfig> catalogConfigs = this.resultsCatalogConfigDao.selectAll();
        return catalogConfigs;
    }

    public List<RelateFileDTO> queryProjectAttachmentFiles(String nodeId, String projectName) {
        ResultsCatalogConfig config = this.resultsCatalogConfigDao.selectByPrimaryKey(nodeId);
        if (config == null || StringUtil.isEmptyOrWhiteSpace((String)config.getAttachmentPath())) {
            log.error(nodeId + "\u8282\u70b9\u672a\u914d\u7f6e\u9644\u4ef6\u8def\u5f84");
            return new ArrayList<RelateFileDTO>();
        }
        return this.queryAttachmentFiles(config.getAttachmentPath(), projectName);
    }

    public List<RelateFileDTO> queryAttachmentFiles(String path, String name) {
        File rootFolder = new File(path);
        RelateFileDTO tree = RelatedResultsService.searchFiles(rootFolder, name, false);
        if (tree != null) {
            return tree.getChildren();
        }
        return new ArrayList<RelateFileDTO>();
    }

    public void previewNodeAttachment(String nodeId, String filePath, HttpServletRequest request, HttpServletResponse response) {
        ResultsCatalogConfig config = this.resultsCatalogConfigDao.selectByPrimaryKey(nodeId);
        if (config == null) {
            throw new RuntimeException("\u8282\u70b9\u672a\u914d\u7f6e\u9644\u4ef6\u8def\u5f84");
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new RuntimeException("\u9644\u4ef6\u4e0d\u5b58\u5728");
        }
        FileViewerUtil.viewFile((File)file, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    public DataQueryResult queryProjectData(String nodeId, String keyword) {
        AppCatalogNode appCatalogNode = this.appCatalogNodeService.selectByNodeId(nodeId);
        Assert.notNull((Object)appCatalogNode, (String)"\u8282\u70b9\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogNodeService.getNodeDetail(appCatalogNode.getResNodeId());
        ResCatalogDataNodeDTO dataNodeDTO = (ResCatalogDataNodeDTO)resCatalogNodeDTO;
        ResDatasetNodeOtherConfig otherConfig = dataNodeDTO.getOtherConfig();
        if (otherConfig == null || StringUtil.isEmptyOrWhiteSpace((String)otherConfig.getNameField()) || StringUtil.isEmptyOrWhiteSpace((String)otherConfig.getAreaField())) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u9879\u76ee\u540d\u79f0\u5b57\u6bb5\u6216\u9762\u79ef\u5b57\u6bb5");
        }
        FeatureClassDTO datasetDTO = (FeatureClassDTO)dataNodeDTO.getDataset();
        IFeatureWorkspace workspace = this.geoDatabaseService.openGeoWorkspace(datasetDTO.getDsKey());
        ICursor cursor = null;
        try {
            ArrayList<FeatureResult> datas = new ArrayList<FeatureResult>();
            String projectNameFld = otherConfig.getNameField();
            String areaFld = otherConfig.getAreaField();
            String tableName = datasetDTO.getFullName();
            String shapeFld = datasetDTO.getShapeField();
            String countFld = "f_count";
            String where = StringUtil.isEmptyOrWhiteSpace((String)keyword) ? String.format("%s is not null and %s <> ''", projectNameFld, projectNameFld) : String.format("%s like '%%%s%%'", projectNameFld, keyword.trim());
            String sql = MessageFormat.format("select {0},count({0}) as f_count,sum({1}) as {1},min(st_xmin({2})) as xmin,min(st_ymin({2})) as ymin,max(st_xmax({2})) as xmax,max(st_ymax({2})) as ymax from {3} where {4} group by {0}", projectNameFld, areaFld, shapeFld, tableName, where);
            cursor = workspace.excuteQuerySql(sql);
            IRow row = cursor.nextRow();
            while (row != null) {
                LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
                attributes.put(projectNameFld, row.getValue(projectNameFld));
                attributes.put(countFld, row.getValue(countFld));
                attributes.put(areaFld, row.getValue(areaFld));
                ExtentDTO extentDTO = new ExtentDTO();
                extentDTO.setXmin(Double.valueOf((Double)row.getValue("xmin")));
                extentDTO.setYmin(Double.valueOf((Double)row.getValue("ymin")));
                extentDTO.setXmax(Double.valueOf((Double)row.getValue("xmax")));
                extentDTO.setYmax(Double.valueOf((Double)row.getValue("ymax")));
                FeatureResult featureResult = new FeatureResult();
                featureResult.setAttributes(attributes);
                featureResult.setExtent(extentDTO);
                datas.add(featureResult);
                row = cursor.nextRow();
            }
            DataQueryResult dataQueryResult = new DataQueryResult();
            dataQueryResult.setId(datasetDTO.getId());
            dataQueryResult.setName(datasetDTO.getName());
            dataQueryResult.setAliasName(datasetDTO.getAliasName());
            dataQueryResult.setData(datas);
            dataQueryResult.setFields(new ArrayList());
            dataQueryResult.getFields().add(new ReturnField(projectNameFld, "\u9879\u76ee\u540d\u79f0"));
            dataQueryResult.getFields().add(new ReturnField(countFld, "\u5730\u5757\u6570\u91cf"));
            dataQueryResult.getFields().add(new ReturnField(areaFld, "\u5730\u5757\u9762\u79ef"));
            DataQueryResult dataQueryResult2 = dataQueryResult;
            return dataQueryResult2;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8282\u70b9[" + appCatalogNode.getNodeName() + "]\u67e5\u8be2\u5931\u8d25", e);
        }
        finally {
            if (cursor != null) {
                cursor.release();
            }
            if (workspace != null) {
                workspace.close();
            }
        }
    }

    private static RelateFileDTO searchFiles(File folder, String keyword, boolean returnEmptyFolder) {
        RelateFileDTO node = new RelateFileDTO(folder.getAbsolutePath(), folder.getName(), folder.isDirectory(), new Date(folder.lastModified()));
        File[] files = folder.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (file.isDirectory()) {
                    RelateFileDTO childNode = RelatedResultsService.searchFiles(file, keyword, returnEmptyFolder);
                    if (childNode == null) continue;
                    node.addChild(childNode);
                    continue;
                }
                if (!StringUtil.isEmptyOrWhiteSpace((String)keyword) && !file.getName().contains(keyword)) continue;
                node.addChild(new RelateFileDTO(file.getAbsolutePath(), file.getName(), false, new Date(folder.lastModified())));
            }
        }
        if (returnEmptyFolder) {
            return node;
        }
        return node.getChildren().isEmpty() && node.getIsDirectory() != false ? null : node;
    }
}

